/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.IdeView;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScratchFileCreationHelper {
    public static final LanguageExtension<ScratchFileCreationHelper> EXTENSION = new LanguageExtension("com.intellij.scratch.creationHelper", (Object)new ScratchFileCreationHelper(){});

    public boolean prepareText(@NotNull Project project, @NotNull Context context, @NotNull DataContext dataContext) {
        if (project == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(2);
        }
        return false;
    }

    public void beforeCreate(@NotNull Project project, @NotNull Context context) {
        if (project == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(4);
        }
    }

    @Nullable
    public static PsiFile parseHeader(@NotNull Project project, @NotNull Language language, @NotNull String text2) {
        if (project == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(5);
        }
        if (language == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(7);
        }
        LanguageFileType fileType = language.getAssociatedFileType();
        String fileSnippet = StringUtil.first((String)text2, (int)10240, (boolean)false);
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)project);
        return fileFactory.createFileFromText(PathUtil.makeFileName((String)"a", (String)(fileType == null ? "" : fileType.getDefaultExtension())), language, (CharSequence)fileSnippet);
    }

    @NotNull
    public static String reformat(@NotNull Project project, @NotNull Language language, @NotNull String text2) {
        if (project == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(8);
        }
        if (language == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(10);
        }
        String string = (String)WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            PsiFile psi = ScratchFileCreationHelper.parseHeader(project, language, text2);
            if (psi != null) {
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psi);
            }
            return psi == null ? text2 : psi.getText();
        });
        if (string == null) {
            ScratchFileCreationHelper.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchFileCreationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileCreationHelper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "reformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeCreate";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseHeader";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Context {
        @NotNull
        public String text = "";
        public Language language;
        public int caretOffset;
        public String filePrefix;
        public Factory<Integer> fileCounter;
        public String fileExtension;
        public ScratchFileService.Option createOption = ScratchFileService.Option.create_new_always;
        public IdeView ideView;
    }
}

