/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchUtil {
    private ScratchUtil() {
    }

    public static boolean isScratch(@Nullable VirtualFile file2) {
        RootType rootType = RootType.forFile((VirtualFile)file2);
        return rootType != null && !rootType.isHidden();
    }

    public static void updateFileExtension(@NotNull Project project, @Nullable VirtualFile file2) throws IOException {
        LanguageFileType currType;
        if (project == null) {
            ScratchUtil.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            throw new AssertionError((Object)"command required");
        }
        if (file2 == null) {
            return;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
        FileType prevType = ScratchUtil.getFileTypeFromName(file2);
        LanguageFileType languageFileType = currType = language == null ? null : language.getAssociatedFileType();
        if (prevType == currType) {
            return;
        }
        String prevExt = PathUtil.makeFileName((String)"", (String)(prevType == null ? "" : prevType.getDefaultExtension()));
        String currExt = currType == null ? "" : currType.getDefaultExtension();
        String nameWithoutExtension = prevExt.length() > 0 && file2.getName().endsWith(prevExt) ? StringUtil.trimEnd((String)file2.getName(), (String)prevExt) : file2.getNameWithoutExtension();
        VirtualFile parent = file2.getParent();
        String newName2 = parent != null ? VfsUtil.getNextAvailableName((VirtualFile)parent, (String)nameWithoutExtension, (String)currExt) : PathUtil.makeFileName((String)nameWithoutExtension, (String)currExt);
        file2.rename(ScratchUtil.class, newName2);
    }

    public static boolean hasMatchingExtension(@NotNull Project project, @NotNull VirtualFile file2) {
        LanguageFileType actual;
        if (project == null) {
            ScratchUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ScratchUtil.$$$reportNull$$$0(2);
        }
        if (file2.getExtension() == null) {
            return true;
        }
        FileType expected = ScratchUtil.getFileTypeFromName(file2);
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
        LanguageFileType languageFileType = actual = language == null ? null : language.getAssociatedFileType();
        if (expected != null && expected == actual) {
            return true;
        }
        String ext = actual == null ? "" : actual.getDefaultExtension();
        return ext.length() > 0 && file2.getName().endsWith(ext);
    }

    @Nullable
    private static FileType getFileTypeFromName(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ScratchUtil.$$$reportNull$$$0(3);
        }
        if (file2.getExtension() == null) {
            return null;
        }
        FileType result2 = FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence());
        if (result2 == UnknownFileType.INSTANCE || StringUtil.isEmpty((String)result2.getDefaultExtension())) {
            return null;
        }
        return result2;
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project, @NotNull VirtualFile file2) {
        int idx;
        if (project == null) {
            ScratchUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            ScratchUtil.$$$reportNull$$$0(5);
        }
        RootType rootType = Objects.requireNonNull(RootType.forFile((VirtualFile)file2));
        String rootPath = ScratchFileService.getInstance().getRootPath(rootType);
        VirtualFile rootFile = LocalFileSystem.getInstance().findFileByPath(rootPath);
        if (rootFile == null || !VfsUtilCore.isAncestor((VirtualFile)rootFile, (VirtualFile)file2, (boolean)false)) {
            throw new AssertionError((Object)file2.getPath());
        }
        StringBuilder sb = new StringBuilder();
        VirtualFile o = file2;
        while (!rootFile.equals(o)) {
            String part = StringUtil.notNullize((String)rootType.substituteName(project, o), (String)o.getName());
            if (sb.length() == 0 && part.indexOf(47) > -1) {
                part = part.substring(part.lastIndexOf(47) + 1);
            }
            sb.insert(0, "/" + part);
            o = o.getParent();
        }
        sb.insert(0, rootType.getDisplayName());
        if (sb.charAt(sb.length() - 1) == ']' && (idx = sb.lastIndexOf(" [")) > 0 && sb.indexOf("/" + sb.substring(idx + 2, sb.length() - 1) + "/") < idx) {
            sb.setLength(idx);
        }
        String string = sb.toString();
        if (string == null) {
            ScratchUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateFileExtension";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchingExtension";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeFromName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

