/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ScreenAreaConsumer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PopupLocationTracker {
    private static final Collection<ScreenAreaConsumer> ourAreaConsumers = new LinkedHashSet<ScreenAreaConsumer>();

    public static boolean register(final @NotNull ScreenAreaConsumer consumer2) {
        if (consumer2 == null) {
            PopupLocationTracker.$$$reportNull$$$0(0);
        }
        if (!Registry.is((String)"ide.use.screen.area.tracker", (boolean)false)) {
            return true;
        }
        if (!Disposer.isDisposed((Disposable)consumer2) && ourAreaConsumers.add(consumer2)) {
            Disposer.register((Disposable)consumer2, (Disposable)new Disposable(){

                public void dispose() {
                    ourAreaConsumers.remove(consumer2);
                }
            });
            return true;
        }
        return false;
    }

    public static boolean canRectangleBeUsed(@NotNull Component parent, @NotNull Rectangle desiredScreenBounds, @Nullable ScreenAreaConsumer excludedConsumer) {
        if (parent == null) {
            PopupLocationTracker.$$$reportNull$$$0(1);
        }
        if (desiredScreenBounds == null) {
            PopupLocationTracker.$$$reportNull$$$0(2);
        }
        if (!Registry.is((String)"ide.use.screen.area.tracker", (boolean)false)) {
            return true;
        }
        Window window = ComponentUtil.getWindow((Component)parent);
        if (window != null) {
            for (ScreenAreaConsumer consumer2 : ourAreaConsumers) {
                Rectangle area;
                if (consumer2 == excludedConsumer || window != consumer2.getUnderlyingWindow() || !(area = consumer2.getConsumedScreenBounds()).intersects(desiredScreenBounds)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desiredScreenBounds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ui/PopupLocationTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canRectangleBeUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

