/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.tabActions.CloseTab;
import com.intellij.openapi.fileEditor.impl.text.FileDropHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsBorder;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.EditorTabPainterAdapter;
import com.intellij.ui.tabs.impl.JBEditorTabsBorder;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.SingleHeightTabs;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutSettingsManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorTabbedContainer
implements CloseAction.CloseTarget {
    private final EditorWindow myWindow;
    private final Project myProject;
    private final JBTabsEx myTabs;
    @NonNls
    public static final String HELP_ID = "ideaInterface.editor";
    private final TabInfo.DragOutDelegate myDragOutDelegate;

    EditorTabbedContainer(@NotNull EditorWindow window, @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (window == null) {
            EditorTabbedContainer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            EditorTabbedContainer.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            EditorTabbedContainer.$$$reportNull$$$0(2);
        }
        this.myDragOutDelegate = new MyDragOutDelegate();
        this.myWindow = window;
        this.myProject = project;
        this.myTabs = new EditorTabs(project, parentDisposable, window);
        this.myTabs.getComponent().setFocusable(false);
        this.myTabs.getComponent().setTransferHandler(new MyTransferHandler());
        this.myTabs.setDataProvider((DataProvider)new MyDataProvider()).setPopupGroup(() -> (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorTabPopupMenu"), "EditorTabPopup", false).addTabMouseListener((MouseListener)new TabMouseListener()).getPresentation().setTabDraggingEnabled(true).setTabLabelActionsMouseDeadzone(TimedDeadzone.NULL).setTabLabelActionsAutoHide(false).setActiveTabFillIn(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()).setPaintFocus(false).getJBTabs().addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                VirtualFile newFile;
                FileEditor newEditor;
                FileEditor oldEditor;
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)EditorTabbedContainer.this.myProject);
                FileEditor fileEditor = oldEditor = oldSelection != null ? editorManager.getSelectedEditor((VirtualFile)oldSelection.getObject()) : null;
                if (oldEditor != null) {
                    oldEditor.deselectNotify();
                }
                if ((newEditor = editorManager.getSelectedEditor(newFile = (VirtualFile)newSelection.getObject())) != null) {
                    newEditor.selectNotify();
                }
                if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{newFile});
                }
            }
        }).setSelectionChangeHandler((info, requestFocus, doChangeSelection) -> {
            ActionCallback result2 = new ActionCallback();
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(this.myProject)).onSelectionChanged();
                result2.notify(doChangeSelection.run());
            }, "EditorChange", null);
            return result2;
        });
        this.myTabs.getPresentation().setRequestFocusOnLastFocusedComponent(true);
        this.myTabs.getComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EditorTabbedContainer.this.myTabs.findInfo(e) != null || EditorTabbedContainer.this.isFloating()) {
                    return;
                }
                if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    EditorTabbedContainer.doHideAll(e);
                }
            }
        });
        this.setTabPlacement(UISettings.getInstance().getEditorTabPlacement());
        if (JBTabsImpl.NEW_TABS) {
            TabsLayoutInfo tabsLayoutInfo = TabsLayoutSettingsManager.getInstance().getSelectedTabsLayoutInfo();
            this.myTabs.updateTabsLayout(tabsLayoutInfo);
        }
    }

    public int getTabCount() {
        return this.myTabs.getTabCount();
    }

    @NotNull
    public ActionCallback setSelectedIndex(int indexToSelect) {
        ActionCallback actionCallback = this.setSelectedIndex(indexToSelect, true);
        if (actionCallback == null) {
            EditorTabbedContainer.$$$reportNull$$$0(3);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback setSelectedIndex(int indexToSelect, boolean focusEditor) {
        if (indexToSelect >= this.myTabs.getTabCount()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                EditorTabbedContainer.$$$reportNull$$$0(4);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.myTabs.select(this.myTabs.getTabAt(indexToSelect), focusEditor);
        if (actionCallback == null) {
            EditorTabbedContainer.$$$reportNull$$$0(5);
        }
        return actionCallback;
    }

    @NotNull
    public static DockableEditor createDockableEditor(Project project, Image image, VirtualFile file2, Presentation presentation2, EditorWindow window) {
        return new DockableEditor(project, image, file2, presentation2, window.getSize(), window.isFilePinned(file2));
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myTabs.getComponent();
        if (jComponent == null) {
            EditorTabbedContainer.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    public ActionCallback removeTabAt(int componentIndex, int indexToSelect, boolean transferFocus) {
        TabInfo toSelect2 = indexToSelect >= 0 && indexToSelect < this.myTabs.getTabCount() ? this.myTabs.getTabAt(indexToSelect) : null;
        TabInfo info = this.myTabs.getTabAt(componentIndex);
        if (info.isHidden() || !this.myProject.isOpen()) {
            toSelect2 = null;
        }
        ActionCallback callback2 = this.myTabs.removeTab(info, toSelect2, transferFocus);
        return this.myProject.isOpen() ? callback2 : ActionCallback.DONE;
    }

    public ActionCallback removeTabAt(int componentIndex, int indexToSelect) {
        return this.removeTabAt(componentIndex, indexToSelect, true);
    }

    public int getSelectedIndex() {
        return this.myTabs.getIndexOf(this.myTabs.getSelectedInfo());
    }

    void setForegroundAt(int index, @NotNull Color color) {
        if (color == null) {
            EditorTabbedContainer.$$$reportNull$$$0(7);
        }
        this.myTabs.getTabAt(index).setDefaultForeground(color);
    }

    void setStyleAt(int index, @SimpleTextAttributes.StyleAttributeConstant int style) {
        this.myTabs.getTabAt(index).setDefaultStyle(style);
    }

    void setWaveColor(int index, @Nullable Color color) {
        TabInfo tab = this.myTabs.getTabAt(index);
        tab.setDefaultWaveColor(color);
    }

    void setIconAt(int index, Icon icon2) {
        this.myTabs.getTabAt(index).setIcon(UISettings.getInstance().getShowFileIconInTabs() ? icon2 : null);
    }

    Icon getIconAt(int index) {
        return this.myTabs.getTabAt(index).getIcon();
    }

    void setTitleAt(int index, @NlsContexts.TabTitle @NotNull String text2) {
        if (text2 == null) {
            EditorTabbedContainer.$$$reportNull$$$0(8);
        }
        this.myTabs.getTabAt(index).setText(text2);
    }

    void setToolTipTextAt(int index, @NlsContexts.Tooltip String text2) {
        this.myTabs.getTabAt(index).setTooltipText(text2);
    }

    void setBackgroundColorAt(int index, @Nullable Color color) {
        this.myTabs.getTabAt(index).setTabColor(color);
    }

    void setTabLayoutPolicy(int policy) {
        switch (policy) {
            case 1: {
                this.myTabs.getPresentation().setSingleRow(true);
                break;
            }
            case 0: {
                this.myTabs.getPresentation().setSingleRow(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tab layout policy: " + policy);
            }
        }
    }

    public void setTabPlacement(int tabPlacement) {
        switch (tabPlacement) {
            case 1: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.top);
                break;
            }
            case 3: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.bottom);
                break;
            }
            case 2: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.left);
                break;
            }
            case 4: {
                this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.right);
                break;
            }
            case 0: {
                this.myTabs.getPresentation().setHideTabs(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tab placement code=" + tabPlacement);
            }
        }
    }

    void updateTabsLayout(@NotNull TabsLayoutInfo newTabsLayoutInfo) {
        if (newTabsLayoutInfo == null) {
            EditorTabbedContainer.$$$reportNull$$$0(9);
        }
        this.myTabs.updateTabsLayout(newTabsLayoutInfo);
    }

    @Nullable
    public Object getSelectedComponent(boolean ignorePopup) {
        TabInfo info = ignorePopup ? this.myTabs.getSelectedInfo() : this.myTabs.getTargetInfo();
        return info != null ? info.getComponent() : null;
    }

    public void insertTab(@NotNull VirtualFile file2, Icon icon2, @NotNull JComponent component2, @Nullable @NlsContexts.Tooltip String tooltip, int indexToInsert, @NotNull Disposable parentDisposable) {
        TabInfo tab;
        if (file2 == null) {
            EditorTabbedContainer.$$$reportNull$$$0(10);
        }
        if (component2 == null) {
            EditorTabbedContainer.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            EditorTabbedContainer.$$$reportNull$$$0(12);
        }
        if ((tab = this.myTabs.findInfo((Object)file2)) != null) {
            return;
        }
        tab = new TabInfo(component2).setText(EditorTabPresentationUtil.getEditorTabTitle(this.myProject, file2, this.myWindow)).setTabColor(EditorTabPresentationUtil.getEditorTabBackgroundColor(this.myProject, file2, this.myWindow)).setIcon(UISettings.getInstance().getShowFileIconInTabs() ? icon2 : null).setTooltipText(tooltip).setObject((Object)file2).setDragOutDelegate(this.myDragOutDelegate);
        tab.setTestableUi((Queryable)new MyQueryable(tab));
        CloseTab closeTab = new CloseTab(component2, file2, this.myProject, this.myWindow, parentDisposable);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)component2);
        DefaultActionGroup editorActionGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("EditorTabActionGroup");
        DefaultActionGroup group2 = new DefaultActionGroup();
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"EditorTabActionGroup", null, (DataContext)dataContext);
        for (AnAction action2 : editorActionGroup.getChildren(event)) {
            if (action2 instanceof ActionGroup) {
                group2.addAll(((ActionGroup)action2).getChildren(event));
                continue;
            }
            group2.addAction(action2);
        }
        group2.addAction((AnAction)closeTab, Constraints.LAST);
        tab.setTabLabelActions((ActionGroup)group2, "EditorTab");
        this.myTabs.addTabSilently(tab, indexToInsert);
    }

    boolean isEmptyVisible() {
        return this.myTabs.isEmptyVisible();
    }

    public JBTabs getTabs() {
        return this.myTabs;
    }

    public void requestFocus(boolean forced) {
        if (this.myTabs != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTabs.getComponent(), forced);
        }
    }

    @Deprecated
    @NotNull
    public static String calcTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            EditorTabbedContainer.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            EditorTabbedContainer.$$$reportNull$$$0(14);
        }
        String string = EditorTabPresentationUtil.getEditorTabTitle(project, file2, null);
        if (string == null) {
            EditorTabbedContainer.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public static String calcFileName(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            EditorTabbedContainer.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            EditorTabbedContainer.$$$reportNull$$$0(17);
        }
        String string = EditorTabPresentationUtil.getUniqueEditorTabTitle(project, file2, null);
        if (string == null) {
            EditorTabbedContainer.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public static Color calcTabColor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            EditorTabbedContainer.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            EditorTabbedContainer.$$$reportNull$$$0(20);
        }
        return EditorTabPresentationUtil.getEditorTabBackgroundColor(project, file2, null);
    }

    public Component getComponentAt(int i2) {
        TabInfo tab = this.myTabs.getTabAt(i2);
        return tab.getComponent();
    }

    @Override
    public void close() {
        TabInfo selected2 = this.myTabs.getTargetInfo();
        if (selected2 == null) {
            return;
        }
        FileEditorManagerEx.getInstanceEx(this.myProject).closeFile((VirtualFile)selected2.getObject(), this.myWindow);
    }

    private boolean isFloating() {
        return this.myWindow.getOwner().isFloating();
    }

    private static void doHideAll(@NotNull MouseEvent e) {
        if (e == null) {
            EditorTabbedContainer.$$$reportNull$$$0(21);
        }
        if (!Registry.is((String)"editor.maximize.on.double.click")) {
            return;
        }
        ActionManager mgr = ActionManager.getInstance();
        mgr.tryToExecute(mgr.getAction("HideAllWindows"), (InputEvent)e, null, "unknown", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 1: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTabsLayoutInfo";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setSelectedIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTabTitle";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setForegroundAt";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTitleAt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateTabsLayout";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insertTab";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calcTabTitle";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calcFileName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calcTabColor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doHideAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EditorTabs
    extends SingleHeightTabs
    implements ComponentWithMnemonics {
        @NotNull
        private final EditorWindow myWindow;
        private boolean active;

        private EditorTabs(Project project, @NotNull Disposable parentDisposable, @NotNull EditorWindow window) {
            if (parentDisposable == null) {
                EditorTabs.$$$reportNull$$$0(0);
            }
            if (window == null) {
                EditorTabs.$$$reportNull$$$0(1);
            }
            super(project, parentDisposable);
            this.myWindow = window;
            UIUtil.addAwtListener(e -> this.updateActive(), (long)4L, (Disposable)parentDisposable);
            this.setUiDecorator(() -> new UiDecorator.UiDecoration(null, JBUI.CurrentTheme.EditorTabs.tabInsets()));
            project.getMessageBus().connect(parentDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

                public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                    if (source == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.updateActive();
                }

                public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                    if (source == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (file2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.updateActive();
                }

                public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    this.updateActive();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "source";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$EditorTabs$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fileOpened";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fileClosed";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "selectionChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            this.drawBorder(g);
        }

        @NotNull
        protected TabLabel createTabLabel(@NotNull TabInfo info) {
            if (info == null) {
                EditorTabs.$$$reportNull$$$0(2);
            }
            return new SingleHeightTabs.SingleHeightLabel((JBTabsImpl)this, info){

                protected int getPreferredHeight() {
                    Insets insets = this.getInsets();
                    Insets layoutInsets = this.getLayoutInsets();
                    insets.top += layoutInsets.top;
                    insets.bottom += layoutInsets.bottom;
                    return super.getPreferredHeight() - insets.top - insets.bottom;
                }
            };
        }

        protected TabPainterAdapter createTabPainterAdapter() {
            return new EditorTabPainterAdapter();
        }

        protected JBTabsBorder createTabBorder() {
            return new JBEditorTabsBorder((JBTabsImpl)this);
        }

        @NotNull
        public ActionCallback select(@NotNull TabInfo info, boolean requestFocus) {
            if (info == null) {
                EditorTabs.$$$reportNull$$$0(3);
            }
            this.active = true;
            ActionCallback actionCallback = super.select(info, requestFocus);
            if (actionCallback == null) {
                EditorTabs.$$$reportNull$$$0(4);
            }
            return actionCallback;
        }

        private void updateActive() {
            this.checkActive();
            SwingUtilities.invokeLater(() -> this.checkActive());
        }

        private void checkActive() {
            boolean newActive = UIUtil.isFocusAncestor((Component)((Object)this));
            if (newActive != this.active) {
                this.active = newActive;
                this.revalidateAndRepaint();
            }
        }

        protected boolean isActiveTabs(TabInfo info) {
            return this.active;
        }

        @Nullable
        public TabInfo getToSelectOnRemoveOf(TabInfo info) {
            VirtualFile file2;
            int indexToSelect;
            int index = this.getIndexOf(info);
            if (index != -1 && (indexToSelect = this.myWindow.calcIndexToSelect(file2 = this.myWindow.getFileAt(index), index)) >= 0 && indexToSelect < this.getTabs().size()) {
                return this.getTabAt(indexToSelect);
            }
            return super.getToSelectOnRemoveOf(info);
        }

        public void revalidateAndRepaint(boolean layoutNow) {
            if (this.myWindow != null && this.myWindow.getOwner().isInsideChange()) {
                return;
            }
            super.revalidateAndRepaint(layoutNow);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$EditorTabs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$EditorTabs";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "select";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createTabLabel";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyTransferHandler
    extends TransferHandler {
        private final FileDropHandler myFileDropHandler = new FileDropHandler(null);

        private MyTransferHandler() {
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (this.myFileDropHandler.canHandleDrop(t.getTransferDataFlavors())) {
                this.myFileDropHandler.handleDrop(t, EditorTabbedContainer.this.myProject, EditorTabbedContainer.this.myWindow);
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return this.myFileDropHandler.canHandleDrop(transferFlavors);
        }
    }

    public static class DockableEditor
    implements DockableContent<VirtualFile> {
        final Image myImg;
        private final DockableEditorTabbedContainer myContainer;
        private final Presentation myPresentation;
        private final Dimension myPreferredSize;
        private final boolean myPinned;
        private final VirtualFile myFile;

        public DockableEditor(Project project, Image img, VirtualFile file2, Presentation presentation2, Dimension preferredSize, boolean isFilePinned) {
            this.myImg = img;
            this.myFile = file2;
            this.myPresentation = presentation2;
            this.myContainer = new DockableEditorTabbedContainer(project);
            this.myPreferredSize = preferredSize;
            this.myPinned = isFilePinned;
        }

        @NotNull
        public VirtualFile getKey() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                DockableEditor.$$$reportNull$$$0(0);
            }
            return virtualFile;
        }

        public Image getPreviewImage() {
            return this.myImg;
        }

        public Dimension getPreferredSize() {
            return this.myPreferredSize;
        }

        public String getDockContainerType() {
            return "file-editors";
        }

        public Presentation getPresentation() {
            return this.myPresentation;
        }

        public void close() {
            this.myContainer.close(this.myFile);
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public boolean isPinned() {
            return this.myPinned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$DockableEditor", "getKey"));
        }
    }

    class MyDragOutDelegate
    implements TabInfo.DragOutDelegate {
        private VirtualFile myFile;
        private DragSession mySession;

        MyDragOutDelegate() {
        }

        public void dragOutStarted(@NotNull MouseEvent mouseEvent, @NotNull TabInfo info) {
            if (mouseEvent == null) {
                MyDragOutDelegate.$$$reportNull$$$0(0);
            }
            if (info == null) {
                MyDragOutDelegate.$$$reportNull$$$0(1);
            }
            TabInfo previousSelection = info.getPreviousSelection();
            Image img = JBTabsImpl.getComponentImage((TabInfo)info);
            if (previousSelection == null) {
                previousSelection = EditorTabbedContainer.this.myTabs.getToSelectOnRemoveOf(info);
            }
            int dragStartIndex = EditorTabbedContainer.this.myTabs.getIndexOf(info);
            boolean isPinnedAtStart = info.isPinned();
            info.setHidden(true);
            if (previousSelection != null) {
                EditorTabbedContainer.this.myTabs.select(previousSelection, true);
            }
            this.myFile = (VirtualFile)info.getObject();
            this.myFile.putUserData(EditorWindow.DRAG_START_INDEX_KEY, (Object)dragStartIndex);
            this.myFile.putUserData(EditorWindow.DRAG_START_LOCATION_HASH_KEY, (Object)System.identityHashCode(EditorTabbedContainer.this.myTabs));
            this.myFile.putUserData(EditorWindow.DRAG_START_PINNED_KEY, (Object)isPinnedAtStart);
            Presentation presentation2 = new Presentation(info.getText());
            presentation2.setIcon(info.getIcon());
            this.mySession = this.getDockManager().createDragSession(mouseEvent, (DockableContent)EditorTabbedContainer.createDockableEditor(EditorTabbedContainer.this.myProject, img, this.myFile, presentation2, EditorTabbedContainer.this.myWindow));
        }

        private DockManager getDockManager() {
            return DockManager.getInstance((Project)EditorTabbedContainer.this.myProject);
        }

        public void processDragOut(@NotNull MouseEvent event, @NotNull TabInfo source) {
            if (event == null) {
                MyDragOutDelegate.$$$reportNull$$$0(2);
            }
            if (source == null) {
                MyDragOutDelegate.$$$reportNull$$$0(3);
            }
            this.mySession.process(event);
        }

        public void dragOutFinished(@NotNull MouseEvent event, TabInfo source) {
            boolean copy2;
            if (event == null) {
                MyDragOutDelegate.$$$reportNull$$$0(4);
            }
            boolean bl = copy2 = UIUtil.isControlKeyDown((MouseEvent)event) || this.mySession.getResponse(event) == DockContainer.ContentResponse.ACCEPT_COPY;
            if (!copy2) {
                this.myFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, (Object)Boolean.TRUE);
                FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject).closeFile(this.myFile, EditorTabbedContainer.this.myWindow);
            } else {
                source.setHidden(false);
            }
            this.mySession.process(event);
            if (!copy2) {
                this.myFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
            }
            this.myFile = null;
            this.mySession = null;
        }

        public void dragOutCancelled(TabInfo source) {
            source.setHidden(false);
            if (this.mySession != null) {
                this.mySession.cancel();
            }
            this.myFile = null;
            this.mySession = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$MyDragOutDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragOutStarted";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDragOut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragOutFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TabMouseListener
    extends MouseAdapter {
        private int myActionClickCount;

        private TabMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TabInfo info;
            if (UIUtil.isCloseClick((MouseEvent)e, (int)502) && (info = EditorTabbedContainer.this.myTabs.findInfo(e)) != null) {
                IdeEventQueue.getInstance().blockNextEvents(e);
                if (e.isAltDown() && e.getButton() == 1) {
                    List allTabInfos = EditorTabbedContainer.this.myTabs.getTabs();
                    for (TabInfo tabInfo : allTabInfos) {
                        if (tabInfo == info) continue;
                        FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject).closeFile((VirtualFile)tabInfo.getObject(), EditorTabbedContainer.this.myWindow);
                    }
                } else {
                    FileEditorManagerEx.getInstanceEx(EditorTabbedContainer.this.myProject).closeFile((VirtualFile)info.getObject(), EditorTabbedContainer.this.myWindow);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (UIUtil.isActionClick((MouseEvent)e)) {
                Component deepestComponent;
                if (e.getClickCount() == 1) {
                    this.myActionClickCount = 0;
                }
                if (!((deepestComponent = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY())) instanceof InplaceButton)) {
                    ++this.myActionClickCount;
                }
                if (this.myActionClickCount > 1 && !EditorTabbedContainer.this.isFloating()) {
                    EditorTabbedContainer.doHideAll(e);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (UIUtil.isActionClick((MouseEvent)e, (int)500) && (e.isMetaDown() || !SystemInfo.isMac && e.isControlDown())) {
                Object o;
                TabInfo info = EditorTabbedContainer.this.myTabs.findInfo(e);
                Object object = o = info == null ? null : info.getObject();
                if (o instanceof VirtualFile) {
                    ShowFilePathAction.show((VirtualFile)o, e);
                }
            }
        }
    }

    private final class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        public Object getData(@NotNull @NonNls String dataId) {
            TabInfo selected2;
            if (dataId == null) {
                MyDataProvider.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return EditorTabbedContainer.this.myProject;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile selectedFile = EditorTabbedContainer.this.myWindow.getSelectedFile();
                return selectedFile != null && selectedFile.isValid() ? selectedFile : null;
            }
            if (EditorWindow.DATA_KEY.is(dataId)) {
                return EditorTabbedContainer.this.myWindow;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return EditorTabbedContainer.HELP_ID;
            }
            if (CloseAction.CloseTarget.KEY.is(dataId) && (selected2 = EditorTabbedContainer.this.myTabs.getSelectedInfo()) != null) {
                return EditorTabbedContainer.this;
            }
            if (EditorWindow.DATA_KEY.is(dataId)) {
                return EditorTabbedContainer.this.myWindow;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$MyDataProvider", "getData"));
        }
    }

    private static class MyQueryable
    implements Queryable {
        private final TabInfo myTab;

        MyQueryable(TabInfo tab) {
            this.myTab = tab;
        }

        public void putInfo(@NotNull Map<String, String> info) {
            if (info == null) {
                MyQueryable.$$$reportNull$$$0(0);
            }
            info.put("editorTab", this.myTab.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/fileEditor/impl/EditorTabbedContainer$MyQueryable", "putInfo"));
        }
    }
}

