/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.EditorWindowTracker;
import com.intellij.psi.impl.source.tree.injected.EditorWindowTrackerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.InjectionBackgroundSuppressor;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.ObjectUtils;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class InjectedLanguageUtil
extends InjectedLanguageUtilBase {
    public static final Key<IElementType> INJECTED_FRAGMENT_TYPE = Key.create((String)"INJECTED_FRAGMENT_TYPE");
    public static final Key<Boolean> FRANKENSTEIN_INJECTION = InjectedLanguageManager.FRANKENSTEIN_INJECTION;
    private static final Comparator<PsiFile> LONGEST_INJECTION_HOST_RANGE_COMPARATOR = Comparator.comparing(psiFile -> InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile), Comparator.nullsLast(Comparator.comparingInt(PsiElement::getTextLength)));

    public static void enumerate(@NotNull DocumentWindow documentWindow, @NotNull PsiFile hostPsiFile, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiElement element2;
        Segment[] ranges;
        if (documentWindow == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(0);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(1);
        }
        if (visitor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(2);
        }
        Segment rangeMarker = (ranges = documentWindow.getHostRanges()).length > 0 ? ranges[0] : null;
        PsiElement psiElement = element2 = rangeMarker == null ? null : hostPsiFile.findElementAt(rangeMarker.getStartOffset());
        if (element2 != null) {
            InjectedLanguageUtil.enumerate(element2, hostPsiFile, true, visitor);
        }
    }

    @Contract(value="null,_->null;!null,_->!null")
    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file2) {
        if (editor == null || file2 == null || editor instanceof EditorWindow) {
            return editor;
        }
        int offset = editor.getCaretModel().getOffset();
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2, offset);
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable Caret caret, @Nullable PsiFile file2) {
        if (editor == null || file2 == null || editor instanceof EditorWindow || caret == null) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, caret, injectedFile);
    }

    public static Caret getCaretForInjectedLanguageNoCommit(@Nullable Caret caret, @Nullable PsiFile file2) {
        if (caret == null || file2 == null || caret instanceof InjectedCaret) {
            return caret;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(caret.getEditor(), injectedFile);
        if (!(injectedEditor instanceof EditorWindow)) {
            return caret;
        }
        for (Caret injectedCaret : injectedEditor.getCaretModel().getAllCarets()) {
            if (((InjectedCaret)injectedCaret).getDelegate() != caret) continue;
            return injectedCaret;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiFileBase> T findInjectedFile(@NotNull PsiElement expression, @NotNull Class<T> classToFind) {
        List files2;
        if (expression == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(3);
        }
        if (classToFind == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(4);
        }
        if ((files2 = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles(expression)) == null) {
            return null;
        }
        for (Pair fileInfo : files2) {
            PsiElement injectedFile = (PsiElement)fileInfo.first;
            if (!classToFind.isAssignableFrom(injectedFile.getClass())) continue;
            return (T)((PsiFileBase)injectedFile);
        }
        return null;
    }

    @Contract(value="null,_,_->null;!null,_,_->!null")
    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file2, int offset) {
        if (editor == null || file2 == null || editor instanceof EditorWindow) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable PsiFile injectedFile) {
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(5);
        }
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, hostEditor.getCaretModel().getCurrentCaret(), injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable Caret hostCaret, @Nullable PsiFile injectedFile) {
        int selend;
        int selstart;
        Document document;
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(6);
        }
        if (injectedFile == null || hostEditor instanceof EditorWindow || hostEditor.isDisposed()) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(7);
            }
            return editor;
        }
        Project project = hostEditor.getProject();
        if (project == null) {
            project = injectedFile.getProject();
        }
        if (!((document = PsiDocumentManager.getInstance((Project)project).getDocument(injectedFile)) instanceof DocumentWindowImpl)) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(8);
            }
            return editor;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        if (hostCaret != null && hostCaret.hasSelection() && (selstart = hostCaret.getSelectionStart()) != -1 && !documentWindow.containsRange(selstart, selend = Math.max(selstart, hostCaret.getSelectionEnd()))) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(9);
            }
            return editor;
        }
        if (!documentWindow.isValid()) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(10);
            }
            return editor;
        }
        EditorWindowTrackerImpl tracker2 = (EditorWindowTrackerImpl)ApplicationManager.getApplication().getService(EditorWindowTracker.class);
        Editor editor = tracker2.createEditor(documentWindow, (EditorImpl)hostEditor, injectedFile);
        if (editor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(11);
        }
        return editor;
    }

    public static Editor openEditorFor(@NotNull PsiFile file2, @NotNull Project project) {
        Editor editor;
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(13);
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, -1), false)) == null || editor instanceof EditorWindow || editor.isDisposed()) {
            return editor;
        }
        if (document instanceof DocumentWindowImpl) {
            EditorWindowTrackerImpl tracker2 = (EditorWindowTrackerImpl)ApplicationManager.getApplication().getService(EditorWindowTracker.class);
            return tracker2.createEditor((DocumentWindowImpl)document, (EditorImpl)editor, file2);
        }
        return editor;
    }

    @NotNull
    public static Editor getTopLevelEditor(@NotNull Editor editor) {
        if (editor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(14);
        }
        Editor editor2 = InjectedLanguageEditorUtil.getTopLevelEditor(editor);
        if (editor2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(15);
        }
        return editor2;
    }

    public static boolean isInInjectedLanguagePrefixSuffix(@NotNull PsiElement element2) {
        PsiFile injectedFile;
        if (element2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(16);
        }
        if ((injectedFile = element2.getContainingFile()) == null) {
            return false;
        }
        Project project = injectedFile.getProject();
        InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)project);
        if (!languageManager.isInjectedFragment(injectedFile)) {
            return false;
        }
        TextRange elementRange = element2.getTextRange();
        List edibles = languageManager.intersectWithAllEditableFragments(injectedFile, elementRange);
        int combinedEdiblesLength = edibles.stream().mapToInt(TextRange::getLength).sum();
        return combinedEdiblesLength != elementRange.getLength();
    }

    public static int hostToInjectedUnescaped(DocumentWindow window, int hostOffset) {
        Place shreds = ((DocumentWindowImpl)window).getShreds();
        Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)shreds.get(0)).getHostRangeMarker();
        if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
            return ((PsiLanguageInjectionHost.Shred)shreds.get(0)).getPrefix().length();
        }
        StringBuilder chars = new StringBuilder();
        int unescaped = 0;
        for (int i2 = 0; i2 < shreds.size(); ++i2) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i2);
            int prefixLength = shred.getPrefix().length();
            int suffixLength = shred.getSuffix().length();
            PsiLanguageInjectionHost host = shred.getHost();
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            LiteralTextEscaper escaper = host == null ? null : host.createLiteralTextEscaper();
            unescaped += prefixLength;
            Segment currentRange = shred.getHostRangeMarker();
            if (currentRange != null) {
                Segment nextRange;
                Segment segment = nextRange = i2 == shreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)shreds.get(i2 + 1)).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    hostOffset = Math.min(hostOffset, currentRange.getEndOffset());
                    int inHost = hostOffset - currentRange.getStartOffset();
                    if (escaper != null && escaper.decode(rangeInsideHost, chars)) {
                        int found = ObjectUtils.binarySearch((int)0, (int)inHost, index -> Comparing.compare((int)escaper.getOffsetInHost(index, TextRange.create((int)0, (int)host.getTextLength())), (int)inHost));
                        return unescaped + (found >= 0 ? found : -found - 1);
                    }
                    return unescaped + inHost;
                }
                unescaped = escaper != null && escaper.decode(rangeInsideHost, chars) ? (unescaped += chars.length()) : (unescaped += currentRange.getEndOffset() - currentRange.getStartOffset());
                unescaped += suffixLength;
            }
            chars.setLength(0);
        }
        return unescaped - ((PsiLanguageInjectionHost.Shred)shreds.get(shreds.size() - 1)).getSuffix().length();
    }

    public static String getUnescapedText(@NotNull PsiFile file2, final @Nullable PsiElement startElement, final @Nullable PsiElement endElement) {
        InjectedLanguageManager manager;
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(17);
        }
        if ((manager = InjectedLanguageManager.getInstance((Project)file2.getProject())).getInjectionHost((PsiElement)file2) == null) {
            return file2.getText().substring(startElement == null ? 0 : startElement.getTextRange().getStartOffset(), endElement == null ? file2.getTextLength() : endElement.getTextRange().getStartOffset());
        }
        final StringBuilder sb = new StringBuilder();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            Boolean myState;
            {
                this.myState = startElement == null ? Boolean.TRUE : null;
            }

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 == startElement) {
                    this.myState = Boolean.TRUE;
                }
                if (element2 == endElement) {
                    this.myState = Boolean.FALSE;
                }
                if (Boolean.FALSE == this.myState) {
                    return;
                }
                if (Boolean.TRUE == this.myState && element2.getFirstChild() == null) {
                    sb.append(InjectedLanguageUtilBase.getUnescapedLeafText(element2, false));
                } else {
                    super.visitElement(element2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil$1", "visitElement"));
            }
        });
        return sb.toString();
    }

    @Nullable
    public static DocumentWindow getDocumentWindow(@NotNull PsiElement element2) {
        PsiFile file2;
        if (element2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(18);
        }
        if ((file2 = element2.getContainingFile()) == null) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            return ((VirtualFileWindow)virtualFile).getDocumentWindow();
        }
        return null;
    }

    public static boolean isHighlightInjectionBackground(@Nullable PsiLanguageInjectionHost host) {
        return !(host instanceof InjectionBackgroundSuppressor);
    }

    public static int getInjectedStart(@NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
        if (places == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(19);
        }
        PsiLanguageInjectionHost.Shred shred = places.get(0);
        PsiLanguageInjectionHost host = shred.getHost();
        assert (host != null);
        return shred.getRangeInsideHost().getStartOffset() + host.getTextRange().getStartOffset();
    }

    @Nullable
    public static PsiElement findElementInInjected(@NotNull PsiLanguageInjectionHost injectionHost, int offset) {
        if (injectionHost == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(20);
        }
        Ref ref = Ref.create();
        InjectedLanguageUtil.enumerate((PsiElement)injectionHost, (injectedPsi, places) -> ref.set((Object)injectedPsi.findElementAt(offset - InjectedLanguageUtil.getInjectedStart(places))));
        return (PsiElement)ref.get();
    }

    public static <T> void putInjectedFileUserData(@NotNull PsiElement element2, @NotNull Language language, @NotNull Key<T> key, @Nullable T value2) {
        PsiFile file2;
        if (element2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(21);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(22);
        }
        if (key == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(23);
        }
        if ((file2 = InjectedLanguageUtil.getCachedInjectedFileWithLanguage(element2, language)) != null) {
            file2.putUserData(key, value2);
        }
    }

    @Deprecated
    public static <T> void putInjectedFileUserData(MultiHostRegistrar registrar, Key<T> key, T value2) {
        DeprecatedMethodException.report((String)"use putInjectedFileUserData(PsiElement, Language, Key, Object)} instead");
        InjectionResult result2 = ((InjectionRegistrarImpl)registrar).getInjectedResult();
        if (result2 != null && result2.files != null) {
            List<? extends PsiFile> files2 = result2.files;
            PsiFile file2 = files2.get(files2.size() - 1);
            file2.putUserData(key, value2);
        }
    }

    @Nullable
    public static PsiFile getCachedInjectedFileWithLanguage(@NotNull PsiElement element2, @NotNull Language language) {
        if (element2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(24);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(25);
        }
        if (!element2.isValid()) {
            return null;
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        return InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getCachedInjectedDocumentsInRange(containingFile, element2.getTextRange()).stream().map(documentWindow -> PsiDocumentManager.getInstance((Project)containingFile.getProject()).getPsiFile((Document)documentWindow)).filter(file2 -> file2 != null && file2.getLanguage() == LanguageSubstitutors.getInstance().substituteLanguage(language, file2.getVirtualFile(), file2.getProject())).max(LONGEST_INJECTION_HOST_RANGE_COMPARATOR).orElse(null);
    }

    public static void injectReference(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull String prefix, @NotNull String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
        if (registrar == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(26);
        }
        if (language == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(27);
        }
        if (prefix == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(29);
        }
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(30);
        }
        if (rangeInsideHost == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(31);
        }
        ((InjectionRegistrarImpl)registrar).injectReference(language, prefix, suffix, host, rangeInsideHost);
    }

    public static BooleanRunnable reparse(@NotNull PsiFile injectedPsiFile, @NotNull DocumentWindow injectedDocument, @NotNull PsiFile hostPsiFile, @NotNull Document hostDocument, @NotNull FileViewProvider hostViewProvider, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull PsiDocumentManagerBase documentManager) {
        VirtualFile hostVirtualFile;
        InjectedFileViewProvider provider2;
        VirtualFile oldInjectedVFile;
        Language language;
        BooleanRunnable runnable2;
        if (injectedPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(32);
        }
        if (injectedDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(33);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(34);
        }
        if (hostDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(35);
        }
        if (hostViewProvider == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(36);
        }
        if (indicator == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(37);
        }
        if (oldRoot == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(38);
        }
        if (newRoot == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(39);
        }
        if (documentManager == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(40);
        }
        if ((runnable2 = InjectionRegistrarImpl.reparse(language = injectedPsiFile.getLanguage(), (DocumentWindowImpl)injectedDocument, injectedPsiFile, (VirtualFileWindow)(oldInjectedVFile = (provider2 = (InjectedFileViewProvider)injectedPsiFile.getViewProvider()).getVirtualFile()), hostVirtualFile = hostViewProvider.getVirtualFile(), hostPsiFile, (DocumentEx)hostDocument, indicator, oldRoot, newRoot, documentManager)) == null) {
            ((EditorWindowTracker)ApplicationManager.getApplication().getService(EditorWindowTracker.class)).disposeEditorFor(injectedDocument);
        }
        return runnable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 1: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToFind";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsiFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedDocument";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostViewProvider";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "openEditorFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelEditor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInInjectedLanguagePrefixSuffix";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUnescapedText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentWindow";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedStart";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findElementInInjected";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "putInjectedFileUserData";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedFileWithLanguage";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "injectReference";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

