/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PoweredProgressIndicator;
import com.intellij.util.indexing.UnindexedFileStatus;
import com.intellij.util.indexing.UnindexedFilesFinder;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.SdkIndexableFilesIterator;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class UnindexedFilesUpdater
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesUpdater.class);
    private static final int DEFAULT_MAX_INDEXER_THREADS = 4;
    public static final ExecutorService GLOBAL_INDEXING_EXECUTOR = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Indexing", (int)UnindexedFilesUpdater.getMaxNumberOfIndexingThreads());
    @NotNull
    private static final Key<Boolean> CONTENT_SCANNED = Key.create((String)"CONTENT_SCANNED");
    @NotNull
    private static final Key<UnindexedFilesUpdater> RUNNING_TASK = Key.create((String)"RUNNING_INDEX_UPDATER_TASK");
    private static final Object ourLastRunningTaskLock = new Object();
    private final FileBasedIndexImpl myIndex;
    private final Project myProject;
    private final boolean myStartSuspended;
    private final boolean myRunExtensionsForFilesMarkedAsIndexed;
    private final PushedFilePropertiesUpdater myPusher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnindexedFilesUpdater(@NotNull Project project, boolean startSuspended, boolean runExtensionsForFilesMarkedAsIndexed) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(0);
        }
        super((Object)project);
        this.myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.myProject = project;
        this.myStartSuspended = startSuspended;
        this.myRunExtensionsForFilesMarkedAsIndexed = runExtensionsForFilesMarkedAsIndexed;
        this.myPusher = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
        this.myProject.putUserData(CONTENT_SCANNED, null);
        Object object = ourLastRunningTaskLock;
        synchronized (object) {
            UnindexedFilesUpdater runningTask = (UnindexedFilesUpdater)((Object)this.myProject.getUserData(RUNNING_TASK));
            if (runningTask != null) {
                DumbService.getInstance((Project)project).cancelTask((DumbModeTask)runningTask);
            }
            this.myProject.putUserData(RUNNING_TASK, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = ourLastRunningTaskLock;
        synchronized (object) {
            UnindexedFilesUpdater lastRunningTask = (UnindexedFilesUpdater)((Object)this.myProject.getUserData(RUNNING_TASK));
            if (lastRunningTask == this) {
                this.myProject.putUserData(RUNNING_TASK, null);
            }
        }
    }

    public UnindexedFilesUpdater(@NotNull Project project) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(1);
        }
        this(project, false, !UnindexedFilesUpdater.isProjectContentFullyScanned(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnindexedFiles(@NotNull ProjectIndexingHistory projectIndexingHistory, @NotNull ProgressIndicator indicator) {
        Map<IndexableFilesIterator, List<VirtualFile>> providerToFiles;
        List<IndexableFilesIterator> orderedProviders;
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(3);
        }
        if (!IndexInfrastructure.hasIndices()) {
            return;
        }
        ProgressSuspender suspender = ProgressSuspender.getSuspender(indicator);
        if (suspender != null) {
            this.listenToProgressSuspenderForSuspendedTimeDiagnostic(suspender, projectIndexingHistory);
        }
        if (this.myStartSuspended) {
            if (suspender == null) {
                throw new IllegalStateException("Indexing progress indicator must be suspendable!");
            }
            if (!suspender.isSuspended()) {
                suspender.suspendProcess(IndexingBundle.message((String)"progress.indexing.started.as.suspended", (Object[])new Object[0]));
            }
        }
        indicator.setIndeterminate(true);
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        boolean trackResponsiveness = !ApplicationManager.getApplication().isUnitTestMode();
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        projectIndexingHistory.getTimes().setPushPropertiesStart(Instant.now());
        try {
            this.myPusher.pushAllPropertiesNow();
        }
        finally {
            projectIndexingHistory.getTimes().setPushPropertiesEnd(Instant.now());
        }
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Pushing properties");
        }
        this.myIndex.clearIndicesIfNecessary();
        snapshot = PerformanceWatcher.takeSnapshot();
        Instant scanFilesStart = Instant.now();
        try {
            orderedProviders = this.getOrderedProviders();
            providerToFiles = this.collectIndexableFilesConcurrently(this.myProject, indicator, orderedProviders, projectIndexingHistory);
            this.myProject.putUserData(CONTENT_SCANNED, (Object)true);
        }
        finally {
            projectIndexingHistory.getTimes().setScanFilesEnd(Instant.now());
        }
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Indexable file iteration");
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleInitialVfsRefresh();
        }
        int totalFiles = providerToFiles.values().stream().mapToInt(it -> it.size()).sum();
        if (trackResponsiveness) {
            LOG.info("Unindexed files update started: " + totalFiles + " files to index");
        }
        if (totalFiles == 0 || SystemProperties.getBooleanProperty((String)"idea.indexes.pretendNoFiles", (boolean)false)) {
            return;
        }
        snapshot = PerformanceWatcher.takeSnapshot();
        ProgressIndicator poweredIndicator = PoweredProgressIndicator.wrap(indicator, UnindexedFilesUpdater.getPowerForSmoothProgressIndicator());
        poweredIndicator.setIndeterminate(false);
        poweredIndicator.setFraction(0.0);
        poweredIndicator.setText(IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(poweredIndicator, totalFiles);
        int numberOfIndexingThreads = UnindexedFilesUpdater.getNumberOfIndexingThreads();
        LOG.info("Using " + numberOfIndexingThreads + " " + StringUtil.pluralize((String)"thread", (int)numberOfIndexingThreads) + " for indexing");
        IndexUpdateRunner indexUpdateRunner = new IndexUpdateRunner(this.myIndex, GLOBAL_INDEXING_EXECUTOR, numberOfIndexingThreads);
        projectIndexingHistory.setNumberOfIndexingThreads(numberOfIndexingThreads);
        projectIndexingHistory.getTimes().setIndexingStart(Instant.now());
        try {
            for (IndexableFilesIterator provider2 : orderedProviders) {
                List<VirtualFile> providerFiles = providerToFiles.get(provider2);
                if (providerFiles == null || providerFiles.isEmpty()) continue;
                concurrentTasksProgressManager.setText(provider2.getIndexingProgressText());
                SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(providerFiles.size());
                try {
                    IndexingJobStatistics statistics;
                    IndexUpdateRunner.IndexingInterruptedException exception = null;
                    try {
                        statistics = indexUpdateRunner.indexFiles(this.myProject, provider2.getDebugName(), providerFiles, subTaskIndicator);
                    }
                    catch (IndexUpdateRunner.IndexingInterruptedException e) {
                        exception = e;
                        statistics = e.myStatistics;
                    }
                    try {
                        projectIndexingHistory.addProviderStatistics(statistics);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to add indexing statistics for " + provider2.getDebugName(), (Throwable)e);
                    }
                    if (exception == null) continue;
                    ExceptionUtil.rethrow((Throwable)exception.getCause());
                }
                finally {
                    subTaskIndicator.finished();
                }
            }
        }
        finally {
            projectIndexingHistory.getTimes().setIndexingEnd(Instant.now());
        }
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Unindexed files update");
        }
        this.myIndex.dumpIndexStatistics();
    }

    private void listenToProgressSuspenderForSuspendedTimeDiagnostic(final @NotNull ProgressSuspender suspender, final @NotNull ProjectIndexingHistory projectIndexingHistory) {
        if (suspender == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(4);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(5);
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(ProgressSuspender.TOPIC, (Object)new ProgressSuspender.SuspenderListener(){
            private volatile Instant suspensionStart = null;

            @Override
            public void suspendedStatusChanged(@NotNull ProgressSuspender changedSuspender) {
                if (changedSuspender == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (suspender == changedSuspender) {
                    if (suspender.isSuspended()) {
                        this.suspensionStart = Instant.now();
                    } else {
                        Instant now = Instant.now();
                        Instant start2 = this.suspensionStart;
                        this.suspensionStart = null;
                        if (start2 != null && start2.compareTo(now) < 0) {
                            Duration thisDuration = Duration.between(start2, now);
                            Duration currentTotalDuration = projectIndexingHistory.getTimes().getSuspendedDuration();
                            Duration newTotalSuspendedDuration = currentTotalDuration != null ? currentTotalDuration.plus(thisDuration) : thisDuration;
                            projectIndexingHistory.getTimes().setSuspendedDuration(newTotalSuspendedDuration);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedSuspender", "com/intellij/util/indexing/UnindexedFilesUpdater$1", "suspendedStatusChanged"));
            }
        });
    }

    static boolean isProjectContentFullyScanned(@NotNull Project project) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(6);
        }
        return Boolean.TRUE.equals(project.getUserData(CONTENT_SCANNED));
    }

    @NotNull
    private List<IndexableFilesIterator> getOrderedProviders() {
        List<IndexableFilesIterator> originalOrderedProviders = this.myIndex.getOrderedIndexableFilesProviders(this.myProject);
        ArrayList<IndexableFilesIterator> orderedProviders = new ArrayList<IndexableFilesIterator>();
        originalOrderedProviders.stream().filter(p -> !(p instanceof SdkIndexableFilesIterator)).collect(Collectors.toCollection(() -> orderedProviders));
        originalOrderedProviders.stream().filter(p -> p instanceof SdkIndexableFilesIterator).collect(Collectors.toCollection(() -> orderedProviders));
        ArrayList<IndexableFilesIterator> arrayList = orderedProviders;
        if (arrayList == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private Map<IndexableFilesIterator, List<VirtualFile>> collectIndexableFilesConcurrently(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull List<IndexableFilesIterator> providers, @NotNull ProjectIndexingHistory projectIndexingHistory) {
        if (project == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(9);
        }
        if (providers == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(10);
        }
        if (projectIndexingHistory == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(11);
        }
        if (providers.isEmpty()) {
            Map<IndexableFilesIterator, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                UnindexedFilesUpdater.$$$reportNull$$$0(12);
            }
            return map2;
        }
        UnindexedFilesFinder unindexedFileFilter = new UnindexedFilesFinder(project, this.myIndex, this.myRunExtensionsForFilesMarkedAsIndexed);
        IdentityHashMap<IndexableFilesIterator, List<VirtualFile>> providerToFiles = new IdentityHashMap<IndexableFilesIterator, List<VirtualFile>>();
        ConcurrentBitSet visitedFileSet = new ConcurrentBitSet();
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(indicator, providers.size());
        List tasks = ContainerUtil.map(providers, provider2 -> {
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(1);
            ArrayList files2 = new ArrayList();
            ScanningStatistics scanningStatistics = new ScanningStatistics(provider2.getDebugName());
            providerToFiles.put((IndexableFilesIterator)provider2, files2);
            ContentIterator collectingIterator = fileOrDir -> {
                UnindexedFileStatus status;
                if (subTaskIndicator.isCanceled()) {
                    return false;
                }
                long statusTime = System.nanoTime();
                try {
                    status = unindexedFileFilter.getFileStatus(fileOrDir);
                }
                finally {
                    statusTime = System.nanoTime() - statusTime;
                }
                if (status != null) {
                    if (status.getShouldIndex()) {
                        files2.add(fileOrDir);
                    }
                    scanningStatistics.addStatus(status, statusTime);
                }
                return true;
            };
            return () -> {
                subTaskIndicator.setText(provider2.getRootsScanningProgressText());
                try {
                    provider2.iterateFiles(project, collectingIterator, visitedFileSet);
                }
                finally {
                    ProjectIndexingHistory projectIndexingHistory2 = projectIndexingHistory;
                    synchronized (projectIndexingHistory2) {
                        projectIndexingHistory.addScanningStatistics(scanningStatistics);
                    }
                    subTaskIndicator.finished();
                }
            };
        });
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
        IdentityHashMap<IndexableFilesIterator, List<VirtualFile>> identityHashMap = providerToFiles;
        if (identityHashMap == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(13);
        }
        return identityHashMap;
    }

    private void scheduleInitialVfsRefresh() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).markRootsForRefresh();
        Application app = ApplicationManager.getApplication();
        if (!app.isCommandLine()) {
            final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
            final MessageBusConnection connection = app.getMessageBus().connect();
            connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (project == UnindexedFilesUpdater.this.myProject) {
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/UnindexedFilesUpdater$2", "projectClosed"));
                }
            });
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> VirtualFileManager.getInstance().syncRefresh());
        }
    }

    private static double getPowerForSmoothProgressIndicator() {
        String rawValue = Registry.stringValue((String)"indexing.progress.indicator.power");
        if ("-".equals(rawValue)) {
            return 1.0;
        }
        try {
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
    }

    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnindexedFilesUpdater.$$$reportNull$$$0(14);
        }
        ProjectIndexingHistory projectIndexingHistory = new ProjectIndexingHistory(this.myProject);
        projectIndexingHistory.getTimes().setTotalStart(Instant.now());
        this.myIndex.filesUpdateStarted(this.myProject);
        try {
            this.updateUnindexedFiles(projectIndexingHistory, indicator);
        }
        catch (Throwable e) {
            projectIndexingHistory.getTimes().setWasInterrupted(true);
            if (e instanceof ControlFlowException) {
                LOG.info("Unindexed files update canceled");
            }
            throw e;
        }
        finally {
            this.myIndex.filesUpdateFinished(this.myProject);
            projectIndexingHistory.getTimes().setTotalEnd(Instant.now());
            IndexDiagnosticDumper.INSTANCE.dumpProjectIndexingHistoryIfNecessary(projectIndexingHistory);
        }
    }

    public static int getNumberOfIndexingThreads() {
        int threadsCount = Registry.intValue((String)"caches.indexerThreadsCount");
        if (threadsCount <= 0) {
            int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
            threadsCount = Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() - coresToLeaveForOtherActivity, 4));
        }
        return threadsCount;
    }

    public static int getMaxNumberOfIndexingThreads() {
        int threadsCount = Registry.intValue((String)"caches.indexerThreadsCount");
        if (threadsCount <= 0) {
            return 4;
        }
        return threadsCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectIndexingHistory";
                break;
            }
            case 3: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspender";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/UnindexedFilesUpdater";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesUpdater";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedProviders";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIndexableFilesConcurrently";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateUnindexedFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "listenToProgressSuspenderForSuspendedTimeDiagnostic";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isProjectContentFullyScanned";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectIndexableFilesConcurrently";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "performInDumbMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

