/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.actions.AutoImportVariant;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportAction;
import org.jetbrains.kotlin.idea.completion.KotlinStatisticsInfo;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "variants", "", "Lorg/jetbrains/kotlin/idea/actions/AutoImportVariant;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;)V", "addImport", "", "variant", "execute", "", "getVariantSelectionPopup", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "isUnambiguous", "showHint", "kotlin.idea"})
public final class KotlinAddImportAction
implements QuestionAction {
    private final Project project;
    private final Editor editor;
    private final KtElement element;
    private final List<AutoImportVariant> variants;

    public final boolean showHint() {
        if (this.variants.isEmpty()) {
            return false;
        }
        String string = ShowAutoImportPass.getMessage((this.variants.size() > 1 ? 1 : 0) != 0, (String)((AutoImportVariant)CollectionsKt.first(this.variants)).getHint());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ShowAutoImportPass.getMe\u20261, variants.first().hint)");
        String hintText = string;
        HintManager hintManager = HintManager.getInstance();
        int n = this.element.getTextOffset();
        TextRange textRange = this.element.getTextRange();
        Intrinsics.checkNotNull((Object)textRange);
        hintManager.showQuestionHint(this.editor, hintText, n, textRange.getEndOffset(), (QuestionAction)this);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnambiguous() {
        DeclarationDescriptor it;
        if (this.variants.size() != 1) return false;
        Iterable $this$all$iv = this.variants.get(0).getDescriptorsToImport();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (DeclarationDescriptor)element$iv;
            boolean bl = false;
        } while (it instanceof ClassDescriptor);
        return false;
    }

    public boolean execute() {
        block6: {
            block5: {
                PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
                if (!this.element.isValid()) {
                    return false;
                }
                if (this.variants.isEmpty()) {
                    return false;
                }
                if (this.variants.size() == 1) break block5;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block6;
            }
            this.addImport((AutoImportVariant)CollectionsKt.first(this.variants));
            return true;
        }
        new ListPopupImpl(this, (ListPopupStep)this.getVariantSelectionPopup()){
            final /* synthetic */ KotlinAddImportAction this$0;

            @NotNull
            protected ListCellRenderer<AutoImportVariant> getListElementRenderer() {
                ListCellRenderer listCellRenderer = super.getListElementRenderer();
                if (listCellRenderer == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.popup.list.PopupListElementRenderer<kotlin.Any!>");
                }
                PopupListElementRenderer baseRenderer = (PopupListElementRenderer)listCellRenderer;
                DefaultPsiElementCellRenderer psiRenderer = new DefaultPsiElementCellRenderer();
                return new ListCellRenderer<AutoImportVariant>(this, baseRenderer, psiRenderer){
                    final /* synthetic */ execute.1 this$0;
                    final /* synthetic */ PopupListElementRenderer $baseRenderer;
                    final /* synthetic */ DefaultPsiElementCellRenderer $psiRenderer;

                    public final Component getListCellRendererComponent(JList<? extends AutoImportVariant> list, AutoImportVariant value, int index, boolean isSelected, boolean cellHasFocus) {
                        JPanel jPanel2 = new JPanel(new BorderLayout());
                        boolean bl = false;
                        boolean bl2 = false;
                        JPanel $this$apply = jPanel2;
                        boolean bl3 = false;
                        this.$baseRenderer.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
                        $this$apply.add((Component)this.$baseRenderer.getNextStepLabel(), "East");
                        Project project2 = this.this$0.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                        $this$apply.add(this.$psiRenderer.getListCellRendererComponent(list, (Object)value.declarationToImport(project2), index, isSelected, cellHasFocus));
                        return jPanel2;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$baseRenderer = popupListElementRenderer;
                        this.$psiRenderer = defaultPsiElementCellRenderer;
                    }
                };
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        }.showInBestPositionFor(this.editor);
        return true;
    }

    private final BaseListPopupStep<AutoImportVariant> getVariantSelectionPopup() {
        return (BaseListPopupStep)new BaseListPopupStep<AutoImportVariant>(this, KotlinBundle.message("action.add.import.chooser.title", new Object[0]), this.variants){
            final /* synthetic */ KotlinAddImportAction this$0;

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @Nullable
            public PopupStep<String> onChosen(@Nullable AutoImportVariant selectedValue, boolean finalChoice) {
                if (selectedValue == null || KotlinAddImportAction.access$getProject$p(this.this$0).isDisposed()) {
                    return null;
                }
                if (finalChoice) {
                    KotlinAddImportAction.access$addImport(this.this$0, selectedValue);
                    return null;
                }
                List list = AddImportAction.getAllExcludableStrings((String)selectedValue.getExcludeFqNameCheck().asString());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"AddImportAction.getAllEx\u2026deFqNameCheck.asString())");
                List toExclude = list;
                return (PopupStep)new BaseListPopupStep<String>(this, toExclude, null, toExclude){
                    final /* synthetic */ getVariantSelectionPopup.1 this$0;
                    final /* synthetic */ List $toExclude;

                    @NotNull
                    public String getTextFor(@NotNull String value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        return KotlinBundle.message("fix.import.exclude", value);
                    }

                    @Nullable
                    public PopupStep<Object> onChosen(@NotNull String selectedValue, boolean finalChoice) {
                        Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                        if (finalChoice && !KotlinAddImportAction.access$getProject$p(this.this$0.this$0).isDisposed()) {
                            AddImportAction.excludeFromImport((Project)KotlinAddImportAction.access$getProject$p(this.this$0.this$0), (String)selectedValue);
                        }
                        return null;
                    }
                    {
                        this.this$0 = this$0;
                        this.$toExclude = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3);
                    }
                };
            }

            public boolean hasSubstep(@Nullable AutoImportVariant selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(@NotNull AutoImportVariant value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getHint();
            }

            @Nullable
            public Icon getIconFor(@NotNull AutoImportVariant value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.icon(KotlinAddImportAction.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    private final void addImport(AutoImportVariant variant) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        psiDocumentManager.commitAllDocuments();
        String string = QuickFixBundle.message((String)"add.import", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QuickFixBundle.message(\"add.import\")");
        ApplicationUtilsKt.executeWriteCommand((Project)this.project, (String)string, (Function0)((Function0)new Function0<Unit>(this, variant){
            final /* synthetic */ KotlinAddImportAction this$0;
            final /* synthetic */ AutoImportVariant $variant;

            public final void invoke() {
                if (!KotlinAddImportAction.access$getElement$p(this.this$0).isValid()) {
                    return;
                }
                KtFile ktFile = KotlinAddImportAction.access$getElement$p(this.this$0).getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
                KtFile file = ktFile;
                StatisticsManager statisticsManager = StatisticsManager.getInstance();
                Iterable $this$forEach$iv = this.$variant.getDescriptorsToImport();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KtImportAlias ktImportAlias;
                    FqName it;
                    FqName fqName;
                    boolean bl;
                    boolean bl2;
                    DeclarationDescriptor descriptor2 = (DeclarationDescriptor)element$iv;
                    boolean bl3 = false;
                    StatisticsInfo statisticsInfo = KotlinStatisticsInfo.forDescriptor$default(KotlinStatisticsInfo.INSTANCE, descriptor2, null, 2, null);
                    statisticsManager.incUseCount(statisticsInfo);
                    FqName importableFqName = ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2);
                    if (importableFqName != null) {
                        bl2 = false;
                        bl = false;
                        it = fqName;
                        boolean bl4 = false;
                        ktImportAlias = file.findAliasByFqName(it);
                    } else {
                        ktImportAlias = null;
                    }
                    KtImportAlias importAlias = ktImportAlias;
                    FqName fqName2 = importableFqName;
                    if (fqName2 == null || !FqNamesUtilKt.isOneSegmentFQN((FqName)fqName2)) {
                        if (importAlias != null || descriptor2 instanceof ClassDescriptor || descriptor2 instanceof PackageViewDescriptor) {
                            if (!(KotlinAddImportAction.access$getElement$p(this.this$0) instanceof KtSimpleNameExpression)) continue;
                            if (importAlias != null) {
                                DeclarationDescriptor resultDescriptor;
                                PsiElement psiElement2 = importAlias.getNameIdentifier();
                                if (psiElement2 != null && (psiElement2 = psiElement2.copy()) != null) {
                                    fqName = psiElement2;
                                    bl2 = false;
                                    bl = false;
                                    it = fqName;
                                    boolean bl5 = false;
                                    PsiElement psiElement3 = ((KtSimpleNameExpression)KotlinAddImportAction.access$getElement$p(this.this$0)).getIdentifier();
                                    if (psiElement3 != null) {
                                        psiElement3.replace((PsiElement)it);
                                    }
                                }
                                DeclarationDescriptor declarationDescriptor = resultDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)KotlinAddImportAction.access$getElement$p(this.this$0)));
                                if (Intrinsics.areEqual((Object)importableFqName, (Object)(declarationDescriptor != null ? ImportsUtils.getImportableFqName((DeclarationDescriptor)declarationDescriptor) : null))) continue;
                            }
                            if (importableFqName != null) {
                                bl2 = false;
                                bl = false;
                                it = fqName;
                                boolean bl6 = false;
                                KtSimpleNameReference.bindToFqName$default((KtSimpleNameReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)KotlinAddImportAction.access$getElement$p(this.this$0))), (FqName)it, (KtSimpleNameReference.ShorteningMode)KtSimpleNameReference.ShorteningMode.FORCED_SHORTENING, null, (int)4, null);
                            }
                            continue;
                        }
                    }
                    ImportInsertHelper.importDescriptor$default((ImportInsertHelper)ImportInsertHelper.Companion.getInstance(KotlinAddImportAction.access$getProject$p(this.this$0)), (KtFile)file, (DeclarationDescriptor)descriptor2, (boolean)false, (int)4, null);
                }
            }
            {
                this.this$0 = kotlinAddImportAction;
                this.$variant = autoImportVariant;
                super(0);
            }
        }));
    }

    public KotlinAddImportAction(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtElement element3, @NotNull List<? extends AutoImportVariant> variants) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        this.project = project2;
        this.editor = editor2;
        this.element = element3;
        this.variants = variants;
    }

    public static final /* synthetic */ Project access$getProject$p(KotlinAddImportAction $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$addImport(KotlinAddImportAction $this, AutoImportVariant variant) {
        $this.addImport(variant);
    }

    public static final /* synthetic */ KtElement access$getElement$p(KotlinAddImportAction $this) {
        return $this.element;
    }
}

