/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.JavaBackspaceHandler;
import com.intellij.codeInsight.editorActions.JavaTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

final class LtGtTypingUtils {
    private static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{KtTokens.SEMICOLON, KtTokens.LBRACE, KtTokens.RBRACE});

    private LtGtTypingUtils() {
    }

    static void handleKotlinAutoCloseLT(Editor editor2) {
        JavaTypedHandler.handleAfterJavaLT((Editor)editor2, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean handleKotlinGTInsert(Editor editor2) {
        return JavaTypedHandler.handleJavaGT((Editor)editor2, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static void handleKotlinLTDeletion(Editor editor2, int offset) {
        JavaBackspaceHandler.handleLTDeletion((Editor)editor2, (int)offset, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean shouldAutoCloseAngleBracket(int offset, Editor editor2) {
        return LtGtTypingUtils.isAfterClassIdentifier(offset, editor2) || LtGtTypingUtils.isAfterToken(offset, editor2, (KtToken)KtTokens.FUN_KEYWORD);
    }

    private static boolean isAfterClassIdentifier(int offset, Editor editor2) {
        HighlighterIterator iterator = ((EditorEx)editor2).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getStart() > 0) {
            iterator.retreat();
        }
        return JavaTypedHandler.isClassLikeIdentifier((int)offset, (Editor)editor2, (HighlighterIterator)iterator, (IElementType)KtTokens.IDENTIFIER);
    }

    static boolean isAfterToken(int offset, Editor editor2, KtToken tokenType) {
        HighlighterIterator iterator = ((EditorEx)editor2).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getStart() > 0) {
            iterator.retreat();
        }
        if (iterator.getTokenType() == KtTokens.WHITE_SPACE && iterator.getStart() > 0) {
            iterator.retreat();
        }
        return iterator.getTokenType() == tokenType;
    }
}

