/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionSettings;
import org.jetbrains.kotlin.idea.inspections.PackageNameInspectionLocal;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspectionLocal;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "parentInspection", "Lcom/intellij/codeInspection/InspectionProfileEntry;", "namingSettings", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "(Lcom/intellij/codeInspection/InspectionProfileEntry;Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;)V", "getNamingSettings", "()Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "getParentInspection", "()Lcom/intellij/codeInspection/InspectionProfileEntry;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDisplayName", "", "getShortName", "Companion", "RenamePackageFix", "kotlin.idea"})
final class PackageNameInspectionLocal
extends AbstractKotlinInspection {
    @NotNull
    private final InspectionProfileEntry parentInspection;
    @NotNull
    private final NamingConventionInspectionSettings namingSettings;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)VisitorWrappersKt.packageDirectiveVisitor((Function1)((Function1)new Function1<KtPackageDirective, Unit>(this, holder){
            final /* synthetic */ PackageNameInspectionLocal this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtPackageDirective directive) {
                Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                KtExpression ktExpression = directive.getPackageNameExpression();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"directive.packageNameExp\u2026n@packageDirectiveVisitor");
                KtExpression packageNameExpression = ktExpression;
                Companion.CheckResult checkResult = PackageNameInspectionLocal.Companion.checkPackageDirective(directive, this.this$0.getNamingSettings());
                if (checkResult == null) {
                    return;
                }
                Companion.CheckResult checkResult2 = checkResult;
                String descriptionTemplate = PackageNameInspectionLocal.Companion.toProblemTemplateString(checkResult2);
                this.$holder.registerProblem((PsiElement)packageNameExpression, descriptionTemplate, new LocalQuickFix[]{new RenamePackageFix()});
            }
            {
                this.this$0 = packageNameInspectionLocal;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @NotNull
    public String getShortName() {
        String string = this.parentInspection.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parentInspection.shortName");
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.parentInspection.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parentInspection.displayName");
        return string;
    }

    @NotNull
    public final InspectionProfileEntry getParentInspection() {
        return this.parentInspection;
    }

    @NotNull
    public final NamingConventionInspectionSettings getNamingSettings() {
        return this.namingSettings;
    }

    public PackageNameInspectionLocal(@NotNull InspectionProfileEntry parentInspection, @NotNull NamingConventionInspectionSettings namingSettings2) {
        Intrinsics.checkNotNullParameter((Object)parentInspection, (String)"parentInspection");
        Intrinsics.checkNotNullParameter((Object)namingSettings2, (String)"namingSettings");
        this.parentInspection = parentInspection;
        this.namingSettings = namingSettings2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspectionLocal$RenamePackageFix;", "Lorg/jetbrains/kotlin/idea/quickfix/RenameIdentifierFix;", "()V", "getElementToRename", "Lcom/intellij/psi/PsiElement;", "element", "kotlin.idea"})
    private static final class RenamePackageFix
    extends RenameIdentifierFix {
        @Override
        @Nullable
        protected PsiElement getElementToRename(@NotNull PsiElement element3) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            PsiElement psiElement2 = element3;
            if (!(psiElement2 instanceof KtPackageDirective)) {
                psiElement2 = null;
            }
            KtPackageDirective ktPackageDirective = (KtPackageDirective)psiElement2;
            if (ktPackageDirective == null) {
                return null;
            }
            KtPackageDirective packageDirective = ktPackageDirective;
            return (PsiElement)JavaPsiFacade.getInstance((Project)((KtPackageDirective)element3).getProject()).findPackage(packageDirective.getQualifiedName());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\n\u0010\f\u001a\u00020\u000b*\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspectionLocal$Companion;", "", "()V", "checkPackageDirective", "Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspectionLocal$Companion$CheckResult;", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "namingSettings", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspectionSettings;", "checkQualifiedName", "qualifiedName", "", "toProblemTemplateString", "CheckResult", "kotlin.idea"})
    public static final class Companion {
        @NotNull
        public final String toProblemTemplateString(@NotNull CheckResult $this$toProblemTemplateString) {
            Intrinsics.checkNotNullParameter((Object)$this$toProblemTemplateString, (String)"$this$toProblemTemplateString");
            return KotlinBundle.message("package.name", new Object[0]) + ($this$toProblemTemplateString.isForPart() ? " <code>#ref</code> " + KotlinBundle.message("text.part", new Object[0]) + ' ' + $this$toProblemTemplateString.getErrorMessage() + " #loc" : " <code>#ref</code> " + $this$toProblemTemplateString.getErrorMessage() + " #loc");
        }

        @Nullable
        public final CheckResult checkPackageDirective(@NotNull KtPackageDirective directive, @NotNull NamingConventionInspectionSettings namingSettings2) {
            Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
            Intrinsics.checkNotNullParameter((Object)namingSettings2, (String)"namingSettings");
            String string = directive.getQualifiedName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"directive.qualifiedName");
            return this.checkQualifiedName(string, namingSettings2);
        }

        @Nullable
        public final CheckResult checkQualifiedName(@NotNull String qualifiedName, @NotNull NamingConventionInspectionSettings namingSettings2) {
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
                    Intrinsics.checkNotNullParameter((Object)namingSettings2, (String)"namingSettings");
                    CharSequence charSequence = qualifiedName;
                    boolean bl = false;
                    if (charSequence.length() == 0) break block2;
                    Regex regex = namingSettings2.getNameRegex();
                    if (regex != null && !regex.matches((CharSequence)qualifiedName)) break block3;
                }
                return null;
            }
            String partErrorMessage2 = Intrinsics.areEqual((Object)namingSettings2.getNamePattern(), (Object)namingSettings2.getDefaultNamePattern()) ? (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)qualifiedName, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null)), (Function1)checkQualifiedName.partErrorMessage.1.INSTANCE)) : null;
            return partErrorMessage2 != null ? new CheckResult(partErrorMessage2, true) : new CheckResult(namingSettings2.getDefaultErrorMessage(), false);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspectionLocal$Companion$CheckResult;", "", "errorMessage", "", "isForPart", "", "(Ljava/lang/String;Z)V", "getErrorMessage", "()Ljava/lang/String;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.idea"})
        public static final class CheckResult {
            @NotNull
            private final String errorMessage;
            private final boolean isForPart;

            @NotNull
            public final String getErrorMessage() {
                return this.errorMessage;
            }

            public final boolean isForPart() {
                return this.isForPart;
            }

            public CheckResult(@NotNull String errorMessage, boolean isForPart) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                this.errorMessage = errorMessage;
                this.isForPart = isForPart;
            }

            @NotNull
            public final String component1() {
                return this.errorMessage;
            }

            public final boolean component2() {
                return this.isForPart;
            }

            @NotNull
            public final CheckResult copy(@NotNull String errorMessage, boolean isForPart) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                return new CheckResult(errorMessage, isForPart);
            }

            public static /* synthetic */ CheckResult copy$default(CheckResult checkResult, String string, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    string = checkResult.errorMessage;
                }
                if ((n & 2) != 0) {
                    bl = checkResult.isForPart;
                }
                return checkResult.copy(string, bl);
            }

            @NotNull
            public String toString() {
                return "CheckResult(errorMessage=" + this.errorMessage + ", isForPart=" + this.isForPart + ")";
            }

            public int hashCode() {
                String string = this.errorMessage;
                int n = (string != null ? string.hashCode() : 0) * 31;
                int n2 = this.isForPart ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return n + n2;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CheckResult)) break block3;
                        CheckResult checkResult = (CheckResult)object;
                        if (!Intrinsics.areEqual((Object)this.errorMessage, (Object)checkResult.errorMessage) || this.isForPart != checkResult.isForPart) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

