/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.inspections.KotlinUniversalQuickFix;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinCrossLanguageQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003\u0018\u0019\u001aB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002H\u0002J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinCrossLanguageQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lorg/jetbrains/kotlin/idea/inspections/KotlinUniversalQuickFix;", "element", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getModifier", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getFamilyName", "", "getText", "invokeImpl", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invokeOnElement", "isAvailableImpl", "", "AddLateinitFactory", "Companion", "MakeClassOpenFactory", "kotlin.idea"})
public class AddModifierFix
extends KotlinCrossLanguageQuickFixAction<KtModifierListOwner>
implements KotlinUniversalQuickFix {
    @NotNull
    private final KtModifierKeywordToken modifier;
    private static final Set<KtModifierKeywordToken> modalityModifiers;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner == null) {
            return "";
        }
        KtModifierListOwner element3 = ktModifierListOwner;
        if (modalityModifiers.contains(this.modifier) || KtTokens.VISIBILITY_MODIFIERS.contains((IElementType)this.modifier) || Intrinsics.areEqual((Object)this.modifier, (Object)KtTokens.CONST_KEYWORD)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = Companion.getElementName(element3);
            String string = this.modifier.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"modifier.value");
            objectArray[1] = string;
            return KotlinBundle.message("fix.add.modifier.text", objectArray);
        }
        Object[] objectArray = new Object[1];
        String string = this.modifier.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"modifier.value");
        objectArray[0] = string;
        return KotlinBundle.message("fix.add.modifier.text.generic", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.add.modifier.family", new Object[0]);
    }

    private final void invokeOnElement(KtModifierListOwner element3) {
        block3: {
            KtModifierListOwner ktModifierListOwner = element3;
            if (ktModifierListOwner != null) {
                ktModifierListOwner.addModifier(this.modifier);
            }
            if (!Intrinsics.areEqual((Object)this.modifier, (Object)KtTokens.ABSTRACT_KEYWORD) || !(element3 instanceof KtProperty) && !(element3 instanceof KtNamedFunction)) break block3;
            KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)element3));
            if (ktClass2 != null) {
                KtClass ktClass3 = ktClass2;
                boolean bl = false;
                boolean bl2 = false;
                KtClass $this$run = ktClass3;
                boolean bl3 = false;
                if (!$this$run.hasModifier(KtTokens.ABSTRACT_KEYWORD) && !$this$run.hasModifier(KtTokens.SEALED_KEYWORD)) {
                    $this$run.addModifier(KtTokens.ABSTRACT_KEYWORD);
                }
            }
        }
    }

    @Override
    protected void invokeImpl(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtModifierListOwner originalElement = (KtModifierListOwner)this.getElement();
        if (originalElement instanceof KtDeclaration && AddModifierFix.Companion.isMultiplatformPersistent(this.modifier)) {
            ExpectActualUtilKt.runOnExpectAndAllActuals$default((KtDeclaration)((KtDeclaration)originalElement), (boolean)false, (boolean)true, (Function1)((Function1)new Function1<KtDeclaration, Unit>(this){
                final /* synthetic */ AddModifierFix this$0;

                public final void invoke(@NotNull KtDeclaration it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AddModifierFix.access$invokeOnElement(this.this$0, (KtModifierListOwner)it);
                }
                {
                    this.this$0 = addModifierFix;
                    super(1);
                }
            }), (int)1, null);
        } else {
            this.invokeOnElement(originalElement);
        }
    }

    @Override
    protected boolean isAvailableImpl(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner == null) {
            return false;
        }
        KtModifierListOwner element3 = ktModifierListOwner;
        return KotlinRefactoringUtilKt.canRefactor((PsiElement)element3);
    }

    @NotNull
    protected final KtModifierKeywordToken getModifier() {
        return this.modifier;
    }

    public AddModifierFix(@NotNull KtModifierListOwner element3, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        super((PsiElement)element3);
        this.modifier = modifier;
    }

    static {
        Companion = new Companion(null);
        modalityModifiers = SetsKt.setOf((Object[])new KtModifierKeywordToken[]{KtTokens.ABSTRACT_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.FINAL_KEYWORD});
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        KotlinUniversalQuickFix.DefaultImpls.applyFix((KotlinUniversalQuickFix)this, (Project)project2, (ProblemDescriptor)descriptor2);
    }

    public static final /* synthetic */ void access$invokeOnElement(AddModifierFix $this, KtModifierListOwner element3) {
        $this.invokeOnElement(element3);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$MakeClassOpenFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class MakeClassOpenFactory
    extends KotlinSingleIntentionActionFactory {
        public static final MakeClassOpenFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            KtTypeReference typeReference = (KtTypeReference)psiElement2;
            KtClass ktClass2 = AddModifierFixKt.classForRefactor(typeReference);
            if (ktClass2 == null) {
                return null;
            }
            KtClass declaration2 = ktClass2;
            if (declaration2.isEnum() || declaration2.isData()) {
                return null;
            }
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)declaration2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OPEN_KEYWORD");
            return new AddModifierFix(ktModifierListOwner, ktModifierKeywordToken);
        }

        private MakeClassOpenFactory() {
        }

        static {
            MakeClassOpenFactory makeClassOpenFactory;
            INSTANCE = makeClassOpenFactory = new MakeClassOpenFactory();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$AddLateinitFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class AddLateinitFactory
    extends KotlinSingleIntentionActionFactory {
        public static final AddLateinitFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            PropertyDescriptor propertyDescriptor;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            Diagnostic diagnostic2 = Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.cast(diagnostic);
            Intrinsics.checkNotNullExpressionValue((Object)diagnostic2, (String)"Errors.MUST_BE_INITIALIZ\u2026ABSTRACT.cast(diagnostic)");
            PsiElement psiElement2 = ((SimpleDiagnostic)diagnostic2).getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"Errors.MUST_BE_INITIALIZ\u2026st(diagnostic).psiElement");
            KtProperty property2 = (KtProperty)psiElement2;
            if (!property2.isVar()) {
                return null;
            }
            VariableDescriptor variableDescriptor = ResolutionUtils.resolveToDescriptorIfAny((KtProperty)property2, (BodyResolveMode)BodyResolveMode.FULL);
            if (variableDescriptor == null) {
                return null;
            }
            VariableDescriptor descriptor2 = variableDescriptor;
            VariableDescriptor variableDescriptor2 = descriptor2;
            if (!(variableDescriptor2 instanceof PropertyDescriptor)) {
                variableDescriptor2 = null;
            }
            if ((propertyDescriptor = (PropertyDescriptor)variableDescriptor2) == null || (propertyDescriptor = propertyDescriptor.getType()) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"(descriptor as? Property\u2026tor)?.type ?: return null");
            PropertyDescriptor type2 = propertyDescriptor;
            if (TypeUtils.isNullableType((KotlinType)type2)) {
                return null;
            }
            if (KotlinBuiltIns.isPrimitiveType((KotlinType)type2)) {
                return null;
            }
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)property2;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.LATEINIT_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"LATEINIT_KEYWORD");
            return new AddModifierFix(ktModifierListOwner, ktModifierKeywordToken);
        }

        private AddLateinitFactory() {
        }

        static {
            AddLateinitFactory addLateinitFactory;
            INSTANCE = addLateinitFactory = new AddLateinitFactory();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J&\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000bJ\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0005H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Companion;", "", "()V", "modalityModifiers", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "createFactory", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "modifier", "T", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifierOwnerClass", "Ljava/lang/Class;", "createIfApplicable", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "modifierListOwner", "getElementName", "", "isMultiplatformPersistent", "", "kotlin.idea"})
    public static final class Companion {
        private final boolean isMultiplatformPersistent(KtModifierKeywordToken $this$isMultiplatformPersistent) {
            return KtTokens.MODALITY_MODIFIERS.contains((IElementType)$this$isMultiplatformPersistent) || Intrinsics.areEqual((Object)$this$isMultiplatformPersistent, (Object)KtTokens.INLINE_KEYWORD);
        }

        @NotNull
        public final String getElementName(@NotNull KtModifierListOwner modifierListOwner) {
            Intrinsics.checkNotNullParameter((Object)modifierListOwner, (String)"modifierListOwner");
            String name2 = null;
            if (modifierListOwner instanceof PsiNameIdentifierOwner) {
                PsiElement nameIdentifier = ((PsiNameIdentifierOwner)modifierListOwner).getNameIdentifier();
                if (nameIdentifier != null) {
                    name2 = nameIdentifier.getText();
                } else {
                    KtModifierListOwner ktModifierListOwner = modifierListOwner;
                    if (!(ktModifierListOwner instanceof KtObjectDeclaration)) {
                        ktModifierListOwner = null;
                    }
                    KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)ktModifierListOwner;
                    if (ktObjectDeclaration != null) {
                        if (ktObjectDeclaration.isCompanion()) {
                            name2 = "companion object";
                        }
                    }
                }
            } else if (modifierListOwner instanceof KtPropertyAccessor) {
                PsiElement psiElement2 = ((KtPropertyAccessor)modifierListOwner).getNamePlaceholder();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"modifierListOwner.namePlaceholder");
                name2 = psiElement2.getText();
            }
            if (name2 == null) {
                name2 = modifierListOwner.getText();
            }
            return '\'' + name2 + '\'';
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory createFactory(@NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return this.createFactory(modifier, KtModifierListOwner.class);
        }

        @NotNull
        public final <T extends KtModifierListOwner> KotlinSingleIntentionActionFactory createFactory(@NotNull KtModifierKeywordToken modifier, @NotNull Class<T> modifierOwnerClass) {
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            Intrinsics.checkNotNullParameter(modifierOwnerClass, (String)"modifierOwnerClass");
            return new KotlinSingleIntentionActionFactory(modifierOwnerClass, modifier){
                final /* synthetic */ Class $modifierOwnerClass;
                final /* synthetic */ KtModifierKeywordToken $modifier;

                @Nullable
                public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                    Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                    KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)QuickFixUtil.getParentElementOfType((Diagnostic)diagnostic, (Class)this.$modifierOwnerClass);
                    if (ktModifierListOwner == null) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierListOwner, (String)"QuickFixUtil.getParentEl\u2026wnerClass) ?: return null");
                    KtModifierListOwner modifierListOwner = ktModifierListOwner;
                    return AddModifierFix.Companion.createIfApplicable(modifierListOwner, this.$modifier);
                }
                {
                    this.$modifierOwnerClass = $captured_local_variable$0;
                    this.$modifier = $captured_local_variable$1;
                }
            };
        }

        @Nullable
        public final AddModifierFix createIfApplicable(@NotNull KtModifierListOwner modifierListOwner, @NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)modifierListOwner, (String)"modifierListOwner");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            KtModifierKeywordToken ktModifierKeywordToken = modifier;
            if (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.ABSTRACT_KEYWORD) || Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.OPEN_KEYWORD)) {
                if (modifierListOwner instanceof KtObjectDeclaration) {
                    return null;
                }
                if (modifierListOwner instanceof KtEnumEntry) {
                    return null;
                }
                if (modifierListOwner instanceof KtDeclaration && !(modifierListOwner instanceof KtClass)) {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)modifierListOwner));
                    if (ktClassOrObject == null) {
                        return null;
                    }
                    KtClassOrObject parentClassOrObject = ktClassOrObject;
                    if (parentClassOrObject instanceof KtObjectDeclaration) {
                        return null;
                    }
                    if (parentClassOrObject instanceof KtEnumEntry) {
                        return null;
                    }
                }
                if (Intrinsics.areEqual((Object)modifier, (Object)KtTokens.ABSTRACT_KEYWORD) && modifierListOwner instanceof KtClass && modifierListOwner.hasModifier(KtTokens.INLINE_KEYWORD)) {
                    return null;
                }
            } else if (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.INNER_KEYWORD)) {
                if (modifierListOwner instanceof KtObjectDeclaration) {
                    return null;
                }
                if (modifierListOwner instanceof KtClass && (((KtClass)modifierListOwner).isInterface() || ((KtClass)modifierListOwner).isSealed() || ((KtClass)modifierListOwner).isEnum() || ((KtClass)modifierListOwner).isData() || ((KtClass)modifierListOwner).isAnnotation())) {
                    return null;
                }
            }
            return new AddModifierFix(modifierListOwner, modifier);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

