/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/KotlinNativeHomeEvaluator;", "", "()V", "FALLBACK_ACCESSOR_CLASS", "", "FALLBACK_ACCESSOR_METHOD", "KOTLIN_NATIVE_HOME_PRIVATE_PROPERTY", "getKotlinNativeHome", "project", "Lorg/gradle/api/Project;", "getKotlinNativeHomeFallback", "getKotlinNativeHomePrimary", "kotlin.gradle.gradle-tooling"})
public final class KotlinNativeHomeEvaluator {
    private static final String KOTLIN_NATIVE_HOME_PRIVATE_PROPERTY = "konanHome";
    private static final String FALLBACK_ACCESSOR_CLASS = "org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunnerKt";
    private static final String FALLBACK_ACCESSOR_METHOD = "getKonanHome";
    public static final KotlinNativeHomeEvaluator INSTANCE;

    @Nullable
    public final String getKotlinNativeHome(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = this.getKotlinNativeHomePrimary(project);
        if (string == null) {
            string = this.getKotlinNativeHomeFallback(project);
        }
        return string;
    }

    private final String getKotlinNativeHomePrimary(Project project) {
        return (String)project.findProperty(KOTLIN_NATIVE_HOME_PRIVATE_PROPERTY);
    }

    private final String getKotlinNativeHomeFallback(Project project) {
        Class<?> accessorClass;
        Class<?> clazz;
        Class<?> clazz2 = project.getExtensions().findByName("kotlin");
        if (clazz2 == null || (clazz2 = clazz2.getClass()) == null || (clazz2 = clazz2.getClassLoader()) == null) {
            return null;
        }
        Class<?> kotlinExtensionClassLoader = clazz2;
        try {
            clazz = Class.forName(FALLBACK_ACCESSOR_CLASS, true, (ClassLoader)((Object)kotlinExtensionClassLoader));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Class<?> clazz3 = accessorClass = clazz;
        Intrinsics.checkNotNullExpressionValue(clazz3, (String)"accessorClass");
        Method method = UtilsKt.getMethodOrNull(clazz3, FALLBACK_ACCESSOR_METHOD, Project.class);
        if (method == null) {
            return null;
        }
        Method accessorMethod = method;
        Object object = accessorMethod.invoke(null, project);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)object;
    }

    private KotlinNativeHomeEvaluator() {
    }

    static {
        KotlinNativeHomeEvaluator kotlinNativeHomeEvaluator;
        INSTANCE = kotlinNativeHomeEvaluator = new KotlinNativeHomeEvaluator();
    }
}

