/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.List;
import java.util.Map;

public class TestNGTestClass
extends TestNGTestObject {
    public TestNGTestClass(TestNGConfiguration config) {
        super(config);
    }

    @Override
    public void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
        TestData data = this.myConfig.getPersistantData();
        PsiClass psiClass = (PsiClass)ReadAction.compute(() -> ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)this.myConfig.getProject()), (String)data.getMainClassName().replace('/', '.'), null, (boolean)true, (GlobalSearchScope)this.getSearchScope()));
        if (psiClass == null) {
            throw new CantRunException(TestngBundle.message("dialog.message.no.tests.found.in.class", data.getMainClassName()));
        }
        if (null == ReadAction.compute(() -> psiClass.getQualifiedName())) {
            throw new CantRunException(TestngBundle.message("dialog.message.cannot.test.anonymous.or.local.class2", data.getMainClassName()));
        }
        TestNGTestClass.calculateDependencies(null, classes, this.getSearchScope(), psiClass);
    }

    @Override
    public String getGeneratedName() {
        return JavaExecutionUtil.getPresentableClassName((String)this.myConfig.getPersistantData().getMainClassName());
    }

    @Override
    public String getActionName() {
        return JavaExecutionUtil.getShortClassName((String)this.myConfig.getPersistantData().MAIN_CLASS_NAME);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        String testClassName;
        TestData data = this.myConfig.getPersistantData();
        SourceScope scope = data.getScope().getSourceScope((ModuleBasedConfiguration)this.myConfig);
        if (scope == null) {
            throw new RuntimeConfigurationException(TestngBundle.message("testng.test.class.dialog.message.invalid.scope.specified.exception", new Object[0]));
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myConfig.getProject());
        PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)manager, (String)(testClassName = data.getMainClassName()), null, (boolean)true, (GlobalSearchScope)scope.getGlobalSearchScope());
        if (psiClass == null) {
            throw new RuntimeConfigurationException(TestngBundle.message("testng.dialog.message.class.not.found.exception", testClassName));
        }
        if (!TestNGUtil.isTestNGClass(psiClass)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{testClassName}));
        }
    }

    @Override
    public boolean isConfiguredByElement(PsiElement element) {
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false)) instanceof PsiClass) {
            return Comparing.strEqual((String)this.myConfig.getPersistantData().getMainClassName(), (String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element)));
        }
        return false;
    }
}

