/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson.kimpl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.commands.kotlin.TaskContext;
import training.learn.LearnBundle;
import training.learn.lesson.LessonManager;
import training.learn.lesson.kimpl.ExtractTaskPropertiesContext;
import training.learn.lesson.kimpl.ExtractTextTaskContext;
import training.learn.lesson.kimpl.LearningBalloonConfig;
import training.learn.lesson.kimpl.LessonExecutorUtil$WhenMappings;
import training.learn.lesson.kimpl.TaskProperties;
import training.ui.LearningUiHighlightingManager;
import training.ui.LessonMessagePane;
import training.ui.MessageFactory;
import training.ui.MessagePart;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J'\u0010\u0012\u001a\u00020\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u0015\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u0019J-\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u0015\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001c"}, d2={"Ltraining/learn/lesson/kimpl/LessonExecutorUtil;", "", "()V", "getPosition", "Lcom/intellij/ui/awt/RelativePoint;", "component", "Ljavax/swing/JComponent;", "side", "Lcom/intellij/openapi/ui/popup/Balloon$Position;", "showBalloonMessage", "", "text", "", "ui", "balloonConfig", "Ltraining/learn/lesson/kimpl/LearningBalloonConfig;", "taskDisposable", "Lcom/intellij/openapi/Disposable;", "taskProperties", "Ltraining/learn/lesson/kimpl/TaskProperties;", "taskContent", "Lkotlin/Function1;", "Ltraining/commands/kotlin/TaskContext;", "Lkotlin/ExtensionFunctionType;", "project", "Lcom/intellij/openapi/project/Project;", "textMessages", "", "intellij.featuresTrainer"})
public final class LessonExecutorUtil {
    public static final LessonExecutorUtil INSTANCE;

    @NotNull
    public final TaskProperties taskProperties(@NotNull Function1<? super TaskContext, Unit> taskContent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(taskContent, (String)"taskContent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExtractTaskPropertiesContext fakeTaskContext = new ExtractTaskPropertiesContext(project);
        taskContent.invoke((Object)fakeTaskContext);
        return new TaskProperties(fakeTaskContext.getHasDetection(), fakeTaskContext.getTextCount());
    }

    @NotNull
    public final List<String> textMessages(@NotNull Function1<? super TaskContext, Unit> taskContent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(taskContent, (String)"taskContent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExtractTextTaskContext fakeTaskContext = new ExtractTextTaskContext(project);
        taskContent.invoke((Object)fakeTaskContext);
        return fakeTaskContext.getMessages();
    }

    public final void showBalloonMessage(@NotNull String text2, @NotNull JComponent ui, @NotNull LearningBalloonConfig balloonConfig, @NotNull Disposable taskDisposable) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)balloonConfig, (String)"balloonConfig");
        Intrinsics.checkNotNullParameter((Object)taskDisposable, (String)"taskDisposable");
        List<MessagePart> messages = MessageFactory.INSTANCE.convert(text2);
        LessonMessagePane messagesPane = new LessonMessagePane();
        LessonMessagePane.addMessage$default(messagesPane, messages, null, 2, null);
        JPanel balloonPanel = new JPanel();
        balloonPanel.setLayout(new BoxLayout(balloonPanel, 1));
        balloonPanel.setPreferredSize(balloonConfig.getDimension());
        balloonPanel.add(messagesPane);
        JButton stopButton = new JButton();
        balloonPanel.add(stopButton);
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)balloonPanel).setCloseButtonEnabled(false).setAnimationCycle(0).setHideOnClickOutside(false).setBlockClicksThroughBalloon(true).setBorderColor((Color)new JBColor(Color.BLACK, Color.WHITE)).setHideOnCloseClick(false).setDisposable(taskDisposable).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"JBPopupFactory.getInstan\u2026e)\n      .createBalloon()");
        Balloon balloon2 = balloon;
        Function0<Unit> gotItCallBack = balloonConfig.getGotItCallBack();
        stopButton.setAction(gotItCallBack != null ? (Action)new AbstractAction(gotItCallBack, UIBundle.message((String)"got.it", (Object[])new Object[0])){
            final /* synthetic */ Function0 $gotItCallBack;

            public void actionPerformed(@Nullable ActionEvent e) {
                this.$gotItCallBack.invoke();
            }
            {
                this.$gotItCallBack = $captured_local_variable$0;
                super($super_call_param$1);
            }
        } : (Action)new AbstractAction(LearnBundle.INSTANCE.message("learn.ui.button.stop.lesson", new Object[0])){

            public void actionPerformed(@Nullable ActionEvent e) {
                LessonManager.Companion.getInstance().stopLesson$intellij_featuresTrainer();
            }
        });
        balloon2.show(this.getPosition(ui, balloonConfig.getSide()), balloonConfig.getSide());
    }

    private final RelativePoint getPosition(JComponent component2, Balloon.Position side) {
        int n;
        int n2;
        Rectangle rectangle2 = LearningUiHighlightingManager.INSTANCE.getRectangle(component2);
        if (rectangle2 == null) {
            rectangle2 = component2.getVisibleRect();
        }
        Rectangle visibleRect = rectangle2;
        switch (LessonExecutorUtil$WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = visibleRect.width;
                break;
            }
            case 3: 
            case 4: {
                n2 = visibleRect.width / 2;
                break;
            }
            default: {
                String string = "Unexpected balloon position";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        int xShift = n2;
        switch (LessonExecutorUtil$WhenMappings.$EnumSwitchMapping$1[side.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = visibleRect.height;
                break;
            }
            case 3: 
            case 4: {
                n = visibleRect.height / 2;
                break;
            }
            default: {
                String string = "Unexpected balloon position";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        int yShift = n;
        Point point = new Point(visibleRect.x + xShift, visibleRect.y + yShift);
        return new RelativePoint((Component)component2, point);
    }

    private LessonExecutorUtil() {
    }

    static {
        LessonExecutorUtil lessonExecutorUtil;
        INSTANCE = lessonExecutorUtil = new LessonExecutorUtil();
    }
}

