/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.ext;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ElementSort {
    @NotNull
    private final GradleDslElement myElement;
    @NotNull
    private final GradlePropertiesDslElement myParent;

    private ElementSort(@NotNull GradlePropertiesDslElement parentElement, @NotNull GradleDslElement element) {
        if (parentElement == null) {
            ElementSort.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ElementSort.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myParent = parentElement;
    }

    public static ElementSort create(@NotNull GradlePropertiesDslElement parent, @NotNull GradleDslElement element) {
        if (parent == null) {
            ElementSort.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ElementSort.$$$reportNull$$$0(3);
        }
        return new ElementSort(parent, element);
    }

    public boolean sort(@NotNull List<GradleDslElement> elementList, @NotNull List<GradleDslElement> resultList) {
        if (elementList == null) {
            ElementSort.$$$reportNull$$$0(4);
        }
        if (resultList == null) {
            ElementSort.$$$reportNull$$$0(5);
        }
        HashMap<GradleDslElement, State> states = new HashMap<GradleDslElement, State>();
        elementList.forEach(e -> states.put((GradleDslElement)e, State.UNMARKED));
        ArrayList<GradleDslElement> postSort = new ArrayList<GradleDslElement>();
        for (GradleDslElement e2 : elementList) {
            if (this.visit(states, e2, postSort)) continue;
            return false;
        }
        resultList.clear();
        resultList.addAll(postSort);
        return true;
    }

    private boolean visit(@NotNull Map<GradleDslElement, State> states, @NotNull GradleDslElement element, @NotNull List<GradleDslElement> postSort) {
        if (states == null) {
            ElementSort.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ElementSort.$$$reportNull$$$0(7);
        }
        if (postSort == null) {
            ElementSort.$$$reportNull$$$0(8);
        }
        if (states.get(element) == State.PERM_MARK) {
            return true;
        }
        if (states.get(element) == State.TEMP_MARK) {
            return false;
        }
        states.put(element, State.TEMP_MARK);
        for (GradleDslElement item : this.gatherDependencies(element)) {
            if (this.visit(states, item, postSort)) continue;
            return false;
        }
        states.put(element, State.PERM_MARK);
        postSort.add(element);
        return true;
    }

    private List<GradleDslElement> gatherDependencies(@NotNull GradleDslElement element) {
        if (element == null) {
            ElementSort.$$$reportNull$$$0(9);
        }
        return element.getDependencies().stream().map(e -> {
            GradleDslElement newElement = e.getToBeInjected();
            if (newElement == null && this.myElement.getNameElement().containsPropertyReference(e.getName())) {
                return this.myElement;
            }
            if (newElement == null) {
                newElement = e.getOriginElement().resolveReference(e.getName(), false);
            }
            while (newElement != null && newElement.getParent() != this.myParent) {
                newElement = newElement.getParent();
            }
            return newElement;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postSort";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/ext/ElementSort";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "sort";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "gatherDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum State {
        UNMARKED,
        TEMP_MARK,
        PERM_MARK;

    }
}

