/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.io.IOException;
import java.util.HashMap;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageSourceData;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.impl.ClassDataBean;
import jetbrains.coverage.report.impl.html.BaseGenerator;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassSourceReportGenerator
extends BaseGenerator {
    private final CoverageSourceData myData;

    public ClassSourceReportGenerator(@NotNull TemplateProcessor templateFactory, @NotNull LocalGeneratorPaths paths, @Nullable CoverageSourceData data) {
        if (templateFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ClassSourceReportGenerator.<init> must not be null");
        }
        if (paths == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/ClassSourceReportGenerator.<init> must not be null");
        }
        super(templateFactory, paths);
        this.myData = data;
    }

    public void generateClassCoverage(ModuleInfo module, String namespace, ClassInfo cd, StatisticsCalculator covStatsCalculator) throws IOException {
        HashMap<String, Object> templateModel = new HashMap<String, Object>();
        templateModel.put("module", module);
        templateModel.put("namespace", namespace);
        templateModel.put("classDataBean", new ClassDataBean(cd, this.myData));
        templateModel.put("statsCalculator", covStatsCalculator);
        templateModel.put("sortOption", (Object)SortOption.NONE);
        this.myTemplateFactory.renderTemplate(templateModel, this.myPaths.getClassCoveragePath(module, namespace, cd));
    }
}

