/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.TypeComponentImpl;
import com.jetbrains.sa.jdi.ValueImpl;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FieldIdentifier;
import sun.jvm.hotspot.oops.FieldType;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;

public class FieldImpl
extends TypeComponentImpl {
    private Field saField;

    FieldImpl(ReferenceTypeImpl declaringType, Field saField) {
        super(declaringType);
        this.saField = saField;
        this.signature = saField.getSignature().asString();
    }

    Field ref() {
        return this.saField;
    }

    public long uniqueID() {
        return this.hashCode();
    }

    ValueImpl getValue() {
        return this.getValue((Oop)this.declaringType.getJavaMirror());
    }

    ValueImpl getValue(Oop target) {
        ValueImpl valueImpl;
        Field saField = this.ref();
        FieldType ft = saField.getFieldType();
        if (ft.isOop()) {
            valueImpl = this.vm().objectMirror(((OopField)saField).getValueAsOopHandle(target));
        } else if (ft.isByte()) {
            valueImpl = this.vm().mirrorOf(((ByteField)saField).getValue(target));
        } else if (ft.isChar()) {
            valueImpl = this.vm().mirrorOf(((CharField)saField).getValue(target));
        } else if (ft.isDouble()) {
            valueImpl = this.vm().mirrorOf(((DoubleField)saField).getValue(target));
        } else if (ft.isFloat()) {
            valueImpl = this.vm().mirrorOf(((FloatField)saField).getValue(target));
        } else if (ft.isInt()) {
            valueImpl = this.vm().mirrorOf(((IntField)saField).getValue(target));
        } else if (ft.isLong()) {
            valueImpl = this.vm().mirrorOf(((LongField)saField).getValue(target));
        } else if (ft.isShort()) {
            valueImpl = this.vm().mirrorOf(((ShortField)saField).getValue(target));
        } else if (ft.isBoolean()) {
            valueImpl = this.vm().mirrorOf(((BooleanField)saField).getValue(target));
        } else {
            throw new RuntimeException("Should not reach here");
        }
        return valueImpl;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldImpl) {
            FieldImpl other = (FieldImpl)obj;
            return this.declaringType().equals(other.declaringType()) && this.ref().equals((Object)other.ref()) && super.equals(obj);
        }
        return false;
    }

    public String genericSignature() {
        Symbol genSig = this.saField.getGenericSignature();
        return genSig != null ? genSig.asString() : null;
    }

    public String toString() {
        return this.declaringType().name() + '.' + this.name();
    }

    @Override
    public String name() {
        FieldIdentifier myName = this.saField.getID();
        return myName.getName();
    }

    @Override
    public int modifiers() {
        return this.saField.getAccessFlagsObj().getStandardFlags();
    }

    @Override
    public boolean isStatic() {
        return this.saField.isStatic();
    }

    @Override
    public int hashCode() {
        return this.saField.hashCode();
    }
}

