/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;

public class ExtensionPointIndex
extends PluginXmlIndexBase<String, Integer> {
    private static final ID<String, Integer> NAME = ID.create((String)"devkit.ExtensionPointIndex");

    @NotNull
    public ID<String, Integer> getName() {
        ID<String, Integer> iD = NAME;
        if (iD == null) {
            ExtensionPointIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    protected Map<String, Integer> performIndexing(IdeaPlugin plugin) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ExtensionPointIndex.indexExtensionPoints(plugin, (Consumer<? super ExtensionPoint>)((Consumer)point -> result.put(point.getEffectiveQualifiedName(), point.getXmlTag().getTextOffset())));
        return result;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            ExtensionPointIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            ExtensionPointIndex.$$$reportNull$$$0(2);
        }
        return enumeratorIntegerDescriptor;
    }

    public int getVersion() {
        return 0;
    }

    @Nullable
    public static ExtensionPoint findExtensionPoint(Module module, String fqn) {
        return ExtensionPointIndex.findExtensionPoint(module.getProject(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false), fqn);
    }

    @Nullable
    public static ExtensionPoint findExtensionPoint(Project project, GlobalSearchScope scope, String fqn) {
        Ref result = Ref.create();
        FileBasedIndex.getInstance().processValues(NAME, (Object)fqn, null, (file, value) -> {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            DomManager domManager = DomManager.getDomManager((Project)project);
            result.set((Object)ExtensionPointIndex.getExtensionPointDom(psiManager, domManager, file, value));
            return false;
        }, scope);
        return (ExtensionPoint)result.get();
    }

    public static Map<String, Supplier<ExtensionPoint>> getExtensionPoints(Project project, Set<VirtualFile> files, String epPrefix) {
        HashMap<String, Supplier<ExtensionPoint>> result = new HashMap<String, Supplier<ExtensionPoint>>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        DomManager domManager = DomManager.getDomManager((Project)project);
        for (VirtualFile file : files) {
            Map data = FileBasedIndex.getInstance().getFileData(NAME, file, project);
            if (data.isEmpty()) continue;
            for (Map.Entry entry : data.entrySet()) {
                String qualifiedName = (String)entry.getKey();
                if (!StringUtil.startsWith((CharSequence)qualifiedName, (CharSequence)epPrefix)) continue;
                result.put(qualifiedName, () -> ExtensionPointIndex.getExtensionPointDom(psiManager, domManager, file, (Integer)entry.getValue()));
            }
        }
        return result;
    }

    @Nullable
    static ExtensionPoint getExtensionPointDom(PsiManager psiManager, DomManager domManager, VirtualFile file, int offset) {
        PsiFile psiFile = psiManager.findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        PsiElement psiElement = psiFile.findElementAt(offset);
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
        DomElement domElement = domManager.getDomElement(xmlTag);
        return (ExtensionPoint)ObjectUtils.tryCast((Object)domElement, ExtensionPoint.class);
    }

    static void indexExtensionPoints(IdeaPlugin plugin, Consumer<? super ExtensionPoint> consumer) {
        for (DomElement points : ExtensionPointIndex.getChildrenWithoutIncludes(plugin, "extensionPoints")) {
            for (DomElement point : ExtensionPointIndex.getChildrenWithoutIncludes(points, "extensionPoint")) {
                ExtensionPoint extensionPoint = (ExtensionPoint)point;
                consumer.consume((Object)extensionPoint);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/devkit/dom/index/ExtensionPointIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

