/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.icons;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Supplier;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actions.ThemeFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.DevKitBundle;

public enum Theme implements ThemeFilter
{
    WHITE(null, (Supplier)DevKitBundle.messagePointer("action.default.theme.text", new Object[0])){

        public boolean accepts(VirtualFile fileName) {
            String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)fileName.getName());
            for (Theme theme : 1.values()) {
                String extension = theme.getExtension();
                if (extension == null || !nameWithoutExtension.endsWith(extension)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    HIGH_DPI_WHITE("@2x", (Supplier)DevKitBundle.messagePointer("action.default.hidpi.theme.text", new Object[0])){

        public boolean accepts(VirtualFile fileName) {
            return FileUtilRt.getNameWithoutExtension((String)fileName.getName()).endsWith(this.getExtension());
        }
    }
    ,
    DARK("_dark", (Supplier)DevKitBundle.messagePointer("action.darcula.theme.text", new Object[0])){

        public boolean accepts(VirtualFile file) {
            String name = FileUtilRt.getNameWithoutExtension((String)file.getName());
            if (name.endsWith(this.getExtension()) && !name.endsWith(HIGH_DPI_DARK.getExtension())) {
                return true;
            }
            VirtualFile parent = file.getParent();
            if (parent != null && parent.findChild(name + "_dark.png") != null) {
                return false;
            }
            return WHITE.accepts(file);
        }
    }
    ,
    HIGH_DPI_DARK("@2x_dark", (Supplier)DevKitBundle.messagePointer("action.darcula.hidpi.theme.text", new Object[0])){

        public boolean accepts(VirtualFile file) {
            String name = FileUtilRt.getNameWithoutExtension((String)file.getName());
            if (name.endsWith(this.getExtension())) {
                return true;
            }
            VirtualFile parent = file.getParent();
            if (parent != null && parent.findChild(name + "_dark.png") != null) {
                return false;
            }
            return HIGH_DPI_WHITE.accepts(file);
        }
    };

    private final String myExtension;
    private final Supplier<@NlsActions.ActionText String> myDisplayNameSupplier;

    private Theme(String extension, Supplier<String> displayNameSupplier) {
        this.myExtension = extension;
        this.myDisplayNameSupplier = displayNameSupplier;
    }

    @NonNls
    public String getExtension() {
        return this.myExtension;
    }

    public String getDisplayName() {
        return this.myDisplayNameSupplier.get();
    }

    public boolean isApplicableToProject(Project project) {
        return true;
    }

    public void setFilter(ThumbnailView view) {
        view.setFilter((ThemeFilter)this);
    }
}

