/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.UseCoupleQuickFix;

public class UseCoupleInspection
extends DevKitInspectionBase {
    private static final String PAIR_FQN = "com.intellij.openapi.util.Pair";

    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseCoupleInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitTypeElement(PsiTypeElement typeElement) {
                PsiType[] parameters;
                PsiClassType classType;
                String canonicalText;
                super.visitTypeElement(typeElement);
                PsiType type = typeElement.getType();
                if (type instanceof PsiClassType && UseCoupleInspection.PAIR_FQN.equals(canonicalText = (classType = (PsiClassType)type).rawType().getCanonicalText()) && (parameters = classType.getParameters()).length == 2 && parameters[0].equals(parameters[1])) {
                    String name = DevKitBundle.message("inspections.use.couple.type", parameters[0].getPresentableText());
                    holder.registerProblem((PsiElement)typeElement, name, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new UseCoupleQuickFix(name)});
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiElement nameElement;
                PsiType[] types;
                PsiClass psiClass;
                PsiMethod method;
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                if ("create".equals(methodExpression.getReferenceName()) && (method = expression.resolveMethod()) != null && (psiClass = method.getContainingClass()) != null && UseCoupleInspection.PAIR_FQN.equals(psiClass.getQualifiedName()) && (types = expression.getArgumentList().getExpressionTypes()).length == 2 && types[0].equals(types[1]) && (nameElement = methodExpression.getReferenceNameElement()) != null) {
                    String name = DevKitBundle.message("inspections.use.couple.of", new Object[0]);
                    holder.registerProblem(nameElement, name, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new UseCoupleQuickFix(name)});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UseCoupleInspection", "buildInternalVisitor"));
    }
}

