/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.ui.JBUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

public class ConvertToJBInsetsQuickFix
implements LocalQuickFix {
    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.use.dpi.aware.insets.family.name", new Object[0]);
        if (string == null) {
            ConvertToJBInsetsQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiNewExpression newExpression;
        PsiExpressionList list;
        if (project == null) {
            ConvertToJBInsetsQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            ConvertToJBInsetsQuickFix.$$$reportNull$$$0(2);
        }
        if ((list = (newExpression = (PsiNewExpression)descriptor.getPsiElement()).getArgumentList()) != null && list.getExpressionCount() == 4) {
            String right;
            String bottom;
            String left;
            String top = list.getExpressions()[0].getText();
            Object text = ConvertToJBInsetsQuickFix.isZero(top, left = list.getExpressions()[1].getText(), bottom = list.getExpressions()[2].getText(), right = list.getExpressions()[3].getText()) ? "emptyInsets()" : (ConvertToJBInsetsQuickFix.isZero(left, bottom, right) ? "insetsTop(" + top + ")" : (ConvertToJBInsetsQuickFix.isZero(top, bottom, right) ? "insetsLeft(" + left + ")" : (ConvertToJBInsetsQuickFix.isZero(top, left, right) ? "insetsBottom(" + bottom + ")" : (ConvertToJBInsetsQuickFix.isZero(top, left, bottom) ? "insetsRight(" + right + ")" : (top.equals(left) && left.equals(bottom) && bottom.equals(right) && right.equals(top) ? "insets(" + top + ")" : (top.equals(bottom) && right.equals(left) ? String.format("insets(%s, %s)", top, left) : String.format("insets(%s, %s, %s, %s)", top, left, bottom, right)))))));
            text = JBUI.class.getName() + "." + (String)text;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiExpression expression = factory.createExpressionFromText((String)text, newExpression.getContext());
            PsiElement newElement = newExpression.replace((PsiElement)expression);
            PsiElement el = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
            int offset = el.getTextOffset() + el.getText().length() - 2;
            Editor editor = PsiEditorUtil.findEditor((PsiElement)el);
            if (editor != null) {
                editor.getCaretModel().moveToOffset(offset);
            }
        }
    }

    private static boolean isZero(String ... args) {
        if (args.length == 0) {
            return false;
        }
        for (String arg : args) {
            if ("0".equals(arg)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/ConvertToJBInsetsQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/ConvertToJBInsetsQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

