/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Actions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.OverrideText;
import org.jetbrains.idea.devkit.dom.Separator;
import org.jetbrains.idea.devkit.dom.Synonym;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class DescriptorI18nUtil {
    @NonNls
    public static final String CORE_ACTIONS_BUNDLE = "messages.ActionsBundle";

    @Nullable
    public static PropertiesFile findBundlePropertiesFile(@Nullable DomElement domElement) {
        XmlAttributeValue bundleXmlElement = null;
        Actions actions = null;
        if (domElement instanceof ActionOrGroup || domElement instanceof Separator || domElement instanceof OverrideText || domElement instanceof Synonym) {
            actions = (Actions)DomUtil.getParentOfType((DomElement)domElement, Actions.class, (boolean)true);
            if (actions == null) {
                return null;
            }
            XmlAttributeValue xmlAttributeValue = bundleXmlElement = DomUtil.hasXml(actions.getResourceBundle()) ? actions.getResourceBundle().getXmlAttributeValue() : null;
        }
        if (bundleXmlElement == null) {
            IdeaPlugin ideaPlugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)domElement, IdeaPlugin.class, (boolean)true);
            if (ideaPlugin == null) {
                return null;
            }
            XmlElement xmlElement = bundleXmlElement = DomUtil.hasXml(ideaPlugin.getResourceBundle()) ? ideaPlugin.getResourceBundle().getXmlElement() : null;
        }
        if (bundleXmlElement == null) {
            return DescriptorI18nUtil.findCoreActionsBundlePropertiesFile(actions);
        }
        ResourceBundleReference bundleReference = (ResourceBundleReference)ContainerUtil.findInstance((Object[])bundleXmlElement.getReferences(), ResourceBundleReference.class);
        if (bundleReference == null) {
            return null;
        }
        return (PropertiesFile)ObjectUtils.tryCast((Object)bundleReference.resolve(), PropertiesFile.class);
    }

    public static boolean canFallbackToCoreActionsBundle(@Nullable Actions actions) {
        if (actions == null) {
            return false;
        }
        Module module = actions.getModule();
        if (module == null) {
            return false;
        }
        if (PsiUtil.isIdeaProject(module.getProject()) && (module.getName().startsWith("intellij.platform.") || ApplicationManager.getApplication().isUnitTestMode())) {
            return true;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)actions, IdeaPlugin.class, (boolean)true);
        if (ideaPlugin == null) {
            return false;
        }
        return "com.intellij".equals(ideaPlugin.getPluginId());
    }

    @Nullable
    private static PropertiesFile findCoreActionsBundlePropertiesFile(@Nullable Actions actions) {
        Module resourcesModule;
        if (!DescriptorI18nUtil.canFallbackToCoreActionsBundle(actions)) {
            return null;
        }
        Module module = actions.getModule();
        assert (module != null);
        Project project = module.getProject();
        Module module2 = resourcesModule = ApplicationManager.getApplication().isUnitTestMode() ? module : ModuleManager.getInstance((Project)project).findModuleByName("intellij.platform.resources.en");
        if (resourcesModule == null) {
            return null;
        }
        PropertiesReferenceManager propertiesReferenceManager = PropertiesReferenceManager.getInstance((Project)project);
        List actionsBundleFiles = propertiesReferenceManager.findPropertiesFiles(resourcesModule, CORE_ACTIONS_BUNDLE);
        return (PropertiesFile)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem((Collection)actionsBundleFiles), PropertiesFile.class);
    }
}

