/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.modules;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightJavaModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;

public class ModuleHighlightUtil2 {
    private static final Attributes.Name MULTI_RELEASE = new Attributes.Name("Multi-Release");

    @Nullable
    static PsiJavaModule getModuleDescriptor(@NotNull VirtualFile file, @NotNull Project project) {
        ProjectFileIndex index2;
        if (file == null) {
            ModuleHighlightUtil2.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ModuleHighlightUtil2.$$$reportNull$$$0(1);
        }
        if ((index2 = ProjectFileIndex.SERVICE.getInstance((Project)project)).isInLibrary(file)) {
            VirtualFile root2 = index2.getClassRootForFile(file);
            if (root2 != null) {
                VirtualFile alt;
                VirtualFile descriptorFile = root2.findChild("module-info.class");
                if (descriptorFile == null && (alt = root2.findFileByRelativePath("META-INF/versions/9/module-info.class")) != null && ModuleHighlightUtil2.isMultiReleaseJar(root2)) {
                    descriptorFile = alt;
                }
                if (descriptorFile != null) {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(descriptorFile);
                    if (psiFile instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile).getModuleDeclaration();
                    }
                } else if (root2.getFileSystem() instanceof JarFileSystem && "jar".equalsIgnoreCase(root2.getExtension())) {
                    return LightJavaModule.findModule((PsiManager)PsiManager.getInstance((Project)project), (VirtualFile)root2);
                }
            } else {
                PsiFile psiFile;
                VirtualFile descriptorFile;
                root2 = index2.getSourceRootForFile(file);
                if (root2 != null && (descriptorFile = root2.findChild("module-info.java")) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(descriptorFile)) instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            }
        } else {
            Module module = index2.getModuleForFile(file);
            if (module != null) {
                boolean isTest = FileIndexUtilsKt.isInTestSourceContentKotlinAware((FileIndex)index2, file);
                VirtualFile modularRoot = (VirtualFile)ArraysKt.singleOrNull((Object[])ModuleRootManager.getInstance((Module)module).getSourceRoots(isTest), root -> root.findChild("module-info.java") != null);
                if (modularRoot != null) {
                    VirtualFile moduleInfo = modularRoot.findChild("module-info.java");
                    assert (moduleInfo != null) : modularRoot;
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(moduleInfo);
                    if (psiFile instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile).getModuleDeclaration();
                    }
                }
            }
        }
        return null;
    }

    private static boolean isMultiReleaseJar(VirtualFile root) {
        VirtualFile manifest;
        if (root.getFileSystem() instanceof JarFileSystem && (manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF")) != null) {
            boolean bl;
            block9: {
                InputStream stream = manifest.getInputStream();
                try {
                    bl = Boolean.valueOf(new Manifest(stream).getMainAttributes().getValue(MULTI_RELEASE));
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/modules/ModuleHighlightUtil2";
        objectArray[2] = "getModuleDescriptor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

