/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.unusedDef;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectProcedure;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyLocalInspectionBase;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;

public class UnusedDefInspection
extends GroovyLocalInspectionBase {
    private static final Logger LOG = Logger.getInstance(UnusedDefInspection.class);

    @NotNull
    public String getShortName() {
        return "GroovyUnusedAssignment";
    }

    @Override
    protected void check(@NotNull GrControlFlowOwner owner, final @NotNull ProblemsHolder problemsHolder) {
        ReachingDefinitionsSemilattice lattice;
        ReachingDefinitionsDfaInstance dfaInstance;
        Instruction[] flow;
        DFAEngine<DefinitionMap> engine;
        List<DefinitionMap> dfaResult;
        if (owner == null) {
            UnusedDefInspection.$$$reportNull$$$0(0);
        }
        if (problemsHolder == null) {
            UnusedDefInspection.$$$reportNull$$$0(1);
        }
        if ((dfaResult = (engine = new DFAEngine<DefinitionMap>(flow = owner.getControlFlow(), dfaInstance = new ReachingDefinitionsDfaInstance(flow, UtilKt.getVarIndexes(owner)), lattice = new ReachingDefinitionsSemilattice())).performDFAWithTimeout()) == null) {
            return;
        }
        TIntHashSet unusedDefs = new TIntHashSet();
        for (Instruction instruction : flow) {
            if (!(instruction instanceof ReadWriteVariableInstruction) || !((ReadWriteVariableInstruction)instruction).isWrite()) continue;
            unusedDefs.add(instruction.num());
        }
        for (int i = 0; i < dfaResult.size(); ++i) {
            ReadWriteVariableInstruction varInst;
            Instruction instruction = flow[i];
            if (!(instruction instanceof ReadWriteVariableInstruction) || (varInst = (ReadWriteVariableInstruction)instruction).isWrite()) continue;
            VariableDescriptor descriptor = varInst.getDescriptor();
            DefinitionMap e = dfaResult.get(i);
            e.forEachValue((TObjectProcedure<TIntHashSet>)((TObjectProcedure)reaching -> {
                reaching.forEach(defNum -> {
                    VariableDescriptor defDescriptor = ((ReadWriteVariableInstruction)flow[defNum]).getDescriptor();
                    if (descriptor.equals(defDescriptor)) {
                        unusedDefs.remove(defNum);
                    }
                    return true;
                });
                return true;
            }));
        }
        final HashSet checked = new HashSet();
        unusedDefs.forEach(num -> {
            ReadWriteVariableInstruction instruction = (ReadWriteVariableInstruction)flow[num];
            PsiElement element = instruction.getElement();
            UnusedDefInspection.process(element, checked, problemsHolder, GroovyBundle.message("unused.assignment.tooltip", new Object[0]));
            return true;
        });
        owner.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof GrControlFlowOwner)) {
                    if (element instanceof GrVariable && !(element instanceof GrField)) {
                        GrVariable variable = (GrVariable)element;
                        if (checked.contains(variable) || variable.getInitializerGroovy() != null) {
                            return;
                        }
                        if (ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope()).findFirst() == null) {
                            UnusedDefInspection.process(variable, checked, problemsHolder, GroovyBundle.message("unused.variable", new Object[0]));
                        }
                    } else {
                        super.visitElement(element);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/codeInspection/unusedDef/UnusedDefInspection$1", "visitElement"));
            }
        });
    }

    private static void process(@Nullable PsiElement element, Set<PsiElement> checked, ProblemsHolder problemsHolder, @InspectionMessage String message) {
        if (element == null) {
            return;
        }
        if (!checked.add(element)) {
            return;
        }
        if (UnusedDefInspection.isLocalAssignment(element) && UnusedDefInspection.isUsedInTopLevelFlowOnly(element) && !UnusedDefInspection.isIncOrDec(element)) {
            PsiElement toHighlight = UnusedDefInspection.getHighlightElement(element);
            problemsHolder.registerProblem(toHighlight, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
        }
    }

    private static PsiElement getHighlightElement(PsiElement element) {
        PsiElement toHighlight = null;
        if (element instanceof GrReferenceExpression) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof GrAssignmentExpression) {
                toHighlight = ((GrAssignmentExpression)parent2).getLValue();
            }
            if (parent2 instanceof GrUnaryExpression && ((GrUnaryExpression)parent2).isPostfix()) {
                toHighlight = parent2;
            }
        } else if (element instanceof GrVariable) {
            toHighlight = ((GrVariable)element).getNameIdentifierGroovy();
        }
        if (toHighlight == null) {
            toHighlight = element;
        }
        return toHighlight;
    }

    private static boolean isIncOrDec(PsiElement element) {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof GrUnaryExpression)) {
            return false;
        }
        IElementType type2 = ((GrUnaryExpression)parent2).getOperationTokenType();
        return type2 == GroovyTokenTypes.mINC || type2 == GroovyTokenTypes.mDEC;
    }

    private static boolean isUsedInTopLevelFlowOnly(PsiElement element) {
        PsiElement resolved;
        GrVariable var = null;
        if (element instanceof GrVariable) {
            var = (GrVariable)element;
        } else if (element instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)element).resolve()) instanceof GrVariable) {
            var = (GrVariable)resolved;
        }
        if (var != null) {
            GrControlFlowOwner scope = ControlFlowUtils.findControlFlowOwner(var);
            if (scope == null) {
                PsiFile file = var.getContainingFile();
                if (file == null) {
                    LOG.error("no file??? var of type" + var.getClass().getCanonicalName());
                } else {
                    TextRange range = var.getTextRange();
                    LOG.error("var: " + var.getName() + ", offset:" + (range != null ? range.getStartOffset() : -1));
                }
                return false;
            }
            return ReferencesSearch.search((PsiElement)var, (SearchScope)var.getUseScope()).forEach(ref -> ControlFlowUtils.findControlFlowOwner(ref.getElement()) == scope);
        }
        return true;
    }

    private static boolean isLocalAssignment(PsiElement element) {
        if (element instanceof GrVariable) {
            return UnusedDefInspection.isLocalVariable((GrVariable)element, false);
        }
        if (element instanceof GrReferenceExpression) {
            PsiElement resolved = ((GrReferenceExpression)element).resolve();
            return resolved instanceof GrVariable && UnusedDefInspection.isLocalVariable((GrVariable)resolved, true);
        }
        return false;
    }

    private static boolean isLocalVariable(GrVariable var, boolean parametersAllowed) {
        return !(var instanceof GrField) && (!(var instanceof GrParameter) || parametersAllowed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "owner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "problemsHolder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/unusedDef/UnusedDefInspection";
        objectArray[2] = "check";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

