/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class AddReturnTypeFix
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("add.return.type", new Object[0]);
        if (string == null) {
            AddReturnTypeFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.return.type.to.method.declaration", new Object[0]);
        if (string == null) {
            AddReturnTypeFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddReturnTypeFix.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        return AddReturnTypeFix.findMethod(file, offset) != null;
    }

    @Nullable
    private static GrMethod findMethod(PsiFile file, int offset) {
        PsiElement at = file.findElementAt(offset);
        if (at == null) {
            return null;
        }
        if (at.getParent() instanceof GrReturnStatement) {
            GrTypeElement returnTypeElement;
            GrReturnStatement returnStatement = (GrReturnStatement)at.getParent();
            PsiElement word = returnStatement.getReturnWord();
            if (!word.getTextRange().contains(offset)) {
                return null;
            }
            GroovyPsiElement returnOwner = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{GrClosableBlock.class, GrMethod.class});
            if (returnOwner instanceof GrMethod && (returnTypeElement = ((GrMethod)returnOwner).getReturnTypeElementGroovy()) == null) {
                return (GrMethod)returnOwner;
            }
            return null;
        }
        GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)at, GrMethod.class, (boolean)false, (Class[])new Class[]{GrTypeDefinition.class, GrClosableBlock.class});
        if (method == null) {
            return null;
        }
        TextRange headerRange = GrHighlightUtil.getMethodHeaderTextRange(method);
        if (!headerRange.contains(offset) && !headerRange.contains(offset - 1)) {
            return null;
        }
        if (method.isConstructor()) {
            return null;
        }
        if (method.getReturnTypeElementGroovy() != null) {
            return null;
        }
        return method;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        GrMethod method;
        if (project == null) {
            AddReturnTypeFix.$$$reportNull$$$0(3);
        }
        if ((method = AddReturnTypeFix.findMethod(file, editor.getCaretModel().getOffset())) == null) {
            return;
        }
        AddReturnTypeFix.applyFix(project, method);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void applyFix(@NotNull Project project, @NotNull GrMethod method) {
        PsiType type2;
        if (project == null) {
            AddReturnTypeFix.$$$reportNull$$$0(4);
        }
        if (method == null) {
            AddReturnTypeFix.$$$reportNull$$$0(5);
        }
        if ((type2 = method.getInferredReturnType()) == null) {
            type2 = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)method.getResolveScope());
        }
        type2 = TypesUtil.unboxPrimitiveTypeWrapper(type2);
        GrReferenceAdjuster.shortenAllReferencesIn(method.setReturnType(type2));
        method.getModifierList().setModifierProperty("def", false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/style/AddReturnTypeFix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/style/AddReturnTypeFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

