/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference.driver;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceContext;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.BoundConstraint;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriverUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.TypeUsageInformation;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.TypeUsageInformationBuilder;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\tJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\fJ\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0013H\u0002J\u0006\u0010#\u001a\u00020$J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\f2\u0006\u0010(\u001a\u00020'2\u0006\u0010,\u001a\u00020-R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R6\u0010\u0016\u001a(\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\f0\f \u0018*\u0014\u0012\u000e\b\u0001\u0012\n \u0018*\u0004\u0018\u00010\f0\f\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/TypeUsageInformationBuilder;", "", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "signatureInferenceContext", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceContext;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceContext;)V", "constraints", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "dependentTypes", "", "Lcom/intellij/psi/PsiTypeParameter;", "expressions", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "javaLangObject", "Lcom/intellij/psi/PsiClassType;", "requiredClassTypes", "", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/BoundConstraint;", "getSignatureInferenceContext", "()Lorg/jetbrains/plugins/groovy/intentions/style/inference/SignatureInferenceContext;", "variableTypeParameters", "", "kotlin.jvm.PlatformType", "[Lcom/intellij/psi/PsiTypeParameter;", "addConstrainingExpression", "", "expression", "addConstraint", "constraintFormula", "addDependentType", "typeParameter", "addRequiredType", "constraint", "build", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/TypeUsageInformation;", "expandWildcards", "", "Lcom/intellij/psi/PsiType;", "type", "context", "Lcom/intellij/psi/PsiElement;", "generateRequiredTypes", "marker", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/BoundConstraint$ContainMarker;", "Companion", "intellij.groovy"})
public final class TypeUsageInformationBuilder {
    private final Map<PsiTypeParameter, List<BoundConstraint>> requiredClassTypes;
    private final List<ConstraintFormula> constraints;
    private final Set<PsiTypeParameter> dependentTypes;
    private final PsiTypeParameter[] variableTypeParameters;
    private final PsiClassType javaLangObject;
    private final List<GrExpression> expressions;
    @NotNull
    private final SignatureInferenceContext signatureInferenceContext;
    public static final Companion Companion = new Companion(null);

    public final void generateRequiredTypes(@NotNull PsiTypeParameter typeParameter, @NotNull PsiType type2, @NotNull BoundConstraint.ContainMarker marker) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)marker), (String)"marker");
        PsiType filteredType = this.signatureInferenceContext.filterType(type2, (PsiElement)typeParameter);
        if (Intrinsics.areEqual((Object)filteredType, (Object)this.javaLangObject) && marker == BoundConstraint.ContainMarker.UPPER) {
            return;
        }
        List<PsiType> bindingTypes = this.expandWildcards(filteredType, (PsiElement)typeParameter);
        Iterable $this$forEach$iv = bindingTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiType it = (PsiType)element$iv;
            boolean bl = false;
            this.addRequiredType(typeParameter, new BoundConstraint(it, marker));
        }
    }

    public final void addConstraint(@NotNull ConstraintFormula constraintFormula) {
        Intrinsics.checkNotNullParameter((Object)constraintFormula, (String)"constraintFormula");
        this.constraints.add(constraintFormula);
    }

    public final void addConstrainingExpression(@NotNull GrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.expressions.add(expression);
    }

    public final void addDependentType(@NotNull PsiTypeParameter typeParameter) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        this.dependentTypes.add(typeParameter);
    }

    @NotNull
    public final TypeUsageInformation build() {
        return new TypeUsageInformation(this.requiredClassTypes, (Collection<? extends ConstraintFormula>)this.constraints, this.dependentTypes, this.expressions);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void addRequiredType(PsiTypeParameter typeParameter, BoundConstraint constraint) {
        Intrinsics.checkNotNullExpressionValue((Object)this.variableTypeParameters, (String)"variableTypeParameters");
        if (!ArraysKt.contains((Object[])this.variableTypeParameters, (Object)typeParameter)) return;
        if (constraint.getType().equalsToText("groovy.lang.GroovyObject")) return;
        PsiTypeParameter constraintTypeParameter = InferenceProcessUtilKt.typeParameter(constraint.getType());
        if (constraintTypeParameter != null) {
            Intrinsics.checkNotNullExpressionValue((Object)this.variableTypeParameters, (String)"variableTypeParameters");
            if (ArraysKt.contains((Object[])this.variableTypeParameters, (Object)constraintTypeParameter)) {
                this.dependentTypes.add(typeParameter);
                this.dependentTypes.add(constraintTypeParameter);
                return;
            }
        }
        TypeUsageInformationBuilder.Companion.safePut(this.requiredClassTypes, typeParameter, constraint);
    }

    private final List<PsiType> expandWildcards(PsiType type2, PsiElement context) {
        PsiType psiType = type2;
        return psiType instanceof PsiWildcardType ? (((PsiWildcardType)type2).isSuper() ? CollectionsKt.listOf((Object[])new PsiType[]{((PsiWildcardType)type2).getSuperBound(), (PsiType)InferenceDriverUtilKt.getJavaLangObject(context)}) : (((PsiWildcardType)type2).isExtends() ? CollectionsKt.listOf((Object[])new PsiType[]{((PsiWildcardType)type2).getExtendsBound(), (PsiType)PsiType.NULL}) : CollectionsKt.listOf((Object[])new PsiType[]{(PsiType)this.javaLangObject, (PsiType)PsiType.NULL}))) : CollectionsKt.listOf((Object)type2);
    }

    @NotNull
    public final SignatureInferenceContext getSignatureInferenceContext() {
        return this.signatureInferenceContext;
    }

    public TypeUsageInformationBuilder(@NotNull GrMethod method, @NotNull SignatureInferenceContext signatureInferenceContext) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)signatureInferenceContext, (String)"signatureInferenceContext");
        this.signatureInferenceContext = signatureInferenceContext;
        boolean bl = false;
        this.requiredClassTypes = new LinkedHashMap();
        bl = false;
        this.constraints = new ArrayList();
        bl = false;
        this.dependentTypes = new LinkedHashSet();
        this.variableTypeParameters = method.getTypeParameters();
        this.javaLangObject = InferenceDriverUtilKt.getJavaLangObject(method);
        bl = false;
        this.expressions = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006*\u0016\u0012\u0006\b\u0000\u0012\u0002H\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\b0\u00072\u0006\u0010\t\u001a\u0002H\u00052\u0006\u0010\n\u001a\u0002H\u0006H\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/inference/driver/TypeUsageInformationBuilder$Companion;", "", "()V", "safePut", "", "K", "V", "", "", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)Z", "intellij.groovy"})
    public static final class Companion {
        private final <K, V> boolean safePut(Map<? super K, List<V>> $this$safePut, K key, V value) {
            return $this$safePut.computeIfAbsent(key, safePut.1.INSTANCE).add(value);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

