/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.CodeBlockGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StatementWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public final class SwitchStatementGenerator {
    private SwitchStatementGenerator() {
    }

    public static void generate(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrSwitchStatement switchStatement) {
        PsiType type2;
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(1);
        }
        if (switchStatement == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(2);
        }
        GrExpression condition = switchStatement.getCondition();
        GrCaseSection[] caseSections = switchStatement.getCaseSections();
        PsiType psiType = type2 = condition == null ? null : TypesUtil.unboxPrimitiveTypeWrapper(condition.getType());
        if (type2 == null || SwitchStatementGenerator.isValidTypeForSwitchSelector(type2)) {
            SwitchStatementGenerator.generateSwitch(builder, context, condition, caseSections);
        } else {
            SwitchStatementGenerator.generateIfs(builder, context, condition, caseSections);
        }
    }

    private static boolean isValidTypeForSwitchSelector(@NotNull PsiType type2) {
        if (type2 == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(3);
        }
        if (TypeConversionUtil.getTypeRank((PsiType)type2) <= 4) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        return aClass != null && aClass.isEnum();
    }

    private static void generateIfs(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrExpression condition, GrCaseSection @NotNull [] caseSections) {
        GrExpression ref;
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(5);
        }
        if (condition == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(6);
        }
        if (caseSections == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(7);
        }
        if (condition instanceof GrReferenceExpression) {
            ref = condition;
        } else {
            String varName = SwitchStatementGenerator.generateConditionVar(builder, context, condition);
            ref = GroovyPsiElementFactory.getInstance(context.project).createExpressionFromText(varName);
        }
        GrExpression[] args = new GrExpression[]{ref};
        SwitchStatementGenerator.generateIfFromCaseSection(builder, context, caseSections, 0, args);
    }

    private static void generateIfFromCaseSection(@NotNull StringBuilder builder, @NotNull ExpressionContext context, final GrCaseSection @NotNull [] caseSections, final int i, final GrExpression @NotNull [] args) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(8);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(9);
        }
        if (caseSections == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(10);
        }
        if (args == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(11);
        }
        GenerationUtil.writeStatement(builder, context, null, new StatementWriter(){

            @Override
            public void writeStatement(StringBuilder builder, ExpressionContext context) {
                GrCaseSection section;
                GrCaseLabel[] labels;
                boolean isCase;
                GrCaseLabel[] labels2;
                if (caseSections.length == 1 && (labels2 = caseSections[0].getCaseLabels()).length == 1 && labels2[0].isDefault()) {
                    builder.append("if(true)");
                }
                boolean bl = isCase = (labels = (section = caseSections[i]).getCaseLabels()).length > 1 || !labels[0].isDefault();
                if (isCase) {
                    SwitchStatementGenerator.writeCondition(builder, context, section, labels, args);
                }
                SwitchStatementGenerator.writeCaseBody(builder, context, i, caseSections);
                if (isCase && i != caseSections.length - 1) {
                    builder.append("\nelse ");
                    StringBuilder elseBuilder = new StringBuilder();
                    ExpressionContext elseContext = context.extend();
                    SwitchStatementGenerator.generateIfFromCaseSection(elseBuilder, elseContext, caseSections, i + 1, args);
                    GenerationUtil.insertStatementFromContextBefore(builder, elseContext);
                    builder.append((CharSequence)elseBuilder);
                }
                if (!context.myStatements.isEmpty()) {
                    context.setInsertCurlyBrackets();
                }
            }
        });
    }

    private static void writeCaseBody(@NotNull StringBuilder builder, @NotNull ExpressionContext context, int i, GrCaseSection @NotNull [] caseSections) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(12);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(13);
        }
        if (caseSections == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(14);
        }
        builder.append("{\n");
        ExpressionContext extended = context.extend();
        CodeBlockGenerator generator = new CodeBlockGenerator(builder, extended);
        block0: for (int j = i; j < caseSections.length; ++j) {
            GrStatement[] statements2;
            GrCaseSection curSection = caseSections[j];
            for (GrStatement statement : statements2 = curSection.getStatements()) {
                if (statement instanceof GrBreakStatement && ((GrBreakStatement)statement).getLabelIdentifier() == null) break block0;
                statement.accept(generator);
                builder.append("\n");
            }
            if (SwitchStatementGenerator.brakesFlow(curSection)) break;
        }
        builder.append('}');
    }

    private static boolean brakesFlow(GrCaseSection section) {
        Object[] statements2 = section.getStatements();
        return statements2.length > 0 && !ControlFlowUtils.statementMayCompleteNormally((GrStatement)ArrayUtil.getLastElement((Object[])statements2));
    }

    private static void writeCondition(StringBuilder builder, ExpressionContext context, GrCaseSection section, GrCaseLabel[] labels, GrExpression[] args) {
        builder.append("if (");
        for (GrCaseLabel label : labels) {
            if (label.isDefault()) {
                builder.append("true");
            } else {
                GenerationUtil.invokeMethodByName(label.getValue(), "isCase", args, GrNamedArgument.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, new ExpressionGenerator(builder, context), section);
            }
            builder.append("||");
        }
        builder.delete(builder.length() - 2, builder.length());
        builder.append(") ");
    }

    private static String generateConditionVar(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrExpression condition) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(15);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(16);
        }
        if (condition == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(17);
        }
        StringBuilder conditionBuilder = new StringBuilder();
        PsiType type2 = condition.getType();
        String varName = GenerationUtil.validateName("switchArg", condition, context);
        conditionBuilder.append("final ");
        TypeWriter.writeType(conditionBuilder, type2, condition);
        conditionBuilder.append(' ').append(varName).append(" = ");
        condition.accept(new ExpressionGenerator(conditionBuilder, context));
        conditionBuilder.append(";\n");
        GenerationUtil.insertStatementFromContextBefore(builder, context);
        builder.append((CharSequence)conditionBuilder);
        return varName;
    }

    private static void generateSwitch(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @Nullable GrExpression condition, GrCaseSection @NotNull [] caseSections) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(18);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(19);
        }
        if (caseSections == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(20);
        }
        builder.append("switch (");
        if (condition != null) {
            condition.accept(new ExpressionGenerator(builder, context));
        }
        builder.append(") {\n");
        ExpressionContext innerContext = context.extend();
        for (GrCaseSection section : caseSections) {
            SwitchStatementGenerator.generateCaseSection(builder, context, innerContext, section);
        }
        builder.append('}');
    }

    private static void generateCaseSection(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull ExpressionContext innerContext, @NotNull GrCaseSection section) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(21);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(22);
        }
        if (innerContext == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(23);
        }
        if (section == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(24);
        }
        for (GrCaseLabel label : section.getCaseLabels()) {
            SwitchStatementGenerator.writeLabel(builder, context, label);
        }
        GrStatement[] statements2 = section.getStatements();
        CodeBlockGenerator generator = new CodeBlockGenerator(builder, innerContext);
        for (GrStatement statement : statements2) {
            statement.accept(generator);
            builder.append("\n");
        }
    }

    private static void writeLabel(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @NotNull GrCaseLabel label) {
        if (builder == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(25);
        }
        if (context == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(26);
        }
        if (label == null) {
            SwitchStatementGenerator.$$$reportNull$$$0(27);
        }
        if (label.isDefault()) {
            builder.append("default");
        } else {
            Object evaluated;
            builder.append("case ");
            GrExpression value = label.getValue();
            try {
                evaluated = GroovyConstantExpressionEvaluator.evaluate(value);
            }
            catch (Throwable e) {
                evaluated = null;
            }
            if (evaluated != null) {
                builder.append(evaluated);
            } else if (value != null) {
                value.accept(new ExpressionGenerator(builder, context));
            }
        }
        builder.append(":\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseSections";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerContext";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/SwitchStatementGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidTypeForSwitchSelector";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generateIfs";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "generateIfFromCaseSection";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "writeCaseBody";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "generateConditionVar";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "generateSwitch";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "generateCaseSection";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLabel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

