/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unused;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.unused.UnusedPropertyInspection;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnusedPropertyUtil {
    private static final Logger LOG = Logger.getInstance(UnusedPropertyUtil.class);

    @NotNull
    public static Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> buildPropertyGroupVisitor(@NotNull ResourceBundle resourceBundle) {
        Module module;
        if (resourceBundle == null) {
            UnusedPropertyUtil.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)resourceBundle.getDefaultPropertiesFile().getContainingFile())) == null) {
            Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> function = x -> null;
            if (function == null) {
                UnusedPropertyUtil.$$$reportNull$$$0(1);
            }
            return function;
        }
        UnusedPropertyInspection.UnusedPropertiesSearchHelper helper = new UnusedPropertyInspection.UnusedPropertiesSearchHelper(module);
        Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> function = properties -> {
            ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray;
            if (!UnusedPropertyInspection.isPropertyUsed((Property)((Property)properties[0]), (UnusedPropertyInspection.UnusedPropertiesSearchHelper)helper, (boolean)true)) {
                ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray2 = new ResourceBundleEditorProblemDescriptor[1];
                resourceBundleEditorProblemDescriptorArray = resourceBundleEditorProblemDescriptorArray2;
                resourceBundleEditorProblemDescriptorArray2[0] = new ResourceBundleEditorProblemDescriptor(ProblemHighlightType.LIKE_UNUSED_SYMBOL, PropertiesBundle.message((String)"unused.property.problem.descriptor.name", (Object[])new Object[0]), new RemovePropertiesFromAllLocalesFix((Property)properties[0]));
            } else {
                resourceBundleEditorProblemDescriptorArray = null;
            }
            return resourceBundleEditorProblemDescriptorArray;
        };
        if (function == null) {
            UnusedPropertyUtil.$$$reportNull$$$0(2);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unused/UnusedPropertyUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unused/UnusedPropertyUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPropertyGroupVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildPropertyGroupVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RemovePropertiesFromAllLocalesFix
    implements QuickFix<ResourceBundleEditorProblemDescriptor> {
        private final SmartPsiElementPointer<Property> myRepresentativePointer;

        private RemovePropertiesFromAllLocalesFix(Property property) {
            this.myRepresentativePointer = SmartPointerManager.getInstance((Project)property.getProject()).createSmartPsiElementPointer((PsiElement)property);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message((String)"remove.property.intention.text", (Object[])new Object[0]);
            if (string == null) {
                RemovePropertiesFromAllLocalesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ResourceBundleEditorProblemDescriptor descriptor) {
            Property element;
            if (project == null) {
                RemovePropertiesFromAllLocalesFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemovePropertiesFromAllLocalesFix.$$$reportNull$$$0(2);
            }
            if ((element = (Property)this.myRepresentativePointer.getElement()) == null) {
                return;
            }
            String key = element.getKey();
            if (key == null) {
                return;
            }
            PropertiesFile file = PropertiesImplUtil.getPropertiesFile((PsiFile)this.myRepresentativePointer.getContainingFile());
            LOG.assertTrue(file != null);
            List propertiesFiles = file.getResourceBundle().getPropertiesFiles();
            if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)ContainerUtil.map2List((Collection)propertiesFiles, p -> p.getContainingFile()))) {
                return;
            }
            WriteAction.run(() -> propertiesFiles.stream().flatMap(f -> f.findPropertiesByKey(key).stream()).filter(Objects::nonNull).map(IProperty::getPsiElement).forEach(e -> e.delete()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unused/UnusedPropertyUtil$RemovePropertiesFromAllLocalesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unused/UnusedPropertyUtil$RemovePropertiesFromAllLocalesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

