/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.annotation.Nonnull;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractJTableCellWriter;
import org.fest.swing.driver.JTableLocation;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.Pair;
import org.fest.util.Preconditions;

public class JTableCheckBoxEditorCellWriter
extends AbstractJTableCellWriter {
    public JTableCheckBoxEditorCellWriter(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void enterValue(@Nonnull JTable table, int row, int column, @Nonnull String value) {
        boolean realValue = Boolean.parseBoolean(value);
        Pair<Boolean, Point> editingInfo = JTableCheckBoxEditorCellWriter.doStartCellEditing(table, row, column, this.location());
        if ((Boolean)editingInfo.first == realValue) {
            return;
        }
        this.robot.click((Component)table, (Point)Preconditions.checkNotNull(editingInfo.second));
    }

    @Override
    @RunsInEDT
    public void startCellEditing(@Nonnull JTable table, int row, int column) {
        JTableCheckBoxEditorCellWriter.doStartCellEditing(table, row, column, this.location());
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> doStartCellEditing(final @Nonnull JTable table, final int row, final int column, final @Nonnull JTableLocation location) {
        Pair<Boolean, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                JCheckBox editor = AbstractJTableCellWriter.editor(table, row, column, JCheckBox.class);
                AbstractJTableCellWriter.scrollToCell(table, row, column, location);
                return Pair.of(editor.isSelected(), location.pointAt(table, row, column));
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }
}

