/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.toolwindow;

import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.internal.statistic.actions.OpenEventsSchemeFileAction;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J0\u0010\u0010\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012\u0018\u0001`\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogConsole;", "Lcom/intellij/diagnostic/logging/LogConsoleBase;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/diagnostic/logging/LogFilterModel;", "recorderId", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/diagnostic/logging/LogFilterModel;Ljava/lang/String;)V", "getModel", "()Lcom/intellij/diagnostic/logging/LogFilterModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addLogLine", "", "line", "computeLineNumbers", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "schemeFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isActive", "", "StatisticsLogFilter", "intellij.platform.statistics.devkit"})
public final class StatisticsEventLogConsole
extends LogConsoleBase {
    @NotNull
    private final Project project;
    @NotNull
    private final LogFilterModel model;

    private final HashMap<String, Integer> computeLineNumbers(VirtualFile schemeFile) {
        HashMap<String, Integer> groupIdToLine2 = new HashMap<String, Integer>();
        Document document = FileDocumentManager.getInstance().getDocument(schemeFile);
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026chemeFile) ?: return null");
        Document document2 = document;
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(schemeFile);
        if (psiFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026chemeFile) ?: return null");
        PsiFile psiFile2 = psiFile;
        if (Intrinsics.areEqual((Object)psiFile2.getLanguage(), (Object)JsonLanguage.INSTANCE)) {
            psiFile2.accept((PsiElementVisitor)new JsonRecursiveElementVisitor(groupIdToLine2, document2){
                final /* synthetic */ HashMap $groupIdToLine;
                final /* synthetic */ Document $document;

                public void visitProperty(@NotNull JsonProperty property) {
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    if (Intrinsics.areEqual((Object)property.getName(), (Object)"groups") ^ true) {
                        return;
                    }
                    JsonValue jsonValue = property.getValue();
                    if (!(jsonValue instanceof JsonArray)) {
                        jsonValue = null;
                    }
                    JsonArray jsonArray = (JsonArray)jsonValue;
                    if (jsonArray == null) {
                        return;
                    }
                    JsonArray groups = jsonArray;
                    Iterator<E> iterator = groups.getValueList().iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        JsonProperty idProperty;
                        JsonValue groupElement;
                        JsonValue jsonValue2 = groupElement = (JsonValue)iterator.next();
                        if (jsonValue2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
                        }
                        JsonObject groupObject = (JsonObject)jsonValue2;
                        if (groupObject.findProperty("id") == null) {
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)idProperty, (String)"groupObject.findProperty(\"id\") ?: continue");
                        JsonValue jsonValue3 = idProperty.getValue();
                        if (!(jsonValue3 instanceof JsonStringLiteral)) {
                            jsonValue3 = null;
                        }
                        if ((object = (JsonStringLiteral)jsonValue3) == null || (object = object.getValue()) == null) {
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(idProperty.value as? Js\u2026teral)?.value ?: continue");
                        Object id = object;
                        ((Map)this.$groupIdToLine).put(id, this.$document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)idProperty))));
                    }
                }
                {
                    this.$groupIdToLine = $captured_local_variable$0;
                    this.$document = $captured_local_variable$1;
                }
            });
        }
        return groupIdToLine2;
    }

    public boolean isActive() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Statistics Event Log");
        return toolWindow != null ? toolWindow.isVisible() : false;
    }

    public final void addLogLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        super.addMessage(line);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LogFilterModel getModel() {
        return this.model;
    }

    public StatisticsEventLogConsole(@NotNull Project project, @NotNull LogFilterModel model, @NotNull String recorderId) {
        block2: {
            HashMap groupIdToLine2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            super(project, null, "Statistics Event Log", false, model);
            this.project = project;
            this.model = model;
            VirtualFile schemeFile = LocalFileSystem.getInstance().findFileByIoFile(OpenEventsSchemeFileAction.Companion.getEventsSchemeFile(recorderId));
            if (schemeFile == null || (groupIdToLine2 = (HashMap)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<HashMap<String, Integer>, Throwable>(this, schemeFile){
                final /* synthetic */ StatisticsEventLogConsole this$0;
                final /* synthetic */ VirtualFile $schemeFile;

                public final HashMap<String, Integer> compute() {
                    return StatisticsEventLogConsole.access$computeLineNumbers(this.this$0, this.$schemeFile);
                }
                {
                    this.this$0 = statisticsEventLogConsole;
                    this.$schemeFile = virtualFile;
                }
            }))) == null) break block2;
            Map map2 = groupIdToLine2;
            boolean bl = false;
            if (!map2.isEmpty()) {
                ConsoleView consoleView = this.getConsole();
                if (consoleView != null) {
                    consoleView.addMessageFilter((Filter)new StatisticsLogFilter(this.project, schemeFile, groupIdToLine2));
                }
            }
        }
    }

    public static final /* synthetic */ HashMap access$computeLineNumbers(StatisticsEventLogConsole $this, VirtualFile schemeFile) {
        return $this.computeLineNumbers(schemeFile);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\"\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR-\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogConsole$StatisticsLogFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "groupIdToLine", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/HashMap;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getGroupIdToLine", "()Ljava/util/HashMap;", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "intellij.platform.statistics.devkit"})
    public static final class StatisticsLogFilter
    implements Filter {
        private final Pattern pattern;
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final HashMap<String, Integer> groupIdToLine;

        @Nullable
        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            int start = entireLength - line.length();
            Matcher matcher = this.pattern.matcher(line);
            if (!matcher.find()) {
                return null;
            }
            String groupName = "groupId";
            Integer lineNumber = this.groupIdToLine.get(matcher.group(groupName));
            if (lineNumber == null) {
                return null;
            }
            return new Filter.Result(matcher.start(groupName) + start, matcher.end(groupName) + start, (HyperlinkInfo)new OpenFileHyperlinkInfo(this.project, this.file, lineNumber.intValue()));
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final HashMap<String, Integer> getGroupIdToLine() {
            return this.groupIdToLine;
        }

        public StatisticsLogFilter(@NotNull Project project, @NotNull VirtualFile file, @NotNull HashMap<String, Integer> groupIdToLine2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(groupIdToLine2, (String)"groupIdToLine");
            this.project = project;
            this.file = file;
            this.groupIdToLine = groupIdToLine2;
            this.pattern = Pattern.compile("\\[\"(?<groupId>.*)\", v\\d+]");
        }
    }
}

