/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer.colors;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importer.colors.EclipseColorThemeElements;
import org.jetbrains.idea.eclipse.importer.colors.EclipseThemeOptionHandler;
import org.jetbrains.idea.eclipse.importer.colors.EclipseThemeReader;

public class EclipseColorSchemeImporter
implements SchemeImporter<EditorColorsScheme>,
EclipseColorThemeElements {
    private static final String[] ECLIPSE_THEME_EXTENSIONS = new String[]{"xml"};
    private static final TextAttributesKey[] ATTRIBUTES_TO_COPY = new TextAttributesKey[]{HighlighterColors.BAD_CHARACTER, CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES, CodeInsightColors.ERRORS_ATTRIBUTES, CodeInsightColors.WARNINGS_ATTRIBUTES, CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING, CodeInsightColors.DUPLICATE_FROM_SERVER, CodeInsightColors.WEAK_WARNING_ATTRIBUTES, CodeInsightColors.INFORMATION_ATTRIBUTES, CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES, CodeInsightColors.DEPRECATED_ATTRIBUTES, CodeInsightColors.LINE_FULL_COVERAGE, CodeInsightColors.LINE_PARTIAL_COVERAGE, CodeInsightColors.LINE_NONE_COVERAGE, ConsoleViewContentType.NORMAL_OUTPUT_KEY, ConsoleViewContentType.ERROR_OUTPUT_KEY, ConsoleViewContentType.USER_INPUT_KEY, ConsoleViewContentType.SYSTEM_OUTPUT_KEY, ConsoleViewContentType.LOG_ERROR_OUTPUT_KEY, ConsoleViewContentType.LOG_WARNING_OUTPUT_KEY, ConsoleViewContentType.LOG_EXPIRED_ENTRY, ConsoleHighlighter.BLACK, ConsoleHighlighter.RED, ConsoleHighlighter.GREEN, ConsoleHighlighter.YELLOW, ConsoleHighlighter.BLUE, ConsoleHighlighter.MAGENTA, ConsoleHighlighter.CYAN, ConsoleHighlighter.GRAY, ConsoleHighlighter.DARKGRAY, ConsoleHighlighter.RED_BRIGHT, ConsoleHighlighter.GREEN_BRIGHT, ConsoleHighlighter.YELLOW_BRIGHT, ConsoleHighlighter.BLUE_BRIGHT, ConsoleHighlighter.MAGENTA_BRIGHT, ConsoleHighlighter.CYAN_BRIGHT, ConsoleHighlighter.WHITE, DiffColors.DIFF_ABSENT, DiffColors.DIFF_CONFLICT, DiffColors.DIFF_DELETED, DiffColors.DIFF_INSERTED, DiffColors.DIFF_MODIFIED, DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE, EditorColors.REFERENCE_HYPERLINK_COLOR, CodeInsightColors.HYPERLINK_ATTRIBUTES, CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES};
    private static final String @NonNls [] EXTERNAL_ATTRIBUTES = new String[]{"BREAKPOINT_ATTRIBUTES", "EXECUTIONPOINT_ATTRIBUTES", "NOT_TOP_FRAME_ATTRIBUTES", "DEBUGGER_INLINED_VALUES", "DEBUGGER_INLINED_VALUES_MODIFIED", "DEBUGGER_INLINED_VALUES_EXECUTION_LINE"};

    public String @NotNull [] getSourceExtensions() {
        if (ECLIPSE_THEME_EXTENSIONS == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(0);
        }
        return ECLIPSE_THEME_EXTENSIONS;
    }

    @Nullable
    public EditorColorsScheme importScheme(@NotNull Project project, @NotNull VirtualFile selectedFile, @NotNull EditorColorsScheme currentScheme, @NotNull SchemeFactory<EditorColorsScheme> schemeFactory) throws SchemeImportException {
        String themeName;
        if (project == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(1);
        }
        if (selectedFile == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(2);
        }
        if (currentScheme == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(3);
        }
        if (schemeFactory == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(4);
        }
        if ((themeName = EclipseColorSchemeImporter.readSchemeName(selectedFile)) != null) {
            EditorColorsScheme colorsScheme = (EditorColorsScheme)schemeFactory.createNewScheme(themeName);
            EclipseColorSchemeImporter.readFromStream(selectedFile, new EclipseThemeOptionHandler(colorsScheme));
            EclipseColorSchemeImporter.setupMissingColors(colorsScheme);
            return colorsScheme;
        }
        return null;
    }

    private static String readSchemeName(@NotNull VirtualFile selectedFile) throws SchemeImportException {
        if (selectedFile == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(5);
        }
        return EclipseColorSchemeImporter.readFromStream(selectedFile, null);
    }

    private static String readFromStream(@NotNull VirtualFile file, @Nullable EclipseThemeReader.OptionHandler optionHandler) throws SchemeImportException {
        if (file == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(6);
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            EclipseThemeReader themeReader = new EclipseThemeReader(optionHandler);
            themeReader.readSettings(inputStream);
            String string = themeReader.getThemeName();
            return string;
        }
        catch (IOException e) {
            throw new SchemeImportException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void setupMissingColors(@NotNull EditorColorsScheme scheme) {
        Color background;
        if (scheme == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(7);
        }
        String defaultSchemeName = ColorUtil.isDark((Color)(background = scheme.getDefaultBackground())) ? "Darcula" : "Default";
        EditorColorsScheme baseScheme = DefaultColorSchemesManager.getInstance().getScheme(defaultSchemeName);
        assert (baseScheme != null) : "Can not find default scheme '" + defaultSchemeName + "'!";
        for (TextAttributesKey textAttributesKey : ATTRIBUTES_TO_COPY) {
            EclipseColorSchemeImporter.copyAttributes(baseScheme, scheme, textAttributesKey);
        }
        for (String string : EXTERNAL_ATTRIBUTES) {
            TextAttributesKey key = TextAttributesKey.createTextAttributesKey((String)string);
            EclipseColorSchemeImporter.copyAttributes(baseScheme, scheme, key);
        }
        Color color = ColorUtil.mix((Color)background, (Color)scheme.getDefaultForeground(), (double)0.5);
        scheme.setColor(EditorColors.WHITESPACES_COLOR, color);
        scheme.setColor(EditorColors.INDENT_GUIDE_COLOR, color);
        scheme.setColor(EditorColors.SOFT_WRAP_SIGN_COLOR, color);
        TextAttributes matchedBrace = new TextAttributes();
        matchedBrace.setEffectType(EffectType.BOXED);
        matchedBrace.setEffectColor(color);
        scheme.setAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES, matchedBrace);
        TextAttributes unmatchedBrace = matchedBrace.clone();
        unmatchedBrace.setEffectColor(ColorUtil.mix((Color)background, (Color)Color.RED, (double)0.5));
    }

    private static void copyAttributes(@NotNull EditorColorsScheme source, @NotNull EditorColorsScheme target, @NotNull TextAttributesKey key) {
        if (source == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(8);
        }
        if (target == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(9);
        }
        if (key == null) {
            EclipseColorSchemeImporter.$$$reportNull$$$0(10);
        }
        target.setAttributes(key, source.getAttributes(key));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentScheme";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceExtensions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/importer/colors/EclipseColorSchemeImporter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSchemeName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readFromStream";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupMissingColors";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

