/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.Nls;

public class TagButton
extends JBLayeredPane
implements Disposable {
    protected final JButton myButton;
    private final InplaceButton myCloseButton;

    public TagButton(@Nls String text, final Consumer<AnActionEvent> action) {
        this.myButton = new JButton(text){

            @Override
            protected void paintComponent(Graphics g) {
                this.putClientProperty("JButton.borderColor", this.hasFocus() ? null : TagButton.getBackgroundColor());
                super.paintComponent(g);
            }
        };
        this.myButton.putClientProperty("styleTag", true);
        this.myButton.putClientProperty("JButton.backgroundColor", TagButton.getBackgroundColor());
        this.myButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (8 == e.getKeyCode() || 127 == e.getKeyCode()) {
                    TagButton.this.remove(action, AnActionEvent.createFromInputEvent(e, "", null, DataContext.EMPTY_CONTEXT));
                }
            }
        });
        this.add((Component)this.myButton, JLayeredPane.DEFAULT_LAYER);
        this.myCloseButton = new InplaceButton(new IconButton(OptionsBundle.message("tag.button.tooltip", new Object[0]), AllIcons.Actions.Close, AllIcons.Actions.CloseDarkGrey), a -> this.remove(action, null));
        this.myCloseButton.setOpaque(false);
        this.add((Component)this.myCloseButton, JLayeredPane.POPUP_LAYER);
        this.layoutButtons();
    }

    protected void layoutButtons() {
        this.myButton.setMargin((Insets)JBUI.emptyInsets());
        Dimension size = this.myButton.getPreferredSize();
        Dimension iconSize = this.myCloseButton.getPreferredSize();
        int inset = JBUI.scale((int)3);
        Dimension tagSize = new Dimension(size.width + iconSize.width - inset * 2, size.height);
        this.setPreferredSize(tagSize);
        this.myButton.setBounds(new Rectangle(tagSize));
        this.myButton.setMargin((Insets)JBUI.insetsRight((int)iconSize.width));
        Point p = new Point(tagSize.width - iconSize.width - inset * 3, (tagSize.height - iconSize.height) / 2 + JBUI.scale((int)1));
        this.myCloseButton.setBounds(new Rectangle(p, iconSize));
    }

    protected void updateButton(@NlsContexts.Button String text, Icon icon, boolean isEnabled) {
        this.myButton.setText(text);
        this.myButton.setIcon(icon);
        this.myButton.setEnabled(isEnabled);
        this.layoutButtons();
    }

    private void remove(Consumer<AnActionEvent> action, AnActionEvent e) {
        this.setVisible(false);
        action.accept(e);
    }

    private static Color getBackgroundColor() {
        return JBUI.CurrentTheme.ActionButton.hoverBackground();
    }

    public void dispose() {
    }
}

