/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VFileCreateEvent
extends VFileEvent {
    @NotNull
    private final VirtualFile myParent;
    private final boolean myDirectory;
    private final FileAttributes myAttributes;
    private final String mySymlinkTarget;
    private final ChildInfo[] myChildren;
    private final int myChildNameId;
    private VirtualFile myCreatedFile;

    @ApiStatus.Internal
    public VFileCreateEvent(Object requestor, @NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, @Nullable(value="null means should read from the created file") @Nullable(value="null means should read from the created file") FileAttributes attributes, @Nullable String symlinkTarget, boolean isFromRefresh, ChildInfo @Nullable(value="null means children not available (e.g. the created file is not a directory) or unknown") [] children) {
        if (parent == null) {
            VFileCreateEvent.$$$reportNull$$$0(0);
        }
        if (childName == null) {
            VFileCreateEvent.$$$reportNull$$$0(1);
        }
        super(requestor, isFromRefresh);
        this.myParent = parent;
        this.myDirectory = isDirectory;
        this.myAttributes = attributes;
        this.mySymlinkTarget = symlinkTarget;
        this.myChildren = children;
        this.myChildNameId = VirtualFileManager.getInstance().storeName(childName);
    }

    @NotNull
    public String getChildName() {
        String string = VirtualFileManager.getInstance().getVFileName(this.myChildNameId).toString();
        if (string == null) {
            VFileCreateEvent.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    @NotNull
    public VirtualFile getParent() {
        VirtualFile virtualFile2 = this.myParent;
        if (virtualFile2 == null) {
            VFileCreateEvent.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    @Nullable
    public FileAttributes getAttributes() {
        return this.myAttributes;
    }

    @Nullable
    public String getSymlinkTarget() {
        return this.mySymlinkTarget;
    }

    public boolean isEmptyDirectory() {
        return this.isDirectory() && this.myChildren != null && this.myChildren.length == 0;
    }

    @Override
    @NotNull
    protected String computePath() {
        String parentPath = this.myParent.getPath();
        String string = StringUtil.endsWithChar((CharSequence)parentPath, (char)'/') ? parentPath + this.getChildName() : parentPath + "/" + this.getChildName();
        if (string == null) {
            VFileCreateEvent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public VirtualFile getFile() {
        VirtualFile createdFile = this.myCreatedFile;
        if (createdFile == null && this.myParent.isValid()) {
            this.myCreatedFile = createdFile = this.myParent.findChild(this.getChildName());
        }
        return createdFile;
    }

    public ChildInfo @Nullable(value="null means children not available (e.g. the created file is not a directory) or unknown") [] getChildren() {
        return this.myChildren;
    }

    public void resetCache() {
        this.myCreatedFile = null;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myParent.getFileSystem();
        if (virtualFileSystem == null) {
            VFileCreateEvent.$$$reportNull$$$0(5);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myParent.isValid() && this.myParent.findChild(this.getChildName()) == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        return this.myDirectory == event.myDirectory && this.getChildName().equals(event.getChildName()) && this.myParent.equals(event.myParent);
    }

    @Override
    public int hashCode() {
        int result = this.myParent.hashCode();
        result = 31 * result + (this.myDirectory ? 1 : 0);
        result = 31 * result + this.getChildName().hashCode();
        return result;
    }

    public String toString() {
        String kind = this.myDirectory ? (this.isEmptyDirectory() ? "(empty) " : "") + "dir " : "file ";
        return "VfsEvent[create " + kind + "'" + this.myParent.getUrl() + "/" + this.getChildName() + "']" + (this.myChildren == null ? "" : " with " + this.myChildren.length + " children");
    }

    public int getChildNameId() {
        return this.myChildNameId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/events/VFileCreateEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

