/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.VcsIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class IgnoredFilesCompositeHolder
implements FileHolder {
    private final Map<AbstractVcs, IgnoredFilesHolder> myVcsIgnoredHolderMap;
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;

    public IgnoredFilesCompositeHolder(Project project) {
        this.myProject = project;
        this.myVcsIgnoredHolderMap = new HashMap<AbstractVcs, IgnoredFilesHolder>();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Override
    public void cleanAll() {
        this.myVcsIgnoredHolderMap.values().forEach(FileHolder::cleanAll);
        this.myVcsIgnoredHolderMap.clear();
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope2) {
        AbstractVcs vcs;
        if (scope2 == null) {
            IgnoredFilesCompositeHolder.$$$reportNull$$$0(0);
        }
        if (this.myVcsIgnoredHolderMap.containsKey(vcs = scope2.getVcs())) {
            this.myVcsIgnoredHolderMap.get(vcs).cleanAndAdjustScope(scope2);
        }
    }

    @Override
    public IgnoredFilesCompositeHolder copy() {
        IgnoredFilesCompositeHolder result2 = new IgnoredFilesCompositeHolder(this.myProject);
        for (Map.Entry<AbstractVcs, IgnoredFilesHolder> entry : this.myVcsIgnoredHolderMap.entrySet()) {
            result2.myVcsIgnoredHolderMap.put(entry.getKey(), (IgnoredFilesHolder)entry.getValue().copy());
        }
        return result2;
    }

    public void addFile(@NotNull AbstractVcs vcs, @NotNull FilePath file) {
        if (vcs == null) {
            IgnoredFilesCompositeHolder.$$$reportNull$$$0(1);
        }
        if (file == null) {
            IgnoredFilesCompositeHolder.$$$reportNull$$$0(2);
        }
        this.myVcsIgnoredHolderMap.get(vcs).addFile(file);
    }

    public boolean isInUpdatingMode() {
        return this.myVcsIgnoredHolderMap.values().stream().anyMatch(holder -> holder instanceof VcsIgnoredFilesHolder && ((VcsIgnoredFilesHolder)holder).isInUpdatingMode());
    }

    public boolean containsFile(@NotNull FilePath file) {
        AbstractVcs vcs;
        if (file == null) {
            IgnoredFilesCompositeHolder.$$$reportNull$$$0(3);
        }
        if ((vcs = this.myVcsManager.getVcsFor(file)) == null) {
            return false;
        }
        IgnoredFilesHolder ignoredFilesHolder = this.myVcsIgnoredHolderMap.get(vcs);
        return ignoredFilesHolder != null && ignoredFilesHolder.containsFile(file);
    }

    @NotNull
    public Collection<FilePath> values() {
        HashSet<FilePath> result2 = new HashSet<FilePath>();
        result2.addAll(StreamEx.of(this.myVcsIgnoredHolderMap.values()).flatCollection(IgnoredFilesHolder::values).toSet());
        HashSet<FilePath> hashSet = result2;
        if (hashSet == null) {
            IgnoredFilesCompositeHolder.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Override
    public void notifyVcsStarted(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            IgnoredFilesCompositeHolder.$$$reportNull$$$0(5);
        }
        if (!this.myVcsIgnoredHolderMap.containsKey(vcs)) {
            this.myVcsIgnoredHolderMap.put(vcs, IgnoredFilesCompositeHolder.getHolderForVcs(this.myProject, vcs));
        }
        for (FileHolder fileHolder : this.myVcsIgnoredHolderMap.values()) {
            fileHolder.notifyVcsStarted(vcs);
        }
    }

    @NotNull
    private static IgnoredFilesHolder getHolderForVcs(@NotNull Project project, AbstractVcs vcs) {
        if (project == null) {
            IgnoredFilesCompositeHolder.$$$reportNull$$$0(6);
        }
        for (VcsIgnoredFilesHolder.Provider provider : VcsIgnoredFilesHolder.VCS_IGNORED_FILES_HOLDER_EP.getExtensions((AreaInstance)project)) {
            if (!provider.getVcs().equals((Object)vcs)) continue;
            VcsIgnoredFilesHolder vcsIgnoredFilesHolder = provider.createHolder();
            if (vcsIgnoredFilesHolder == null) {
                IgnoredFilesCompositeHolder.$$$reportNull$$$0(7);
            }
            return vcsIgnoredFilesHolder;
        }
        return new RecursiveFileHolder(project);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IgnoredFilesCompositeHolder)) {
            return false;
        }
        IgnoredFilesCompositeHolder other = (IgnoredFilesCompositeHolder)obj;
        return this.myVcsIgnoredHolderMap.equals(other.myVcsIgnoredHolderMap);
    }

    public int hashCode() {
        return Objects.hash(this.myVcsIgnoredHolderMap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/IgnoredFilesCompositeHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/IgnoredFilesCompositeHolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolderForVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndAdjustScope";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyVcsStarted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHolderForVcs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

