/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchDefaultExecutor
implements ApplyPatchExecutor<AbstractFilePatchInProgress<?>> {
    protected final Project myProject;

    public ApplyPatchDefaultExecutor(Project project) {
        this.myProject = project;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    @RequiresEdt
    public void apply(@NotNull List<? extends FilePatch> remaining, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress<?>> patchGroupsToApply, final @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        if (remaining == null) {
            ApplyPatchDefaultExecutor.$$$reportNull$$$0(0);
        }
        if (patchGroupsToApply == null) {
            ApplyPatchDefaultExecutor.$$$reportNull$$$0(1);
        }
        CommitContext commitContext = new CommitContext();
        if (additionalInfo != null) {
            ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(this.myProject, additionalInfo, commitContext);
        }
        final Collection<PatchApplier> appliers = this.getPatchAppliers(patchGroupsToApply, localList, commitContext);
        new Task.Backgroundable(this.myProject, VcsBundle.message((String)"patch.apply.progress.title", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                PatchApplier.executePatchGroup(appliers, localList);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor$1", "run"));
            }
        }.queue();
    }

    @NotNull
    protected Collection<PatchApplier> getPatchAppliers(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress<?>> patchGroups, @Nullable LocalChangeList localList, @NotNull CommitContext commitContext) {
        if (patchGroups == null) {
            ApplyPatchDefaultExecutor.$$$reportNull$$$0(2);
        }
        if (commitContext == null) {
            ApplyPatchDefaultExecutor.$$$reportNull$$$0(3);
        }
        ArrayList<PatchApplier> appliers = new ArrayList<PatchApplier>();
        for (VirtualFile base : patchGroups.keySet()) {
            appliers.add(new PatchApplier(this.myProject, base, ContainerUtil.map((Collection)patchGroups.get((Object)base), patchInProgress -> patchInProgress.getPatch()), localList, commitContext));
        }
        ArrayList<PatchApplier> arrayList = appliers;
        if (arrayList == null) {
            ApplyPatchDefaultExecutor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static void applyAdditionalInfoBefore(@NotNull Project project, @NotNull ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo, @Nullable CommitContext commitContext) {
        List extensions;
        if (project == null) {
            ApplyPatchDefaultExecutor.$$$reportNull$$$0(5);
        }
        if (additionalInfo == null) {
            ApplyPatchDefaultExecutor.$$$reportNull$$$0(6);
        }
        if ((extensions = PatchEP.EP_NAME.getExtensionList()).isEmpty()) {
            return;
        }
        try {
            Map additionalInfoMap = (Map)additionalInfo.compute();
            for (Map.Entry entry : additionalInfoMap.entrySet()) {
                for (PatchEP extension : extensions) {
                    CharSequence charSequence = (CharSequence)((Map)entry.getValue()).get(extension.getName());
                    if (charSequence == null) continue;
                    extension.consumeContentBeforePatchApplied(project, (String)entry.getKey(), charSequence, commitContext);
                }
            }
        }
        catch (PatchSyntaxException e) {
            VcsBalloonProblemNotifier.showOverChangesView(project, VcsBundle.message((String)"patch.apply.can.not.apply.additional.info.error", (Object[])new Object[]{e.getMessage()}), MessageType.ERROR, new NamedRunnable[0]);
        }
    }

    public static Set<String> pathsFromGroups(@NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress<?>> patchGroups) {
        if (patchGroups == null) {
            ApplyPatchDefaultExecutor.$$$reportNull$$$0(7);
        }
        HashSet<String> selectedPaths = new HashSet<String>();
        Collection values = patchGroups.values();
        for (AbstractFilePatchInProgress value : values) {
            String path2 = value.getPatch().getBeforeName() == null ? value.getPatch().getAfterName() : value.getPatch().getBeforeName();
            selectedPaths.add(path2);
        }
        return selectedPaths;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remaining";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchGroupsToApply";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchGroups";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDefaultExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchAppliers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPatchAppliers";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyAdditionalInfoBefore";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pathsFromGroups";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

