/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogEditorUtilKt;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogTabsWatcher
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogTabsWatcher.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostponableLogRefresher myRefresher;
    @NotNull
    private final Disposable myListenersDisposable;

    public VcsLogTabsWatcher(@NotNull Project project, @NotNull PostponableLogRefresher refresher) {
        if (project == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(0);
        }
        if (refresher == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(1);
        }
        this.myListenersDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.myRefresher = refresher;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new MyToolWindowManagerListener());
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileManagerListener());
        this.installContentListeners();
    }

    @NotNull
    public Disposable addTabToWatch(@NotNull String logId, @NotNull VisiblePackRefresher refresher, @NotNull VcsLogManager.LogWindowKind kind, boolean isClosedOnDispose) {
        PostponableLogRefresher.VcsLogWindow window;
        if (logId == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(3);
        }
        if (kind == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(4);
        }
        switch (kind) {
            case TOOL_WINDOW: {
                window = new VcsLogToolWindowTab(logId, refresher, isClosedOnDispose);
                break;
            }
            case EDITOR: {
                window = new VcsLogEditorTab(logId, refresher, isClosedOnDispose);
                break;
            }
            default: {
                window = new PostponableLogRefresher.VcsLogWindow(logId, refresher);
            }
        }
        Disposable disposable = this.myRefresher.addLogWindow(window);
        if (disposable == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(5);
        }
        return disposable;
    }

    private void installContentListeners() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ToolWindow toolWindow = this.getToolWindow();
        if (toolWindow != null) {
            VcsLogTabsWatcher.addContentManagerListener(toolWindow, new MyRefreshPostponedEventsListener(toolWindow), this.myListenersDisposable);
        }
    }

    private void removeContentListeners() {
        Disposer.dispose((Disposable)this.myListenersDisposable);
    }

    private void selectionChanged(@NotNull String tabId) {
        PostponableLogRefresher.VcsLogWindow logWindow;
        if (tabId == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(6);
        }
        if ((logWindow = (PostponableLogRefresher.VcsLogWindow)ContainerUtil.find(this.myRefresher.getLogWindows(), window -> window.getId().equals(tabId))) != null) {
            LOG.debug("Selected log window '" + logWindow + "'");
            VcsLogUsageTriggerCollector.triggerUsage(VcsLogUsageTriggerCollector.VcsLogEvent.TAB_NAVIGATED, null);
            this.myRefresher.refresherActivated(logWindow.getRefresher(), false);
        }
    }

    private void closeLogTabs() {
        ToolWindow window = this.getToolWindow();
        if (window != null) {
            List<String> toolWindowTabs = this.getToolWindowTabsToClose();
            for (String tabId : toolWindowTabs) {
                boolean closed = VcsLogContentUtil.closeLogTab(window.getContentManager(), tabId);
                LOG.assertTrue(closed, (Object)("Could not find content component for tab " + tabId + "\nExisting content: " + Arrays.toString(window.getContentManager().getContents()) + "\nTabs to close: " + toolWindowTabs));
            }
        }
        List<String> editorTabs = this.getEditorTabsToClose();
        boolean closed = VcsLogEditorUtilKt.closeLogTabs(this.myProject, editorTabs);
        LOG.assertTrue(closed, (Object)("Could not close tabs: " + editorTabs));
    }

    @NotNull
    private List<String> getToolWindowTabsToClose() {
        List list = ((StreamEx)StreamEx.of(this.myRefresher.getLogWindows()).select(VcsLogToolWindowTab.class).filter(VcsLogToolWindowTab::isClosedOnDispose)).map(PostponableLogRefresher.VcsLogWindow::getId).toList();
        if (list == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private List<String> getEditorTabsToClose() {
        List list = ((StreamEx)StreamEx.of(this.myRefresher.getLogWindows()).select(VcsLogEditorTab.class).filter(VcsLogEditorTab::isClosedOnDispose)).map(PostponableLogRefresher.VcsLogWindow::getId).toList();
        if (list == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private ToolWindow getToolWindow() {
        return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Version Control");
    }

    public void dispose() {
        this.closeLogTabs();
        this.removeContentListeners();
    }

    @Nullable
    private static String getSelectedToolWindowTabId(@Nullable ToolWindow toolWindow) {
        if (toolWindow == null || !toolWindow.isVisible()) {
            return null;
        }
        Content content2 = toolWindow.getContentManager().getSelectedContent();
        if (content2 != null) {
            return VcsLogContentUtil.getId(content2);
        }
        return null;
    }

    @NotNull
    private static Set<String> getSelectedEditorTabIds(@NotNull Project project) {
        if (project == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(9);
        }
        Set<String> set = VcsLogEditorUtilKt.findSelectedLogIds(project);
        if (set == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static void addContentManagerListener(@NotNull ToolWindow window, @NotNull ContentManagerListener listener2, @NotNull Disposable disposable) {
        if (window == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(11);
        }
        if (listener2 == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(12);
        }
        if (disposable == null) {
            VcsLogTabsWatcher.$$$reportNull$$$0(13);
        }
        window.addContentManagerListener(listener2);
        Disposer.register((Disposable)disposable, () -> {
            ContentManager contentManager;
            if (!window.isDisposed() && (contentManager = window.getContentManagerIfCreated()) != null) {
                contentManager.removeContentManagerListener(listener2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addTabToWatch";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowTabsToClose";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTabsToClose";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditorTabIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTabToWatch";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditorTabIds";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addContentManagerListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class VcsLogTabsListener
    implements ToolWindowManagerListener,
    PropertyChangeListener,
    ContentManagerListener {
        @NotNull
        private final ToolWindow myToolWindow;

        private VcsLogTabsListener(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Disposable disposable) {
            if (project == null) {
                VcsLogTabsListener.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                VcsLogTabsListener.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                VcsLogTabsListener.$$$reportNull$$$0(2);
            }
            this.myToolWindow = toolWindow;
            project.getMessageBus().connect(disposable).subscribe(ToolWindowManagerListener.TOPIC, (Object)this);
            Disposer.register((Disposable)disposable, () -> {
                for (Content content2 : this.myToolWindow.getContentManager().getContents()) {
                    if (!(content2 instanceof TabbedContent)) continue;
                    content2.removePropertyChangeListener((PropertyChangeListener)this);
                }
            });
        }

        protected abstract void selectionChanged(@NotNull String var1);

        private void selectionChanged() {
            String tabId = VcsLogTabsWatcher.getSelectedToolWindowTabId(this.myToolWindow);
            if (tabId != null) {
                this.selectionChanged(tabId);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            String tabId;
            if (event == null) {
                VcsLogTabsListener.$$$reportNull$$$0(3);
            }
            if (ContentManagerEvent.ContentOperation.add.equals((Object)event.getOperation()) && (tabId = VcsLogContentUtil.getId(event.getContent())) != null) {
                this.selectionChanged(tabId);
            }
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            Content content2;
            if (event == null) {
                VcsLogTabsListener.$$$reportNull$$$0(4);
            }
            if ((content2 = event.getContent()) instanceof TabbedContent) {
                content2.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Content content2;
            if (event == null) {
                VcsLogTabsListener.$$$reportNull$$$0(5);
            }
            if ((content2 = event.getContent()) instanceof TabbedContent) {
                content2.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void toolWindowShown(@NotNull ToolWindow toolWindow) {
            if (toolWindow == null) {
                VcsLogTabsListener.$$$reportNull$$$0(6);
            }
            if (this.myToolWindow == toolWindow) {
                this.selectionChanged();
            }
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            if (evt == null) {
                VcsLogTabsListener.$$$reportNull$$$0(7);
            }
            if (evt.getPropertyName().equals("component")) {
                this.selectionChanged();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evt";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogTabsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentAdded";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toolWindowShown";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyRefreshPostponedEventsListener
    extends VcsLogTabsListener {
        private MyRefreshPostponedEventsListener(ToolWindow toolWindow) {
            if (toolWindow == null) {
                MyRefreshPostponedEventsListener.$$$reportNull$$$0(0);
            }
            super(VcsLogTabsWatcher.this.myProject, toolWindow, VcsLogTabsWatcher.this.myListenersDisposable);
        }

        @Override
        protected void selectionChanged(@NotNull String tabId) {
            if (tabId == null) {
                MyRefreshPostponedEventsListener.$$$reportNull$$$0(1);
            }
            VcsLogTabsWatcher.this.selectionChanged(tabId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$MyRefreshPostponedEventsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFileManagerListener
    implements FileEditorManagerListener {
        private MyFileManagerListener() {
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent e) {
            FileEditor editor;
            if (e == null) {
                MyFileManagerListener.$$$reportNull$$$0(0);
            }
            if ((editor = e.getNewEditor()) != null) {
                for (String tabId : VcsLogEditorUtilKt.getLogIds(editor)) {
                    VcsLogTabsWatcher.this.selectionChanged(tabId);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/impl/VcsLogTabsWatcher$MyFileManagerListener", "selectionChanged"));
        }
    }

    private final class MyToolWindowManagerListener
    implements ToolWindowManagerListener {
        private MyToolWindowManagerListener() {
        }

        public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
            if (ids == null) {
                MyToolWindowManagerListener.$$$reportNull$$$0(0);
            }
            if (toolWindowManager == null) {
                MyToolWindowManagerListener.$$$reportNull$$$0(1);
            }
            if (ids.contains("Version Control")) {
                VcsLogTabsWatcher.this.installContentListeners();
            }
        }

        public void toolWindowUnregistered(@NotNull String id, @NotNull ToolWindow toolWindow) {
            if (id == null) {
                MyToolWindowManagerListener.$$$reportNull$$$0(2);
            }
            if (toolWindow == null) {
                MyToolWindowManagerListener.$$$reportNull$$$0(3);
            }
            if (id.equals("Version Control")) {
                VcsLogTabsWatcher.this.removeContentListeners();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ids";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindowManager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$MyToolWindowManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toolWindowsRegistered";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toolWindowUnregistered";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class VcsLogEditorTab
    extends PostponableLogRefresher.VcsLogWindow {
        private final boolean myIsClosedOnDispose;

        private VcsLogEditorTab(@NotNull String id, VisiblePackRefresher refresher, boolean isClosedOnDispose) {
            if (id == null) {
                VcsLogEditorTab.$$$reportNull$$$0(0);
            }
            if (refresher == null) {
                VcsLogEditorTab.$$$reportNull$$$0(1);
            }
            super(id, refresher);
            this.myIsClosedOnDispose = isClosedOnDispose;
        }

        @Override
        public boolean isVisible() {
            return VcsLogTabsWatcher.getSelectedEditorTabIds(VcsLogTabsWatcher.this.myProject).contains(this.getId());
        }

        public boolean isClosedOnDispose() {
            return this.myIsClosedOnDispose;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refresher";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogEditorTab";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class VcsLogToolWindowTab
    extends PostponableLogRefresher.VcsLogWindow {
        private final boolean myIsClosedOnDispose;

        private VcsLogToolWindowTab(@NotNull String id, VisiblePackRefresher refresher, boolean isClosedOnDispose) {
            if (id == null) {
                VcsLogToolWindowTab.$$$reportNull$$$0(0);
            }
            if (refresher == null) {
                VcsLogToolWindowTab.$$$reportNull$$$0(1);
            }
            super(id, refresher);
            this.myIsClosedOnDispose = isClosedOnDispose;
        }

        @Override
        public boolean isVisible() {
            String selectedTab = VcsLogTabsWatcher.getSelectedToolWindowTabId(VcsLogTabsWatcher.this.getToolWindow());
            return this.getId().equals(selectedTab);
        }

        public boolean isClosedOnDispose() {
            return this.myIsClosedOnDispose;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refresher";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogToolWindowTab";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

