/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpoint$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinPropertyBreakpointProperties;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 C2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002BCB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J:\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\n\b\u0000\u0010\u001d\u0018\u0001*\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u0006\u0010!\u001a\u00020\"H\u0082\b\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0014J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010/\u001a\u0004\u0018\u00010\fH\u0002J\b\u00100\u001a\u00020+H\u0002J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020+02H\u0002J\u0014\u00103\u001a\u0004\u0018\u00010\f2\b\u00104\u001a\u0004\u0018\u000105H\u0002J\u0010\u00106\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0014J\u0010\u00107\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0014J\u0010\u00108\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0014J\b\u00109\u001a\u00020\u0017H\u0016J\u000e\u0010:\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010;\u001a\u00020\u000eH\u0016J\u000e\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020+J\u000e\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u0017J\u000e\u0010@\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u0017J\u000e\u0010A\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/BreakpointWithHighlighter;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinPropertyBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "breakpointType", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpoint$BreakpointType;", "computeBreakpointType", "property", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "createMethodBreakpoint", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "refType", "Lcom/sun/jdi/ReferenceType;", "accessor", "Lcom/sun/jdi/Method;", "createRequestForPreparedClass", "evaluateCondition", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "findRequest", "T", "Lcom/sun/jdi/request/EventRequest;", "requestClass", "Ljava/lang/Class;", "requestor", "Lcom/intellij/debugger/requests/Requestor;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Ljava/lang/Class;Lcom/intellij/debugger/requests/Requestor;)Lcom/sun/jdi/request/EventRequest;", "getCategory", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/ui/breakpoints/FieldBreakpoint;", "getDisabledIcon", "Ljavax/swing/Icon;", "isMuted", "getDisplayName", "", "getEvaluationElement", "Lcom/intellij/psi/PsiElement;", "getEventMessage", "getField", "getFieldName", "getMethodsName", "", "getProperty", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getSetIcon", "getVerifiedIcon", "getVerifiedWarningsIcon", "isValid", "matchesEvent", "reload", "setFieldName", "fieldName", "setWatchAccess", "value", "setWatchInitialization", "setWatchModification", "BreakpointType", "Companion", "kotlin.jvm-debugger.core"})
public final class KotlinFieldBreakpoint
extends BreakpointWithHighlighter<KotlinPropertyBreakpointProperties> {
    private BreakpointType breakpointType;
    private static final Logger LOG;
    private static final Key<FieldBreakpoint> CATEGORY;
    public static final Companion Companion;

    public boolean isValid() {
        XBreakpoint xBreakpoint = this.getXBreakpoint();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpoint, (String)"xBreakpoint");
        if (!KotlinFieldBreakpoint.access$isPositionValid$s714927978(xBreakpoint.getSourcePosition())) {
            return false;
        }
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinFieldBreakpoint this$0;

            public final boolean invoke() {
                KtCallableDeclaration field = KotlinFieldBreakpoint.access$getField(this.this$0);
                return field != null && field.isValid();
            }
            {
                this.this$0 = kotlinFieldBreakpoint;
                super(0);
            }
        }));
    }

    private final KtCallableDeclaration getField() {
        SourcePosition sourcePosition2 = this.getSourcePosition();
        return this.getProperty(sourcePosition2);
    }

    private final KtCallableDeclaration getProperty(SourcePosition sourcePosition2) {
        KtProperty property = (KtProperty)PositionUtil.getPsiElementAt((Project)this.getProject(), KtProperty.class, (SourcePosition)sourcePosition2);
        if (property != null) {
            return (KtCallableDeclaration)property;
        }
        KtParameter parameter = (KtParameter)PositionUtil.getPsiElementAt((Project)this.getProject(), KtParameter.class, (SourcePosition)sourcePosition2);
        if (parameter != null) {
            return (KtCallableDeclaration)parameter;
        }
        return null;
    }

    public void reload() {
        super.reload();
        KtCallableDeclaration ktCallableDeclaration = this.getProperty(this.getSourcePosition());
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration property = ktCallableDeclaration;
        String string = property.getName();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.name ?: return");
        String propertyName = string;
        this.setFieldName(propertyName);
        if (property instanceof KtProperty && ((KtProperty)property).isTopLevel()) {
            KotlinPropertyBreakpointProperties kotlinPropertyBreakpointProperties = (KotlinPropertyBreakpointProperties)this.getProperties();
            KtFile ktFile = property.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"property.getContainingKtFile()");
            String string2 = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)ktFile).getFileClassFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JvmFileClassUtil.getFile\u2026ileClassFqName.asString()");
            kotlinPropertyBreakpointProperties.setMyClassName(string2);
        } else {
            FqName fqName;
            KtClassOrObject ktClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)property), KtClassOrObject.class);
            if (ktClass instanceof KtClassOrObject && (fqName = ktClass.getFqName()) != null) {
                KotlinPropertyBreakpointProperties kotlinPropertyBreakpointProperties = (KotlinPropertyBreakpointProperties)this.getProperties();
                String string3 = fqName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fqName.asString()");
                kotlinPropertyBreakpointProperties.setMyClassName(string3);
            }
        }
        this.setInstanceFiltersEnabled(false);
    }

    /*
     * Unable to fully structure code
     */
    protected void createRequestForPreparedClass(@Nullable DebugProcessImpl debugProcess, @Nullable ReferenceType refType) {
        if (debugProcess == null || refType == null) {
            return;
        }
        v0 = this.getProperty(this.getSourcePosition());
        if (v0 == null) {
            return;
        }
        property = v0;
        v1 = this.computeBreakpointType(property);
        if (v1 == null) {
            return;
        }
        this.breakpointType = v1;
        v2 = debugProcess.getVirtualMachineProxy();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"debugProcess.virtualMachineProxy");
        vm = v2;
        try {
            block23: {
                if (!((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchInitialization() || (sourcePosition = this.getSourcePosition()) == null) break block23;
                v3 = debugProcess.getPositionManager().locationsOfLine(refType, sourcePosition);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"debugProcess.positionMan\u2026(refType, sourcePosition)");
                $this$filter$iv = v3;
                $i$f$filter = false;
                var8_11 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Location)element$iv$iv;
                    $i$a$-filter-KotlinFieldBreakpoint$createRequestForPreparedClass$1 = false;
                    v4 = it.method();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it.method()");
                    if (v4.isConstructor()) ** GOTO lbl-1000
                    v5 = it.method();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it.method()");
                    if (v5.isStaticInitializer()) lbl-1000:
                    // 2 sources

                    {
                        v6 = true;
                    } else {
                        v6 = false;
                    }
                    if (!v6) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    it = (Location)element$iv;
                    $i$a$-forEach-KotlinFieldBreakpoint$createRequestForPreparedClass$2 = false;
                    request = debugProcess.getRequestsManager().createBreakpointRequest((FilteredRequestor)this, it);
                    debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                    if (!KotlinFieldBreakpoint.LOG.isDebugEnabled()) continue;
                    KotlinFieldBreakpoint.LOG.debug("Breakpoint request added");
                }
            }
            switch (KotlinFieldBreakpoint$WhenMappings.$EnumSwitchMapping$0[this.breakpointType.ordinal()]) {
                case 1: {
                    field = refType.fieldByName(this.getFieldName());
                    if (field != null) {
                        manager = debugProcess.getRequestsManager();
                        if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchModification() && vm.canWatchFieldModification()) {
                            request = manager.createModificationWatchpointRequest((FilteredRequestor)this, field);
                            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                            if (KotlinFieldBreakpoint.LOG.isDebugEnabled()) {
                                KotlinFieldBreakpoint.LOG.debug("Modification request added");
                            }
                        }
                        if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchAccess() && vm.canWatchFieldAccess()) {
                            request = manager.createAccessWatchpointRequest((FilteredRequestor)this, field);
                            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                            if (KotlinFieldBreakpoint.LOG.isDebugEnabled()) {
                                KotlinFieldBreakpoint.LOG.debug("Field access request added (field = " + field.name() + "; refType = " + refType.name() + ')');
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    fieldName = this.getFieldName();
                    if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchAccess()) {
                        v7 = refType.methodsByName(JvmAbi.getterName((String)fieldName));
                        Intrinsics.checkNotNullExpressionValue(v7, (String)"refType.methodsByName(Jv\u2026bi.getterName(fieldName))");
                        getter = (Method)CollectionsKt.firstOrNull(v7);
                        if (getter != null) {
                            this.createMethodBreakpoint(debugProcess, refType, getter);
                        }
                    }
                    if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWatchModification()) {
                        v8 = refType.methodsByName(JvmAbi.setterName((String)fieldName));
                        Intrinsics.checkNotNullExpressionValue(v8, (String)"refType.methodsByName(Jv\u2026bi.setterName(fieldName))");
                        setter = (Method)CollectionsKt.firstOrNull(v8);
                        if (setter != null) {
                            this.createMethodBreakpoint(debugProcess, refType, setter);
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            KotlinFieldBreakpoint.LOG.debug((Throwable)ex);
        }
    }

    private final BreakpointType computeBreakpointType(KtCallableDeclaration property) {
        return (BreakpointType)((Object)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<BreakpointType>(property){
            final /* synthetic */ KtCallableDeclaration $property;

            @Nullable
            public final BreakpointType invoke() {
                BreakpointType breakpointType;
                BindingContext bindingContext = ResolutionUtils.analyze$default((KtElement)((KtElement)this.$property), null, (int)1, null);
                DeclarationDescriptor descriptor = (DeclarationDescriptor)bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)this.$property);
                if (descriptor instanceof ValueParameterDescriptor) {
                    descriptor = (DeclarationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.VALUE_PARAMETER_AS_PROPERTY, (Object)descriptor);
                }
                if (descriptor instanceof PropertyDescriptor) {
                    Object object = bindingContext.get((ReadOnlySlice)BindingContext.BACKING_FIELD_REQUIRED, (Object)descriptor);
                    Intrinsics.checkNotNull((Object)object);
                    breakpointType = ((Boolean)object).booleanValue() ? BreakpointType.FIELD : BreakpointType.METHOD;
                } else {
                    breakpointType = null;
                }
                return breakpointType;
            }
            {
                this.$property = ktCallableDeclaration;
                super(0);
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private final void createMethodBreakpoint(DebugProcessImpl debugProcess, ReferenceType refType, Method accessor) {
        RequestManagerImpl manager = debugProcess.getRequestsManager();
        Location line = (Location)CollectionsKt.firstOrNull((List)SafeUtilKt.safeAllLineLocations((Method)accessor));
        if (line != null) {
            BreakpointRequest request = manager.createBreakpointRequest((FilteredRequestor)this, line);
            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Breakpoint request added");
            }
        } else {
            EventRequest eventRequest;
            block8: {
                KotlinFieldBreakpoint kotlinFieldBreakpoint = this;
                Class<MethodEntryRequest> clazz = MethodEntryRequest.class;
                Requestor requestor$iv = (Requestor)this;
                boolean $i$f$findRequest = false;
                Set requests$iv = debugProcess.getRequestsManager().findRequests(requestor$iv);
                for (EventRequest eventRequest$iv : requests$iv) {
                    void requestClass$iv;
                    if (!Intrinsics.areEqual(eventRequest$iv.getClass(), (Object)requestClass$iv)) continue;
                    EventRequest eventRequest2 = eventRequest$iv;
                    if (eventRequest2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.request.MethodEntryRequest");
                    }
                    eventRequest = (MethodEntryRequest)eventRequest2;
                    break block8;
                }
                eventRequest = null;
            }
            MethodEntryRequest entryRequest = (MethodEntryRequest)eventRequest;
            if (entryRequest == null) {
                MethodEntryRequest methodEntryRequest = manager.createMethodEntryRequest((FilteredRequestor)this);
                Intrinsics.checkNotNull((Object)methodEntryRequest);
                entryRequest = methodEntryRequest;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Method entry request added (method = " + accessor.name() + "; refType = " + refType.name() + ')');
                }
            } else {
                entryRequest.disable();
            }
            entryRequest.addClassFilter(refType);
            manager.enableRequest((EventRequest)entryRequest);
        }
    }

    private final /* synthetic */ <T extends EventRequest> T findRequest(DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor) {
        int $i$f$findRequest = 0;
        Set requests = debugProcess.getRequestsManager().findRequests(requestor);
        for (EventRequest eventRequest : requests) {
            if (!Intrinsics.areEqual(eventRequest.getClass(), requestClass)) continue;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)eventRequest;
        }
        return null;
    }

    public boolean evaluateCondition(@NotNull EvaluationContextImpl context, @NotNull LocatableEvent event) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.breakpointType == BreakpointType.METHOD && !this.matchesEvent(event)) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public final boolean matchesEvent(@NotNull LocatableEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Location location = event.location();
        Method method = location != null ? location.method() : null;
        return method != null && this.getMethodsName().contains(method.name());
    }

    private final List<String> getMethodsName() {
        String fieldName = this.getFieldName();
        Object[] objectArray = new String[2];
        String string = JvmAbi.getterName((String)fieldName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JvmAbi.getterName(fieldName)");
        objectArray[0] = string;
        String string2 = JvmAbi.setterName((String)fieldName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JvmAbi.setterName(fieldName)");
        objectArray[1] = string2;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getEventMessage(@NotNull LocatableEvent event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Location location = event.location();
        Intrinsics.checkNotNull((Object)location);
        Location location2 = location;
        String locationQName = location2.declaringType().name() + "." + location2.method().name();
        try {
            string = location2.sourceName();
        }
        catch (AbsentInformationException e) {
            string = this.getFileName();
        }
        catch (InternalError e) {
            string = this.getFileName();
        }
        String locationFileName = string;
        int locationLine = location2.lineNumber();
        LocatableEvent locatableEvent = event;
        if (locatableEvent instanceof ModificationWatchpointEvent) {
            Field field = ((ModificationWatchpointEvent)event).field();
            String string2 = JavaDebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), locationQName, locationFileName, locationLine});
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JavaDebuggerBundle.messa\u2026ionLine\n                )");
            return string2;
        }
        if (locatableEvent instanceof AccessWatchpointEvent) {
            Field field = ((AccessWatchpointEvent)event).field();
            String string3 = JavaDebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), locationQName, locationFileName, locationLine});
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"JavaDebuggerBundle.messa\u2026ionLine\n                )");
            return string3;
        }
        if (locatableEvent instanceof MethodEntryEvent) {
            Method method = ((MethodEntryEvent)event).method();
            String string4 = JavaDebuggerBundle.message((String)"status.method.entry.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"JavaDebuggerBundle.messa\u2026ionLine\n                )");
            return string4;
        }
        if (locatableEvent instanceof MethodExitEvent) {
            Method method = ((MethodExitEvent)event).method();
            String string5 = JavaDebuggerBundle.message((String)"status.method.exit.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"JavaDebuggerBundle.messa\u2026ionLine\n                )");
            return string5;
        }
        String string6 = JavaDebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{locationQName, locationFileName, locationLine});
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"JavaDebuggerBundle.messa\u2026   locationLine\n        )");
        return string6;
    }

    public final void setFieldName(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setMyFieldName(fieldName);
    }

    public final void setWatchAccess(boolean value) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWatchAccess(value);
    }

    public final void setWatchModification(boolean value) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWatchModification(value);
    }

    public final void setWatchInitialization(boolean value) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWatchInitialization(value);
    }

    @NotNull
    protected Icon getDisabledIcon(boolean isMuted) {
        Icon icon;
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(myProject)");
        Breakpoint master = debuggerManagerEx.getBreakpointManager().findMasterBreakpoint((Breakpoint)this);
        if (isMuted && master == null) {
            Icon icon2 = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026disabled_field_breakpoint");
        } else if (isMuted && master != null) {
            Icon icon3 = AllIcons.Debugger.Db_muted_dep_field_breakpoint;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AllIcons.Debugger.Db_muted_dep_field_breakpoint");
        } else if (master != null) {
            Icon icon4 = AllIcons.Debugger.Db_dep_field_breakpoint;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"AllIcons.Debugger.Db_dep_field_breakpoint");
        } else {
            Icon icon5 = AllIcons.Debugger.Db_disabled_field_breakpoint;
            icon = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"AllIcons.Debugger.Db_disabled_field_breakpoint");
        }
        return icon;
    }

    @NotNull
    protected Icon getSetIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_field_breakpoint;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Debugger.Db_muted_field_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_field_breakpoint;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AllIcons.Debugger.Db_field_breakpoint");
        }
        return icon;
    }

    @NotNull
    protected Icon getVerifiedIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_field_breakpoint;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Debugger.Db_muted_field_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_verified_field_breakpoint;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AllIcons.Debugger.Db_verified_field_breakpoint");
        }
        return icon;
    }

    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Debugger.Db_exception_breakpoint");
        return icon;
    }

    @NotNull
    public Key<FieldBreakpoint> getCategory() {
        return CATEGORY;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public String getDisplayName() {
        String string;
        if (!this.isValid()) {
            return JavaDebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        String className = this.getClassName();
        if (className != null) {
            CharSequence charSequence = className;
            boolean bl = false;
            if (charSequence.length() > 0) {
                string = className + "." + this.getFieldName();
                return string;
            }
        }
        string = this.getFieldName();
        return string;
    }

    private final String getFieldName() {
        KtCallableDeclaration declaration2 = this.getField();
        String string = (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(declaration2){
            final /* synthetic */ KtCallableDeclaration $declaration;

            @Nullable
            public final String invoke() {
                KtCallableDeclaration ktCallableDeclaration = this.$declaration;
                return ktCallableDeclaration != null ? ktCallableDeclaration.getName() : null;
            }
            {
                this.$declaration = ktCallableDeclaration;
                super(0);
            }
        }));
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    @Nullable
    public PsiElement getEvaluationElement() {
        return (PsiElement)this.getField();
    }

    public KotlinFieldBreakpoint(@NotNull Project project, @NotNull XBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        super(project, breakpoint2);
        this.breakpointType = BreakpointType.FIELD;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpoint");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#org\u2026s.KotlinFieldBreakpoint\")");
        LOG = logger;
        Key key = BreakpointCategory.lookup((String)"field_breakpoints");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"BreakpointCategory.lookup(\"field_breakpoints\")");
        CATEGORY = key;
    }

    public static final /* synthetic */ boolean access$isPositionValid$s714927978(XSourcePosition p0) {
        return BreakpointWithHighlighter.isPositionValid((XSourcePosition)p0);
    }

    public static final /* synthetic */ KtCallableDeclaration access$getField(KotlinFieldBreakpoint $this) {
        return $this.getField();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpoint$BreakpointType;", "", "(Ljava/lang/String;I)V", "FIELD", "METHOD", "kotlin.jvm-debugger.core"})
    private static final class BreakpointType
    extends Enum<BreakpointType> {
        public static final /* enum */ BreakpointType FIELD;
        public static final /* enum */ BreakpointType METHOD;
        private static final /* synthetic */ BreakpointType[] $VALUES;

        static {
            BreakpointType[] breakpointTypeArray = new BreakpointType[2];
            BreakpointType[] breakpointTypeArray2 = breakpointTypeArray;
            breakpointTypeArray[0] = FIELD = new BreakpointType();
            breakpointTypeArray[1] = METHOD = new BreakpointType();
            $VALUES = breakpointTypeArray;
        }

        public static BreakpointType[] values() {
            return (BreakpointType[])$VALUES.clone();
        }

        public static BreakpointType valueOf(String string) {
            return Enum.valueOf(BreakpointType.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpoint$Companion;", "", "()V", "CATEGORY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/ui/breakpoints/FieldBreakpoint;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

