/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.core.service;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.core.service.KotlinVersionKind;
import org.jetbrains.kotlin.tools.projectWizard.core.service.KotlinVersionProviderService$WhenMappings;
import org.jetbrains.kotlin.tools.projectWizard.core.service.WizardKotlinVersion;
import org.jetbrains.kotlin.tools.projectWizard.core.service.WizardService;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.DefaultRepository;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Repositories;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Repository;
import org.jetbrains.kotlin.tools.projectWizard.settings.version.Version;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0004\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/core/service/KotlinVersionProviderService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/WizardService;", "()V", "getKotlinVersion", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/WizardKotlinVersion;", "projectKind", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/kotlin/ProjectKind;", "getKotlinVersionKind", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/KotlinVersionKind;", "version", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/version/Version;", "getKotlinVersionRepository", "Lorg/jetbrains/kotlin/tools/projectWizard/settings/buildsystem/Repository;", "versionKind", "kotlinVersionWithDefaultValues", "kotlin.project-wizard.core"})
public abstract class KotlinVersionProviderService
implements WizardService {
    @NotNull
    public abstract WizardKotlinVersion getKotlinVersion(@NotNull ProjectKind var1);

    @NotNull
    protected final WizardKotlinVersion kotlinVersionWithDefaultValues(@NotNull Version version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return new WizardKotlinVersion(version2, this.getKotlinVersionKind(version2), this.getKotlinVersionRepository(version2));
    }

    @NotNull
    protected Repository getKotlinVersionRepository(@NotNull KotlinVersionKind versionKind) {
        Repository repository;
        Intrinsics.checkNotNullParameter((Object)((Object)versionKind), (String)"versionKind");
        switch (KotlinVersionProviderService$WhenMappings.$EnumSwitchMapping$0[versionKind.ordinal()]) {
            case 1: {
                repository = DefaultRepository.Companion.getMAVEN_CENTRAL();
                break;
            }
            case 2: {
                repository = Repositories.INSTANCE.getKOTLIN_EAP_BINTRAY();
                break;
            }
            case 3: {
                repository = Repositories.INSTANCE.getKOTLIN_EAP_BINTRAY();
                break;
            }
            case 4: {
                repository = Repositories.INSTANCE.getKOTLIN_DEV_BINTRAY();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return repository;
    }

    private final Repository getKotlinVersionRepository(Version version2) {
        return this.getKotlinVersionRepository(this.getKotlinVersionKind(version2));
    }

    private final KotlinVersionKind getKotlinVersionKind(Version version2) {
        KotlinVersionKind kotlinVersionKind;
        String string = version2.toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"eap", (boolean)false, (int)2, null)) {
            kotlinVersionKind = KotlinVersionKind.EAP;
        } else {
            string = version2.toString();
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"rc", (boolean)false, (int)2, null)) {
                kotlinVersionKind = KotlinVersionKind.EAP;
            } else {
                string = version2.toString();
                bl = false;
                String string6 = string;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
                if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"dev", (boolean)false, (int)2, null)) {
                    kotlinVersionKind = KotlinVersionKind.DEV;
                } else {
                    string = version2.toString();
                    bl = false;
                    String string8 = string;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
                    kotlinVersionKind = StringsKt.contains$default((CharSequence)string9, (CharSequence)"m", (boolean)false, (int)2, null) ? KotlinVersionKind.M : KotlinVersionKind.STABLE;
                }
            }
        }
        return kotlinVersionKind;
    }
}

