/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.intellij.internal.statistic.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DeviceConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.connection.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.connection.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.connection.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.connection.StatServiceException;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.eventLog.connection.StatisticsService;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpRequests;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpResponse;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class EventLogStatisticsService
implements StatisticsService {
    private static final ContentType APPLICATION_JSON = ContentType.create((String)"application/json", (Charset)Consts.UTF_8);
    private static final int MAX_FILES_TO_SEND = 5;
    private final DeviceConfiguration myDeviceConfiguration;
    private final EventLogSettingsService mySettingsService;
    private final EventLogRecorderConfig myRecorderConfiguration;
    private final EventLogSendListener mySendListener;

    public EventLogStatisticsService(@NotNull DeviceConfiguration device, @NotNull EventLogRecorderConfig config, @NotNull EventLogApplicationInfo application, @Nullable EventLogSendListener listener) {
        if (device == null) {
            EventLogStatisticsService.$$$reportNull$$$0(0);
        }
        if (config == null) {
            EventLogStatisticsService.$$$reportNull$$$0(1);
        }
        if (application == null) {
            EventLogStatisticsService.$$$reportNull$$$0(2);
        }
        this.myDeviceConfiguration = device;
        this.myRecorderConfiguration = config;
        this.mySettingsService = new EventLogUploadSettingsService(config.getRecorderId(), application);
        this.mySendListener = listener;
    }

    @TestOnly
    public EventLogStatisticsService(@NotNull DeviceConfiguration device, @NotNull EventLogRecorderConfig config, @Nullable EventLogSendListener listener, @Nullable EventLogUploadSettingsService settingsService) {
        if (device == null) {
            EventLogStatisticsService.$$$reportNull$$$0(3);
        }
        if (config == null) {
            EventLogStatisticsService.$$$reportNull$$$0(4);
        }
        this.myDeviceConfiguration = device;
        this.myRecorderConfiguration = config;
        this.mySettingsService = settingsService;
        this.mySendListener = listener;
    }

    @Override
    public StatisticsResult send() {
        return EventLogStatisticsService.send(this.myDeviceConfiguration, this.myRecorderConfiguration, this.mySettingsService, new EventLogCounterResultDecorator(this.mySendListener));
    }

    public StatisticsResult send(@NotNull EventLogResultDecorator decorator) {
        if (decorator == null) {
            EventLogStatisticsService.$$$reportNull$$$0(5);
        }
        return EventLogStatisticsService.send(this.myDeviceConfiguration, this.myRecorderConfiguration, this.mySettingsService, decorator);
    }

    public static StatisticsResult send(@NotNull DeviceConfiguration device, @NotNull EventLogRecorderConfig config, @NotNull EventLogSettingsService settings, @NotNull EventLogResultDecorator decorator) {
        if (device == null) {
            EventLogStatisticsService.$$$reportNull$$$0(6);
        }
        if (config == null) {
            EventLogStatisticsService.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            EventLogStatisticsService.$$$reportNull$$$0(8);
        }
        if (decorator == null) {
            EventLogStatisticsService.$$$reportNull$$$0(9);
        }
        EventLogApplicationInfo info = settings.getApplicationInfo();
        DataCollectorDebugLogger logger = info.getLogger();
        List<EventLogFile> logs = EventLogStatisticsService.getLogFiles(config, logger);
        if (!config.isSendEnabled()) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger);
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "Event Log collector is not enabled");
        }
        if (logs.isEmpty()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to send");
        }
        if (!settings.isSettingsReachable()) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: settings server is unreachable");
        }
        if (!settings.isSendEnabled()) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger);
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        String serviceUrl = settings.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: unknown Statistics Service URL.");
        }
        boolean isInternal = info.isInternal();
        String productCode = info.getProductCode();
        EventLogBuildType defaultBuildType = EventLogStatisticsService.getDefaultBuildType(info);
        LogEventFilter baseFilter = settings.getBaseEventFilter();
        try {
            EventLogConnectionSettings connectionSettings = info.getConnectionSettings();
            decorator.onLogsLoaded(logs.size());
            ArrayList<File> toRemove = new ArrayList<File>(logs.size());
            int size = Math.min(5, logs.size());
            for (int i = 0; i < size; ++i) {
                EventLogFile logFile = logs.get(i);
                File file = logFile.getFile();
                EventLogBuildType type = logFile.getType(defaultBuildType);
                LogEventFilter filter = settings.getEventFilter(baseFilter, type);
                String deviceId = device.getDeviceId();
                LogEventRecordRequest recordRequest = LogEventRecordRequest.Companion.create(file, config.getRecorderId(), productCode, deviceId, filter, isInternal, logger);
                String error = EventLogStatisticsService.validate(recordRequest, file);
                if (StatisticsStringUtil.isNotEmpty((String)error) || recordRequest == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(file.getName() + "-> " + error);
                    }
                    decorator.onFailed(recordRequest, null);
                    toRemove.add(file);
                    continue;
                }
                try {
                    StatsHttpRequests.post(serviceUrl, connectionSettings).withBody(LogEventSerializer.INSTANCE.toString(recordRequest), APPLICATION_JSON).succeed((r, code) -> {
                        toRemove.add(file);
                        decorator.onSucceed(recordRequest, EventLogStatisticsService.loadAndLogResponse(logger, r, file), file.getAbsolutePath());
                    }).fail((r, code) -> {
                        if (code == 400) {
                            toRemove.add(file);
                        }
                        decorator.onFailed(recordRequest, EventLogStatisticsService.loadAndLogResponse(logger, r, file));
                    }).send();
                    continue;
                }
                catch (Exception e) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(file.getName() + " -> " + e.getMessage());
                    }
                    decorator.onFailed(null, null);
                }
            }
            EventLogStatisticsService.cleanupFiles(toRemove, logger);
            return decorator.onFinished();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.info(message != null ? message : "", e);
            throw new StatServiceException("Error during data sending.", e);
        }
    }

    @NotNull
    private static EventLogBuildType getDefaultBuildType(EventLogApplicationInfo info) {
        EventLogBuildType eventLogBuildType = info.isEAP() ? EventLogBuildType.EAP : EventLogBuildType.RELEASE;
        if (eventLogBuildType == null) {
            EventLogStatisticsService.$$$reportNull$$$0(10);
        }
        return eventLogBuildType;
    }

    @NotNull
    private static String loadAndLogResponse(@NotNull DataCollectorDebugLogger logger, @NotNull StatsHttpResponse response, @NotNull File file) throws IOException {
        String message;
        String content;
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(11);
        }
        if (response == null) {
            EventLogStatisticsService.$$$reportNull$$$0(12);
        }
        if (file == null) {
            EventLogStatisticsService.$$$reportNull$$$0(13);
        }
        String string = content = (message = response.readAsString()) != null ? message : Integer.toString(response.getStatusCode());
        if (logger.isTraceEnabled()) {
            logger.trace(file.getName() + " -> " + content);
        }
        String string2 = content;
        if (string2 == null) {
            EventLogStatisticsService.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @Nullable
    private static String validate(@Nullable LogEventRecordRequest request, @NotNull File file) {
        if (file == null) {
            EventLogStatisticsService.$$$reportNull$$$0(15);
        }
        if (request == null) {
            return "File is empty or has invalid format: " + file.getName();
        }
        if (StatisticsStringUtil.isEmpty((String)request.getDevice())) {
            return "Cannot upload event log, device ID is empty";
        }
        if (StatisticsStringUtil.isEmpty((String)request.getProduct())) {
            return "Cannot upload event log, product code is empty";
        }
        if (StatisticsStringUtil.isEmpty((String)request.getRecorder())) {
            return "Cannot upload event log, recorder code is empty";
        }
        if (request.getRecords().isEmpty()) {
            return "Cannot upload event log, record list is empty";
        }
        for (LogEventRecord content : request.getRecords()) {
            if (!content.getEvents().isEmpty()) continue;
            return "Cannot upload event log, event list is empty";
        }
        return null;
    }

    @NotNull
    protected static List<EventLogFile> getLogFiles(@NotNull EventLogRecorderConfig provider, @NotNull DataCollectorDebugLogger logger) {
        List<EventLogFile> list;
        if (provider == null) {
            EventLogStatisticsService.$$$reportNull$$$0(16);
        }
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(17);
        }
        try {
            list = provider.getLogFilesProvider().getLogFiles();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.info(message != null ? message : "", e);
            List<EventLogFile> list2 = Collections.emptyList();
            if (list2 == null) {
                EventLogStatisticsService.$$$reportNull$$$0(19);
            }
            return list2;
        }
        if (list == null) {
            EventLogStatisticsService.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static void cleanupEventLogFiles(@NotNull List<EventLogFile> toRemove, @NotNull DataCollectorDebugLogger logger) {
        if (toRemove == null) {
            EventLogStatisticsService.$$$reportNull$$$0(20);
        }
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(21);
        }
        ArrayList<File> filesToRemove = new ArrayList<File>();
        for (EventLogFile file : toRemove) {
            filesToRemove.add(file.getFile());
        }
        EventLogStatisticsService.cleanupFiles(filesToRemove, logger);
    }

    private static void cleanupFiles(@NotNull List<File> toRemove, @NotNull DataCollectorDebugLogger logger) {
        if (toRemove == null) {
            EventLogStatisticsService.$$$reportNull$$$0(22);
        }
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(23);
        }
        for (File file : toRemove) {
            if (!file.delete()) {
                logger.warn("Failed deleting event log: " + file.getName());
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Removed sent log: " + file.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/EventLogStatisticsService";
                break;
            }
            case 11: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/EventLogStatisticsService";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBuildType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndLogResponse";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadAndLogResponse";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLogFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cleanupEventLogFiles";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "cleanupFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EventLogCounterResultDecorator
    implements EventLogResultDecorator {
        private final EventLogSendListener myListener;
        private int myLocalFiles = -1;
        private int myFailed = 0;
        private final List<String> mySuccessfullySentFiles = new ArrayList<String>();

        private EventLogCounterResultDecorator(@Nullable EventLogSendListener listener) {
            this.myListener = listener;
        }

        @Override
        public void onLogsLoaded(int localFiles) {
            this.myLocalFiles = localFiles;
        }

        @Override
        public void onSucceed(@NotNull LogEventRecordRequest request, @NotNull String content, @NotNull String logPath) {
            if (request == null) {
                EventLogCounterResultDecorator.$$$reportNull$$$0(0);
            }
            if (content == null) {
                EventLogCounterResultDecorator.$$$reportNull$$$0(1);
            }
            if (logPath == null) {
                EventLogCounterResultDecorator.$$$reportNull$$$0(2);
            }
            this.mySuccessfullySentFiles.add(logPath);
        }

        @Override
        public void onFailed(@Nullable LogEventRecordRequest request, @Nullable String content) {
            ++this.myFailed;
        }

        @Override
        @NotNull
        public StatisticsResult onFinished() {
            int succeed;
            int total;
            if (this.myListener != null) {
                this.myListener.onLogsSend(this.mySuccessfullySentFiles, this.myFailed, this.myLocalFiles);
            }
            if ((total = (succeed = this.mySuccessfullySentFiles.size()) + this.myFailed) == 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
            }
            if (this.myFailed > 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, "Uploaded " + succeed + " out of " + total + " files.");
            }
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "Uploaded " + succeed + " files.");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/statistic/eventLog/connection/EventLogStatisticsService$EventLogCounterResultDecorator";
            objectArray[2] = "onSucceed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

