/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader;

import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDataCollectorLogger
implements DataCollectorDebugLogger {
    @NonNls
    private final Logger myLogger = Logger.getLogger((String)"com.intellij.internal.statistic.uploader");

    public ExternalDataCollectorLogger() {
        String logDirectory = ExternalDataCollectorLogger.findDirectory(1000000L);
        if (logDirectory != null) {
            String directory = new File(logDirectory, "idea_statistics_uploader.log").getAbsolutePath();
            this.myLogger.addAppender((Appender)ExternalDataCollectorLogger.newAppender(directory));
            this.myLogger.setLevel(Level.ALL);
        }
    }

    @Nullable
    public static String findDirectory(long requiredFreeSpace) {
        String dir = System.getProperty("java.io.tmpdir");
        if (dir != null && ExternalDataCollectorLogger.isValidDir(dir, requiredFreeSpace)) {
            return dir;
        }
        return null;
    }

    private static boolean isValidDir(String path, long space) {
        File dir = new File(path);
        return dir.isDirectory() && dir.canWrite() && dir.getUsableSpace() >= space;
    }

    @NotNull
    private static FileAppender newAppender(@NotNull String directory) {
        if (directory == null) {
            ExternalDataCollectorLogger.$$$reportNull$$$0(0);
        }
        @NonNls FileAppender appender = new FileAppender();
        appender.setFile(directory);
        appender.setLayout((Layout)new PatternLayout("%d{dd/MM HH:mm:ss} %-5p %C - %m%n"));
        appender.setThreshold((Priority)Level.ALL);
        appender.setAppend(false);
        appender.activateOptions();
        FileAppender fileAppender = appender;
        if (fileAppender == null) {
            ExternalDataCollectorLogger.$$$reportNull$$$0(1);
        }
        return fileAppender;
    }

    @Override
    public void info(String message) {
        this.myLogger.info((Object)message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.myLogger.info((Object)message, t);
    }

    @Override
    public void warn(String message) {
        this.myLogger.warn((Object)message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.myLogger.warn((Object)message, t);
    }

    @Override
    public void trace(String message) {
        this.myLogger.trace((Object)message);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.myLogger.isTraceEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/uploader/ExternalDataCollectorLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/uploader/ExternalDataCollectorLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newAppender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newAppender";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

