/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Text;

public final class TextWidgetMatcherEditor
extends TextMatcherEditor {
    private Text text;
    private boolean live;
    private FilterChangeListener filterChangeListener = new FilterChangeListener();

    public TextWidgetMatcherEditor(Text text, TextFilterator textFilterator) {
        this(text, textFilterator, true);
    }

    public TextWidgetMatcherEditor(Text text, TextFilterator textFilterator, boolean live) {
        super(textFilterator);
        this.text = text;
        this.live = live;
        this.registerListeners(live);
        this.refilter();
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        if (live == this.live) {
            return;
        }
        this.deregisterListeners(this.live);
        this.live = live;
        this.registerListeners(this.live);
    }

    private void registerListeners(boolean live) {
        if (live) {
            this.text.addModifyListener((ModifyListener)this.filterChangeListener);
        } else {
            this.text.addSelectionListener((SelectionListener)this.filterChangeListener);
        }
    }

    private void deregisterListeners(boolean live) {
        if (live) {
            this.text.removeModifyListener((ModifyListener)this.filterChangeListener);
        } else {
            this.text.removeSelectionListener((SelectionListener)this.filterChangeListener);
        }
    }

    public SelectionListener getFilterSelectionListener() {
        return this.filterChangeListener;
    }

    public void dispose() {
        this.deregisterListeners(this.live);
    }

    private void refilter() {
        this.setFilterText(this.text.getText().split("[ \t]"));
    }

    private class FilterChangeListener
    implements SelectionListener,
    ModifyListener {
        private FilterChangeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TextWidgetMatcherEditor.this.refilter();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TextWidgetMatcherEditor.this.refilter();
        }

        public void modifyText(ModifyEvent e) {
            TextWidgetMatcherEditor.this.refilter();
        }
    }
}

