/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.FullMessage;
import org.traccar.reports.ReportUtils;

public final class NotificationFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationFormatter.class);

    private NotificationFormatter() {
    }

    public static VelocityContext prepareContext(long userId, Event event, Position position) {
        String driverUniqueId;
        User user = Context.getPermissionsManager().getUser(userId);
        Device device = Context.getIdentityManager().getById(event.getDeviceId());
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("user", (Object)user);
        velocityContext.put("device", (Object)device);
        velocityContext.put("event", (Object)event);
        if (position != null) {
            velocityContext.put("position", (Object)position);
            velocityContext.put("speedUnit", (Object)ReportUtils.getSpeedUnit(userId));
            velocityContext.put("distanceUnit", (Object)ReportUtils.getDistanceUnit(userId));
            velocityContext.put("volumeUnit", (Object)ReportUtils.getVolumeUnit(userId));
        }
        if (event.getGeofenceId() != 0L) {
            velocityContext.put("geofence", Context.getGeofenceManager().getById(event.getGeofenceId()));
        }
        if (event.getMaintenanceId() != 0L) {
            velocityContext.put("maintenance", Context.getMaintenancesManager().getById(event.getMaintenanceId()));
        }
        if ((driverUniqueId = event.getString("driverUniqueId")) != null) {
            velocityContext.put("driver", (Object)Context.getDriversManager().getDriverByUniqueId(driverUniqueId));
        }
        velocityContext.put("webUrl", Context.getVelocityEngine().getProperty("web.url"));
        velocityContext.put("dateTool", (Object)new DateTool());
        velocityContext.put("numberTool", (Object)new NumberTool());
        velocityContext.put("timezone", (Object)ReportUtils.getTimezone(userId));
        velocityContext.put("locale", (Object)Locale.getDefault());
        return velocityContext;
    }

    public static Template getTemplate(Event event, String path) {
        Template template;
        try {
            String templateFilePath = Paths.get(path, event.getType() + ".vm").toString();
            template = Context.getVelocityEngine().getTemplate(templateFilePath, StandardCharsets.UTF_8.name());
        }
        catch (ResourceNotFoundException error) {
            LOGGER.warn("Notification template error", (Throwable)error);
            String templateFilePath = Paths.get(path, "unknown.vm").toString();
            template = Context.getVelocityEngine().getTemplate(templateFilePath, StandardCharsets.UTF_8.name());
        }
        return template;
    }

    public static FullMessage formatFullMessage(long userId, Event event, Position position) {
        VelocityContext velocityContext = NotificationFormatter.prepareContext(userId, event, position);
        String formattedMessage = NotificationFormatter.formatMessage(velocityContext, userId, event, position, "full");
        return new FullMessage((String)velocityContext.get("subject"), formattedMessage);
    }

    public static String formatShortMessage(long userId, Event event, Position position) {
        return NotificationFormatter.formatMessage(null, userId, event, position, "short");
    }

    private static String formatMessage(VelocityContext vc, Long userId, Event event, Position position, String templatePath) {
        VelocityContext velocityContext = vc;
        if (velocityContext == null) {
            velocityContext = NotificationFormatter.prepareContext(userId, event, position);
        }
        StringWriter writer = new StringWriter();
        NotificationFormatter.getTemplate(event, templatePath).merge((org.apache.velocity.context.Context)velocityContext, (Writer)writer);
        return writer.toString();
    }
}

