/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.protobuf.dolphin.Messages.DolphinMessages;

public class DolphinProtocolDecoder
extends BaseProtocolDecoder {
    public DolphinProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedShort();
        buf.readUnsignedIntLE();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        int type = buf.readUnsignedShortLE();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(buf.readLongLE()));
        if (deviceSession == null) {
            return null;
        }
        int length = (int)buf.readUnsignedIntLE();
        buf.readUnsignedInt();
        if (type == DolphinMessages.MessageType.DataPack_Request.getNumber()) {
            DolphinMessages.DataPackRequest message = DolphinMessages.DataPackRequest.parseFrom(ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)length, (boolean)false));
            LinkedList<Position> positions = new LinkedList<Position>();
            for (int i = 0; i < message.getPointsCount(); ++i) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                DolphinMessages.DataPoint point = message.getPoints(i);
                position.setValid(true);
                position.setTime(new Date((long)point.getTimestamp() * 1000L));
                position.setLatitude(point.getLatitude());
                position.setLongitude(point.getLongitude());
                position.setAltitude(point.getAltitude());
                position.setSpeed(UnitsConverter.knotsFromKph(point.getSpeed()));
                position.setCourse(point.getBearing());
                position.set("sat", point.getSatellites());
                position.set("hdop", point.getHDOP());
                positions.add(position);
            }
            return positions;
        }
        return null;
    }
}

