/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class Ivt401ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("(").expression("TL[ABLN],").number("(d+),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("([-+]d+.d+),").number("([-+]d+.d+),").number("(d+),").number("(d+),").number("(-?d+.?d*),").number("d+,").number("(d),").number("(d+),").number("(d+),").number("(d+),").number("(d+.d+),").number("(d+.d+),").number("(d+.d+),").number("(-?d+.?d*),").expression("([^,]+),").number("(d+),").number("(d+.d+),").number("(-?d+),").number("(d+),").number("(d+),").groupBegin().number("([01]),").number("[01],").number("[01],").number("[01],").number("[0-2]+,").number("([0-3]),").number("[01],").number("([01]),").number("([01]),").number("[01],").number("([01]),").number("[01],").number("[128],").expression("([^,]+)?,").number("d+,").groupEnd("?").any().compile();

    public Ivt401ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.setAltitude(parser.nextDouble());
        position.setValid(parser.nextInt() > 0);
        position.set("rssi", parser.nextInt());
        String input = parser.next();
        for (int i = 0; i < input.length(); ++i) {
            int value = Character.getNumericValue(input.charAt(i));
            if (value >= 2) continue;
            position.set("in" + (i + 1), value > 0);
        }
        String output = parser.next();
        for (int i = 0; i < output.length(); ++i) {
            position.set("out" + (i + 1), Character.getNumericValue(output.charAt(i)) > 0);
        }
        position.set("adc1", parser.nextDouble());
        position.set("power", parser.nextDouble());
        position.set("battery", parser.nextDouble());
        position.set("deviceTemp", parser.nextDouble());
        String temp = parser.next();
        if (temp.startsWith("M")) {
            int index = 1;
            int startIndex = 1;
            while (startIndex < temp.length()) {
                int endIndex = temp.indexOf(45, startIndex + 1);
                if (endIndex < 0) {
                    endIndex = temp.indexOf(43, startIndex + 1);
                }
                if (endIndex < 0) {
                    endIndex = temp.length();
                }
                if (endIndex > 0) {
                    double value = Double.parseDouble(temp.substring(startIndex, endIndex));
                    position.set("temp" + index++, value);
                }
                startIndex = endIndex;
            }
        } else {
            position.set("temp1", Double.parseDouble(temp));
        }
        position.set("motion", parser.nextInt() > 0);
        position.set("acceleration", parser.nextDouble());
        parser.nextInt();
        parser.nextInt();
        position.set("odometer", parser.nextLong());
        if (parser.hasNext(6)) {
            position.set("alarm", parser.nextInt() == 1 ? "overspeed" : null);
            switch (parser.nextInt()) {
                case 1: {
                    position.set("alarm", "hardAcceleration");
                    break;
                }
                case 2: {
                    position.set("alarm", "hardBraking");
                    break;
                }
                case 3: {
                    position.set("alarm", "hardCornering");
                    break;
                }
            }
            position.set("alarm", parser.nextInt() == 1 ? "lowBattery" : null);
            position.set("alarm", parser.nextInt() == 1 ? "powerCut" : null);
            position.set("alarm", parser.nextInt() == 1 ? "tow" : null);
            position.set("driverUniqueId", parser.next());
        }
        return position;
    }
}

