/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor.jvm;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.database.PreparedStatementFactory;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.AbstractExecutor;
import liquibase.executor.jvm.CallableStatementCallback;
import liquibase.executor.jvm.ColumnMapRowMapper;
import liquibase.executor.jvm.ResultSetExtractor;
import liquibase.executor.jvm.RowMapper;
import liquibase.executor.jvm.RowMapperResultSetExtractor;
import liquibase.executor.jvm.SingleColumnRowMapper;
import liquibase.executor.jvm.StatementCallback;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.sql.CallableSql;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.CallableSqlStatement;
import liquibase.statement.CompoundStatement;
import liquibase.statement.ExecutablePreparedStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.util.JdbcUtils;
import liquibase.util.StringUtils;

public class JdbcExecutor
extends AbstractExecutor {
    private Logger log = LogService.getLog(this.getClass());

    @Override
    public String getName() {
        return "jdbc";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean updatesDatabase() {
        return true;
    }

    public Object execute(StatementCallback action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Object object;
        this.log.debug("Executing with the '" + this.getName() + "' executor");
        DatabaseConnection con = this.database.getConnection();
        Statement stmt = null;
        try {
            if (con instanceof OfflineConnection) {
                throw new DatabaseException("Cannot execute commands against an offline database");
            }
            Statement stmtToUse = stmt = ((JdbcConnection)con).getUnderlyingConnection().createStatement();
            object = action.doInStatement(stmtToUse);
        }
        catch (SQLException ex2) {
            try {
                JdbcUtils.closeStatement(stmt);
                stmt = null;
                String url = con.isClosed() ? "CLOSED CONNECTION" : con.getURL();
                throw new DatabaseException("Error executing SQL " + StringUtils.join(this.applyVisitors(action.getStatement(), sqlVisitors), "; on " + url) + ": " + ex2.getMessage(), ex2);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        return object;
    }

    public Object execute(CallableStatementCallback action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Object object;
        DatabaseConnection con = this.database.getConnection();
        if (con instanceof OfflineConnection) {
            throw new DatabaseException("Cannot execute commands against an offline database");
        }
        CallableStatement stmt = null;
        try {
            String sql = this.applyVisitors(action.getStatement(), sqlVisitors)[0];
            stmt = ((JdbcConnection)con).getUnderlyingConnection().prepareCall(sql);
            object = action.doInCallableStatement(stmt);
        }
        catch (SQLException ex2) {
            try {
                JdbcUtils.closeStatement(stmt);
                stmt = null;
                throw new DatabaseException("Error executing SQL " + StringUtils.join(this.applyVisitors(action.getStatement(), sqlVisitors), "; on " + con.getURL()) + ": " + ex2.getMessage(), ex2);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        return object;
    }

    @Override
    public void execute(SqlStatement sql) throws DatabaseException {
        this.execute(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public void execute(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof ExecutablePreparedStatement) {
            ((ExecutablePreparedStatement)sql).execute(new PreparedStatementFactory((JdbcConnection)this.database.getConnection()));
            return;
        }
        if (sql instanceof CompoundStatement && this.database instanceof Db2zDatabase) {
            this.executeDb2ZosComplexStatement(sql);
            return;
        }
        if (sql instanceof DropTableStatement && this.database instanceof Db2zDatabase) {
            this.execute(new ExecuteStatementCallbackAndCatch(sql, sqlVisitors), sqlVisitors);
        } else {
            this.execute(new ExecuteStatementCallback(sql, sqlVisitors), sqlVisitors);
        }
    }

    public Object query(SqlStatement sql, ResultSetExtractor rse) throws DatabaseException {
        return this.query(sql, rse, new ArrayList<SqlVisitor>());
    }

    public Object query(SqlStatement sql, ResultSetExtractor rse, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof CallableSqlStatement) {
            return this.execute(new QueryCallableStatementCallback(sql, rse), sqlVisitors);
        }
        return this.execute(new QueryStatementCallback(sql, rse, sqlVisitors), sqlVisitors);
    }

    public List query(SqlStatement sql, RowMapper rowMapper) throws DatabaseException {
        return this.query(sql, rowMapper, new ArrayList<SqlVisitor>());
    }

    public List query(SqlStatement sql, RowMapper rowMapper, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return (List)this.query(sql, new RowMapperResultSetExtractor(rowMapper), sqlVisitors);
    }

    public Object queryForObject(SqlStatement sql, RowMapper rowMapper) throws DatabaseException {
        return this.queryForObject(sql, rowMapper, new ArrayList<SqlVisitor>());
    }

    public Object queryForObject(SqlStatement sql, RowMapper rowMapper, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        List results = this.query(sql, rowMapper, sqlVisitors);
        try {
            return JdbcUtils.requiredSingleResult(results);
        }
        catch (DatabaseException e2) {
            throw new DatabaseException("Expected single row from " + sql + " but got " + results.size(), e2);
        }
    }

    @Override
    public <T> T queryForObject(SqlStatement sql, Class<T> requiredType) throws DatabaseException {
        return this.queryForObject(sql, requiredType, new ArrayList<SqlVisitor>());
    }

    @Override
    public <T> T queryForObject(SqlStatement sql, Class<T> requiredType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return (T)this.queryForObject(sql, this.getSingleColumnRowMapper(requiredType), sqlVisitors);
    }

    @Override
    public long queryForLong(SqlStatement sql) throws DatabaseException {
        return this.queryForLong(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public long queryForLong(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Number number = this.queryForObject(sql, Long.class, sqlVisitors);
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public int queryForInt(SqlStatement sql) throws DatabaseException {
        return this.queryForInt(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public int queryForInt(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Number number = this.queryForObject(sql, Integer.class, sqlVisitors);
        return number != null ? number.intValue() : 0;
    }

    @Override
    public List queryForList(SqlStatement sql, Class elementType) throws DatabaseException {
        return this.queryForList(sql, elementType, new ArrayList<SqlVisitor>());
    }

    @Override
    public List queryForList(SqlStatement sql, Class elementType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.query(sql, this.getSingleColumnRowMapper(elementType), sqlVisitors);
    }

    @Override
    public List<Map<String, ?>> queryForList(SqlStatement sql) throws DatabaseException {
        return this.queryForList(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public List<Map<String, ?>> queryForList(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.query(sql, this.getColumnMapRowMapper(), sqlVisitors);
    }

    @Override
    public int update(SqlStatement sql) throws DatabaseException {
        return this.update(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public int update(final SqlStatement sql, final List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof CallableSqlStatement) {
            throw new DatabaseException("Direct update using CallableSqlStatement not currently implemented");
        }
        class UpdateStatementCallback
        implements StatementCallback {
            UpdateStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
                String[] sqlToExecute = JdbcExecutor.this.applyVisitors(sql, sqlVisitors);
                if (sqlToExecute.length != 1) {
                    throw new DatabaseException("Cannot call update on Statement that returns back multiple Sql objects");
                }
                JdbcExecutor.this.log.debug(LogType.WRITE_SQL, sqlToExecute[0]);
                return stmt.executeUpdate(sqlToExecute[0]);
            }

            @Override
            public SqlStatement getStatement() {
                return sql;
            }
        }
        return (Integer)this.execute(new UpdateStatementCallback(), sqlVisitors);
    }

    protected RowMapper getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected RowMapper getSingleColumnRowMapper(Class requiredType) {
        return new SingleColumnRowMapper(requiredType);
    }

    @Override
    public void comment(String message) throws DatabaseException {
        LogService.getLog(this.getClass()).debug(LogType.LOG, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDb2ZosComplexStatement(SqlStatement sqlStatement) throws DatabaseException {
        Sql[] sqls;
        DatabaseConnection con = this.database.getConnection();
        if (con instanceof OfflineConnection) {
            throw new DatabaseException("Cannot execute commands against an offline database");
        }
        for (Sql sql : sqls = SqlGeneratorFactory.getInstance().generateSql(sqlStatement, this.database)) {
            try {
                if (sql instanceof CallableSql) {
                    CallableStatement call = null;
                    ResultSet resultSet = null;
                    try {
                        call = ((JdbcConnection)con).getUnderlyingConnection().prepareCall(sql.toSql());
                        resultSet = call.executeQuery();
                        this.checkCallStatus(resultSet, ((CallableSql)sql).getExpectedStatus());
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.close(resultSet, call);
                        throw throwable;
                    }
                    JdbcUtils.close(resultSet, call);
                    continue;
                }
                Statement stmt = null;
                try {
                    stmt = ((JdbcConnection)con).getUnderlyingConnection().createStatement();
                    stmt.execute(sql.toSql());
                    con.commit();
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeStatement(stmt);
                    throw throwable;
                }
                JdbcUtils.closeStatement(stmt);
            }
            catch (Exception e2) {
                throw new DatabaseException(e2.getMessage() + " [Failed SQL: " + this.getErrorCode(e2) + sql.toSql() + "]", e2);
            }
        }
    }

    private void checkCallStatus(ResultSet resultSet, String status) throws SQLException, DatabaseException {
        if (status != null) {
            StringBuilder message = new StringBuilder();
            while (resultSet.next()) {
                String string = resultSet.getString(2);
                if (string.contains(status)) {
                    return;
                }
                message.append(string).append("\n");
            }
            throw new DatabaseException(message.toString());
        }
    }

    String getErrorCode(Throwable e2) {
        if (e2 instanceof SQLException) {
            return "(" + ((SQLException)e2).getErrorCode() + ") ";
        }
        return "";
    }

    private class QueryCallableStatementCallback
    implements CallableStatementCallback {
        private final SqlStatement sql;
        private final ResultSetExtractor rse;

        private QueryCallableStatementCallback(SqlStatement sql, ResultSetExtractor rse) {
            this.sql = sql;
            this.rse = rse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object doInCallableStatement(CallableStatement cs2) throws SQLException, DatabaseException {
            ResultSet rs = null;
            try {
                rs = cs2.executeQuery();
                Object object = this.rse.extractData(rs);
                return object;
            }
            finally {
                JdbcUtils.closeResultSet(rs);
            }
        }

        @Override
        public SqlStatement getStatement() {
            return this.sql;
        }
    }

    private class QueryStatementCallback
    implements StatementCallback {
        private final SqlStatement sql;
        private final List<SqlVisitor> sqlVisitors;
        private final ResultSetExtractor rse;

        private QueryStatementCallback(SqlStatement sql, ResultSetExtractor rse, List<SqlVisitor> sqlVisitors) {
            this.sql = sql;
            this.rse = rse;
            this.sqlVisitors = sqlVisitors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
            Object object;
            block4: {
                ResultSet rs = null;
                try {
                    String[] sqlToExecute = JdbcExecutor.this.applyVisitors(this.sql, this.sqlVisitors);
                    if (sqlToExecute.length != 1) {
                        throw new DatabaseException("Can only query with statements that return one sql statement");
                    }
                    JdbcExecutor.this.log.debug(LogType.READ_SQL, sqlToExecute[0]);
                    ResultSet rsToUse = rs = stmt.executeQuery(sqlToExecute[0]);
                    object = this.rse.extractData(rsToUse);
                    if (rs == null) break block4;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        JdbcUtils.closeResultSet(rs);
                    }
                    throw throwable;
                }
                JdbcUtils.closeResultSet(rs);
            }
            return object;
        }

        @Override
        public SqlStatement getStatement() {
            return this.sql;
        }
    }

    private class ExecuteStatementCallback
    implements StatementCallback {
        private final SqlStatement sql;
        private final List<SqlVisitor> sqlVisitors;

        private ExecuteStatementCallback(SqlStatement sql, List<SqlVisitor> sqlVisitors) {
            this.sql = sql;
            this.sqlVisitors = sqlVisitors;
        }

        @Override
        public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
            for (String statement : JdbcExecutor.this.applyVisitors(this.sql, this.sqlVisitors)) {
                if (JdbcExecutor.this.database instanceof OracleDatabase) {
                    while (statement.matches("(?s).*[\\s\\r\\n]*[^*]/[\\s\\r\\n]*$")) {
                        statement = statement.replaceFirst("[\\s\\r\\n]*[^*]/[\\s\\r\\n]*$", "");
                    }
                }
                JdbcExecutor.this.log.debug(LogType.WRITE_SQL, String.format("%s", statement));
                if (statement.contains("?")) {
                    stmt.setEscapeProcessing(false);
                }
                try {
                    if (!stmt.execute(statement)) {
                        JdbcExecutor.this.log.debug(Integer.toString(stmt.getUpdateCount()) + " row(s) affected");
                    }
                }
                catch (Throwable e2) {
                    throw new DatabaseException(e2.getMessage() + " [Failed SQL: " + JdbcExecutor.this.getErrorCode(e2) + statement + "]", e2);
                }
                try {
                    int updateCount = 0;
                    do {
                        if (stmt.getMoreResults() || (updateCount = stmt.getUpdateCount()) == -1) continue;
                        JdbcExecutor.this.log.debug(Integer.toString(updateCount) + " row(s) affected");
                    } while (updateCount != -1);
                }
                catch (Exception e3) {
                    throw new DatabaseException(e3.getMessage() + " [Failed SQL: " + JdbcExecutor.this.getErrorCode(e3) + statement + "]", e3);
                }
            }
            return null;
        }

        @Override
        public SqlStatement getStatement() {
            return this.sql;
        }
    }

    private class ExecuteStatementCallbackAndCatch
    extends ExecuteStatementCallback {
        private ExecuteStatementCallbackAndCatch(SqlStatement sql, List<SqlVisitor> sqlVisitors) {
            super(sql, sqlVisitors);
        }

        @Override
        public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
            try {
                return super.doInStatement(stmt);
            }
            catch (DatabaseException dbe) {
                String message = dbe.getMessage();
                if (message == null || !message.toLowerCase().contains("failed sql: drop database ")) {
                    throw new DatabaseException(dbe);
                }
                JdbcExecutor.this.log.info("If this is an attempt to drop a database, the database may have already been dropped");
                return null;
            }
        }
    }
}

