/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext.databasesearcher;

import ghidra.app.plugin.core.searchtext.databasesearcher.ProgramDatabaseFieldSearcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabelFieldSearcher
extends ProgramDatabaseFieldSearcher {
    private AddressIterator iterator;
    private SymbolTable symbolTable;
    private Program program;

    public LabelFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern) {
        super(pattern, forward, startLoc, set);
        AddressIterator refIterator;
        SymbolIterator symbolIterator;
        this.program = program;
        this.symbolTable = program.getSymbolTable();
        if (set != null) {
            symbolIterator = program.getSymbolTable().getPrimarySymbolIterator(set, forward);
            refIterator = program.getReferenceManager().getReferenceDestinationIterator(set, forward);
        } else {
            symbolIterator = program.getSymbolTable().getPrimarySymbolIterator(startLoc.getAddress(), forward);
            refIterator = program.getReferenceManager().getReferenceDestinationIterator(startLoc.getAddress(), forward);
        }
        this.iterator = new SymbolAddressIterator(symbolIterator, refIterator, forward);
    }

    @Override
    protected Address advance(List<ProgramLocation> currentMatches) {
        Address nextAddress = this.iterator.next();
        if (nextAddress == null) {
            return null;
        }
        this.findMatchesForCurrentAddress(nextAddress, currentMatches);
        return nextAddress;
    }

    private void findMatchesForCurrentAddress(Address address, List<ProgramLocation> currentMatches) {
        Symbol[] symbols = this.symbolTable.getSymbols(address);
        this.makePrimaryLastItem(symbols);
        for (Symbol symbol : symbols) {
            Matcher matcher = this.pattern.matcher(symbol.getName());
            while (matcher.find()) {
                int charOffset = matcher.start();
                currentMatches.add((ProgramLocation)new LabelFieldLocation(symbol, 0, charOffset));
            }
        }
    }

    private void makePrimaryLastItem(Symbol[] symbols) {
        for (int i = 0; i < symbols.length - 1; ++i) {
            if (!symbols[i].isPrimary()) continue;
            Symbol primary = symbols[i];
            System.arraycopy(symbols, i + 1, symbols, i, symbols.length - i - 1);
            symbols[symbols.length - 1] = primary;
            break;
        }
    }

    private static class SymbolAddressIterator
    implements AddressIterator {
        private SymbolIterator symbolIterator;
        private AddressIterator refIterator;
        private Address nextAddress;
        private Address nextSymbolAddress;
        private Address nextRefAddress;
        private final boolean forward;

        SymbolAddressIterator(SymbolIterator symbolIterator, AddressIterator refIterator, boolean forward) {
            this.symbolIterator = symbolIterator;
            this.refIterator = refIterator;
            this.forward = forward;
            this.nextSymbolAddress = this.getNextSymbolAddress();
            this.nextRefAddress = this.getNextRefAddress();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Address getNextRefAddress() {
            if (this.refIterator.hasNext()) {
                return this.refIterator.next();
            }
            return null;
        }

        private Address getNextSymbolAddress() {
            while (this.symbolIterator.hasNext()) {
                Symbol symbol = this.symbolIterator.next();
                if (symbol == null) continue;
                return symbol.getAddress();
            }
            return null;
        }

        public boolean hasNext() {
            if (this.nextAddress == null) {
                this.findNext();
            }
            return this.nextAddress != null;
        }

        private void findNext() {
            if (this.nextSymbolAddress == null) {
                this.nextSymbolAddress = this.getNextSymbolAddress();
            }
            if (this.nextRefAddress == null) {
                this.nextRefAddress = this.getNextRefAddress();
            }
            if (this.nextSymbolAddress == null) {
                this.nextAddress = this.nextRefAddress;
                this.nextRefAddress = null;
            } else if (this.nextRefAddress == null) {
                this.nextAddress = this.nextSymbolAddress;
                this.nextSymbolAddress = null;
            } else {
                int compareResult = this.nextSymbolAddress.compareTo((Object)this.nextRefAddress);
                if (compareResult == 0) {
                    this.nextAddress = this.nextSymbolAddress;
                    this.nextSymbolAddress = null;
                    this.nextRefAddress = null;
                } else if (this.forward && compareResult < 0 || !this.forward && compareResult > 0) {
                    this.nextAddress = this.nextSymbolAddress;
                    this.nextSymbolAddress = null;
                } else {
                    this.nextAddress = this.nextRefAddress;
                    this.nextRefAddress = null;
                }
            }
        }

        public Address next() {
            if (this.hasNext()) {
                Address ret = this.nextAddress;
                this.nextAddress = null;
                return ret;
            }
            return null;
        }

        public Iterator<Address> iterator() {
            return this;
        }
    }
}

