/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.exporter.AbstractLineDispenser;
import ghidra.program.model.listing.Variable;
import ghidra.util.StringUtilities;

class CommentLineDispenser
extends AbstractLineDispenser {
    private String[] comments;

    CommentLineDispenser(Variable var, int width, int fillAmount, String prefix) {
        this.comments = StringUtilities.toLines((String)var.getComment());
        this.width = width;
        this.fillAmount = fillAmount;
    }

    @Override
    boolean hasMoreLines() {
        return this.index < this.comments.length;
    }

    @Override
    String getNextLine() {
        if (this.hasMoreLines()) {
            return CommentLineDispenser.clip(this.comments[this.index++], this.width);
        }
        return null;
    }

    @Override
    void dispose() {
    }
}

