/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.CodeItem;
import org.jf.util.IndentingWriter;

public class OffsetInstructionFormatMethodItem
extends InstructionMethodItem<OffsetInstruction> {
    protected LabelMethodItem label;

    public OffsetInstructionFormatMethodItem(MethodDefinition.LabelCache labelCache, CodeItem codeItem, int codeAddress, OffsetInstruction instruction) {
        super(codeItem, codeAddress, instruction);
        this.label = new LabelMethodItem(codeAddress + instruction.getTargetAddressOffset(), this.getLabelPrefix());
        this.label = labelCache.internLabel(this.label);
    }

    @Override
    protected void writeTargetLabel(IndentingWriter writer) throws IOException {
        this.label.writeTo(writer);
    }

    public LabelMethodItem getLabel() {
        return this.label;
    }

    private String getLabelPrefix() {
        switch (((OffsetInstruction)this.instruction).getFormat()) {
            case Format10t: 
            case Format20t: 
            case Format30t: {
                return "goto_";
            }
            case Format21t: 
            case Format22t: {
                return "cond_";
            }
            case Format31t: {
                if (((OffsetInstruction)this.instruction).opcode == Opcode.FILL_ARRAY_DATA) {
                    return "array_";
                }
                if (((OffsetInstruction)this.instruction).opcode == Opcode.PACKED_SWITCH) {
                    return "pswitch_data_";
                }
                assert (((OffsetInstruction)this.instruction).opcode == Opcode.SPARSE_SWITCH);
                return "sswitch_data_";
            }
        }
        assert (false);
        return null;
    }
}

