/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.byteviewer.BlockInfo;
import ghidra.app.plugin.core.byteviewer.ByteField;
import ghidra.app.plugin.core.byteviewer.EmptyByteBlockSet;
import ghidra.app.plugin.core.byteviewer.FieldFactory;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class IndexMap {
    private ByteBlockSet blockSet;
    private TreeMap<BigInteger, BlockInfo> blockInfoMap = new TreeMap();
    private BigInteger numIndexes;
    private BigInteger bytesInLine;

    IndexMap() {
        this(new EmptyByteBlockSet(), 16, 0);
    }

    IndexMap(ByteBlockSet blockSet, int bytesPerLine, int blockOffset) {
        this.blockSet = blockSet;
        ByteBlock[] blocks = blockSet.getBlocks();
        this.bytesInLine = BigInteger.valueOf(bytesPerLine);
        BigInteger nextStart = BigInteger.ZERO;
        for (int i = 0; i < blocks.length; ++i) {
            int blockPadding = (blocks[i].getAlignment(bytesPerLine) + blockOffset) % bytesPerLine;
            BigInteger blockStart = nextStart.add(BigInteger.valueOf(blockPadding));
            BigInteger blockEnd = blockStart.add(blocks[i].getLength());
            int remainder = blockEnd.remainder(this.bytesInLine).intValue();
            BigInteger endIndex = remainder == 0 ? blockEnd : blockEnd.add(BigInteger.valueOf(bytesPerLine - remainder));
            BigInteger endLayoutIndex = endIndex.divide(this.bytesInLine);
            BlockInfo info = new BlockInfo(blocks[i], nextStart, blockStart, blockEnd, endIndex);
            this.blockInfoMap.put(endLayoutIndex, info);
            nextStart = endIndex.add(this.bytesInLine);
        }
        this.numIndexes = nextStart.divide(this.bytesInLine).subtract(BigInteger.ONE);
        if (nextStart.equals(BigInteger.ZERO)) {
            this.numIndexes = BigInteger.ZERO;
        }
    }

    BigInteger getNumIndexes() {
        return this.numIndexes;
    }

    int getBytesPerLine() {
        return this.bytesInLine.intValue();
    }

    ByteBlockInfo getBlockInfo(BigInteger index, int fieldOffset) {
        SortedMap<BigInteger, BlockInfo> tailMap = this.blockInfoMap.tailMap(index);
        if (tailMap.isEmpty()) {
            return null;
        }
        BlockInfo blockInfo = (BlockInfo)tailMap.get(tailMap.firstKey());
        BigInteger byteIndex = index.multiply(this.bytesInLine).add(BigInteger.valueOf(fieldOffset));
        if (byteIndex.compareTo(blockInfo.blockStart) >= 0 && byteIndex.compareTo(blockInfo.blockEnd) < 0) {
            return new ByteBlockInfo(blockInfo.block, byteIndex.subtract(blockInfo.blockStart));
        }
        return null;
    }

    boolean showSeparator(BigInteger index) {
        return this.blockInfoMap.containsKey(index);
    }

    FieldLocation getFieldLocation(ByteBlock block, BigInteger offset, FieldFactory[] factorys) {
        for (BlockInfo blockInfo : this.blockInfoMap.values()) {
            if (blockInfo.block != block) continue;
            BigInteger byteIndex = blockInfo.blockStart.add(offset);
            BigInteger index = byteIndex.divide(this.bytesInLine);
            int lineOffset = byteIndex.remainder(this.bytesInLine).intValue();
            int nbytesPerField = this.bytesInLine.intValue() / factorys.length;
            int fieldOffset = lineOffset / nbytesPerField * nbytesPerField;
            int byteOffset = lineOffset % nbytesPerField;
            int fieldNum = this.getFieldNum(index, fieldOffset, factorys);
            int col = factorys[fieldNum].getColumnPosition(block, byteOffset);
            return new FieldLocation(index, fieldNum, 0, col);
        }
        return null;
    }

    int getFieldOffset(BigInteger index, int fieldNum, FieldFactory[] factorys) {
        int numFields = 0;
        for (int i = 0; i < factorys.length; ++i) {
            ByteField bf = (ByteField)factorys[i].getField(index);
            if (bf == null) continue;
            if (numFields == fieldNum) {
                return factorys[i].getFieldOffset();
            }
            ++numFields;
        }
        return numFields > 0 ? factorys[numFields - 1].getFieldOffset() : 0;
    }

    int getFieldNum(BigInteger index, int fieldOffset, FieldFactory[] factorys) {
        int fieldNum = 0;
        for (int j = 0; j < factorys.length; ++j) {
            ByteField bf = (ByteField)factorys[j].getField(index);
            if (bf == null) continue;
            if (bf.getFieldOffset() == fieldOffset) break;
            ++fieldNum;
        }
        if (fieldNum >= factorys.length) {
            fieldNum = 0;
        }
        return fieldNum;
    }

    ByteBlockSet getByteBlockSet() {
        return this.blockSet;
    }

    public List<ByteBlock> getBlocksBetween(ByteBlockInfo start, ByteBlockInfo end) {
        BlockInfo next;
        ByteBlock startBlock = start.getBlock();
        ByteBlock endBlock = end.getBlock();
        ArrayList<ByteBlock> byteBlocks = new ArrayList<ByteBlock>();
        Iterator<BlockInfo> iterator = this.blockInfoMap.values().iterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            if (next.block != startBlock) continue;
            break;
        }
        while (iterator.hasNext()) {
            next = iterator.next();
            if (next.block == endBlock) break;
            byteBlocks.add(next.block);
        }
        return byteBlocks;
    }
}

