/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.datatype.microsoft.GuidInfo;
import ghidra.app.util.datatype.microsoft.GuidUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import java.io.IOException;

public class PEUtil {
    public static boolean canAnalyze(Program program) {
        String format = program.getExecutableFormat();
        if (format.equals("Portable Executable (PE)")) {
            return true;
        }
        if (format.equals("Raw Binary")) {
            MemoryByteProvider mbp = new MemoryByteProvider(program.getMemory(), program.getAddressFactory().getDefaultAddressSpace());
            try {
                int peHeaderStartIndex;
                int peMagicNumber;
                FactoryBundledWithBinaryReader reader = new FactoryBundledWithBinaryReader((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)mbp, true);
                DOSHeader dosHeader = DOSHeader.createDOSHeader((FactoryBundledWithBinaryReader)reader);
                if (dosHeader.e_magic() == 23117 && (peMagicNumber = reader.readInt((long)(peHeaderStartIndex = dosHeader.e_lfanew()))) == 17744) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static DataType getActualType(DataType dataType) {
        if (dataType instanceof TypeDef) {
            return PEUtil.getActualType(((TypeDef)dataType).getDataType());
        }
        return dataType;
    }

    static boolean isValidPointer(Program program, Address addr) {
        Memory memory = program.getMemory();
        AddressFactory addressFactory = program.getAddressFactory();
        AddressSpace defaultSpace = addressFactory.getDefaultAddressSpace();
        try {
            int addrAsInt = memory.getInt(addr);
            Address pointedToAddr = addressFactory.getAddress(defaultSpace.getBaseSpaceID(), (long)addrAsInt);
            return memory.contains(pointedToAddr);
        }
        catch (MemoryAccessException memoryAccessException) {
            return false;
        }
    }

    static boolean isValidGuidPointer(Program program, Address addr) {
        Memory memory = program.getMemory();
        AddressFactory addressFactory = program.getAddressFactory();
        AddressSpace defaultSpace = addressFactory.getDefaultAddressSpace();
        try {
            GuidInfo guidInfo;
            int addrAsInt = memory.getInt(addr);
            Address pointedToAddr = addressFactory.getAddress(defaultSpace.getBaseSpaceID(), (long)addrAsInt);
            if (memory.contains(pointedToAddr) && (guidInfo = GuidUtil.getKnownGuid((Program)program, (Address)pointedToAddr)) != null) {
                return true;
            }
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return false;
    }

    static long getBytesToEndOfBlock(Program program, Address addr) {
        Memory memory = program.getMemory();
        Address endAddr = memory.getBlock(addr).getEnd();
        return endAddr.subtract(addr);
    }

    static long getBytesToNextReferredToAddress(Program program, Address addr) {
        Address nextAddr;
        AddressIterator refIter = program.getReferenceManager().getReferenceDestinationIterator(addr.add(1L), true);
        if (refIter.hasNext() && (nextAddr = refIter.next()) != null) {
            return nextAddr.subtract(addr);
        }
        return 0L;
    }

    static long getBytesToNextRelocation(Program program, Address addr) {
        Relocation nextReloc = program.getRelocationTable().getRelocationAfter(addr);
        if (nextReloc != null) {
            return nextReloc.getAddress().subtract(addr);
        }
        return 0L;
    }
}

