/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.memstate;

import generic.stl.ComparableMapSTL;
import generic.stl.MapSTL;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryBank;
import ghidra.pcode.memstate.MemoryPage;
import ghidra.program.model.address.AddressSpace;

public class UniqueMemoryBank
extends MemoryBank {
    protected MapSTL<Long, byte[]> map = new ComparableMapSTL();

    public UniqueMemoryBank(AddressSpace spc, boolean isBigEndian) {
        super(spc, isBigEndian, 0, null);
    }

    @Override
    protected MemoryPage getPage(long addr) {
        throw new UnsupportedOperationException("UniqueMemoryBank does not support paging");
    }

    @Override
    protected void setPage(long addr, byte[] val, int skip, int size, int bufOffset) {
        throw new UnsupportedOperationException("UniqueMemoryBank does not support paging");
    }

    @Override
    protected void setPageInitialized(long addr, boolean initialized, int skip, int size, int bufOffset) {
        throw new UnsupportedOperationException("UniqueMemoryBank does not support paging");
    }

    @Override
    public int getChunk(long addrOffset, int size, byte[] res, boolean ignoreFault) {
        byte[] value = (byte[])this.map.get((Object)addrOffset);
        if (value == null) {
            throw new LowlevelError("Unique value read before written: 0x" + Long.toHexString(addrOffset));
        }
        if (value.length != size) {
            throw new LowlevelError("Unique value size mismatch: 0x" + Long.toHexString(addrOffset));
        }
        System.arraycopy(value, 0, res, 0, size);
        return size;
    }

    @Override
    public void setChunk(long offset, int size, byte[] val) {
        byte[] value = new byte[size];
        System.arraycopy(val, 0, value, 0, size);
        this.map.put((Object)offset, (Object)value);
    }

    public void clear() {
        this.map.clear();
    }
}

